/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.imm_ptl_peripheral.alternate_dimension;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.ChaosBiomeSource;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.ErrorTerrainGenerator;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.api.IPDimensionAPI;
import com.qouteall.immersive_portals.ducks.IEWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2088;
import net.minecraft.class_2246;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5311;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;

public class AlternateDimensions {
    public static final class_5321<class_5363> alternate1Option = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)new class_2960("immersive_portals:alternate1"));
    public static final class_5321<class_5363> alternate2Option = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)new class_2960("immersive_portals:alternate2"));
    public static final class_5321<class_5363> alternate3Option = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)new class_2960("immersive_portals:alternate3"));
    public static final class_5321<class_5363> alternate4Option = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)new class_2960("immersive_portals:alternate4"));
    public static final class_5321<class_5363> alternate5Option = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)new class_2960("immersive_portals:alternate5"));
    public static final class_5321<class_2874> surfaceType = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960("immersive_portals:surface_type"));
    public static final class_5321<class_1937> alternate1 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate1"));
    public static final class_5321<class_1937> alternate2 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate2"));
    public static final class_5321<class_1937> alternate3 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate3"));
    public static final class_5321<class_1937> alternate4 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate4"));
    public static final class_5321<class_1937> alternate5 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960("immersive_portals:alternate5"));

    public static void init() {
        IPDimensionAPI.onServerWorldInit.connect(AlternateDimensions::initializeAlternateDimensions);
        ModMain.postServerTickSignal.connect(AlternateDimensions::tick);
    }

    private static void initializeAlternateDimensions(class_5285 generatorOptions, class_5455 registryManager) {
        class_2370 registry = generatorOptions.method_28609();
        long seed = generatorOptions.method_28028();
        if (!Global.enableAlternateDimensions) {
            return;
        }
        class_2874 surfaceTypeObject = (class_2874)registryManager.method_30530(class_2378.field_25095).method_10223(new class_2960("immersive_portals:surface_type"));
        if (surfaceTypeObject == null) {
            Helper.err((Object)"Missing dimension type immersive_portals:surface_type");
            return;
        }
        IPDimensionAPI.addDimension((long)seed, (class_2370)registry, (class_2960)alternate1Option.method_29177(), () -> surfaceTypeObject, (class_2794)AlternateDimensions.createSkylandGenerator(seed + 1L, registryManager));
        IPDimensionAPI.markDimensionNonPersistent((class_2960)alternate1Option.method_29177());
        IPDimensionAPI.addDimension((long)seed, (class_2370)registry, (class_2960)alternate2Option.method_29177(), () -> surfaceTypeObject, (class_2794)AlternateDimensions.createSkylandGenerator(seed, registryManager));
        IPDimensionAPI.markDimensionNonPersistent((class_2960)alternate2Option.method_29177());
        IPDimensionAPI.addDimension((long)seed, (class_2370)registry, (class_2960)alternate3Option.method_29177(), () -> surfaceTypeObject, (class_2794)AlternateDimensions.createErrorTerrainGenerator(seed + 1L, registryManager));
        IPDimensionAPI.markDimensionNonPersistent((class_2960)alternate3Option.method_29177());
        IPDimensionAPI.addDimension((long)seed, (class_2370)registry, (class_2960)alternate4Option.method_29177(), () -> surfaceTypeObject, (class_2794)AlternateDimensions.createErrorTerrainGenerator(seed, registryManager));
        IPDimensionAPI.markDimensionNonPersistent((class_2960)alternate4Option.method_29177());
        IPDimensionAPI.addDimension((long)seed, (class_2370)registry, (class_2960)alternate5Option.method_29177(), () -> surfaceTypeObject, (class_2794)AlternateDimensions.createVoidGenerator(registryManager));
        IPDimensionAPI.markDimensionNonPersistent((class_2960)alternate5Option.method_29177());
    }

    public static boolean isAlternateDimension(class_1937 world) {
        class_5321 key = world.method_27983();
        return key == alternate1 || key == alternate2 || key == alternate3 || key == alternate4 || key == alternate5;
    }

    private static void syncWithOverworldTimeWeather(class_3218 world, class_3218 overworld) {
        ((IEWorld)world).portal_setWeather(overworld.method_8430(1.0f), overworld.method_8430(1.0f), overworld.method_8478(1.0f), overworld.method_8478(1.0f));
    }

    public static class_2794 createSkylandGenerator(long seed, class_5455 rm) {
        class_2385 biomeRegistry = rm.method_30530(class_2378.field_25114);
        class_2088 biomeSource = new class_2088(seed, false, false, (class_2378)biomeRegistry);
        class_2385 settingsRegistry = rm.method_30530(class_2378.field_26374);
        HashMap structureMap = new HashMap();
        structureMap.putAll(class_5311.field_24822);
        structureMap.remove(class_3195.field_24844);
        structureMap.remove(class_3195.field_24852);
        class_5311 structuresConfig = new class_5311(Optional.empty(), structureMap);
        class_5284 skylandSetting = class_5284.method_30642((class_5311)structuresConfig, (class_2680)class_2246.field_10340.method_9564(), (class_2680)class_2246.field_10382.method_9564(), (class_2960)new class_2960("imm_ptl:skyland_gen_id"), (boolean)false, (boolean)false);
        return new class_3754((class_1966)biomeSource, seed, () -> skylandSetting);
    }

    public static class_2794 createErrorTerrainGenerator(long seed, class_5455 rm) {
        class_2385 biomeRegistry = rm.method_30530(class_2378.field_25114);
        ChaosBiomeSource chaosBiomeSource = new ChaosBiomeSource(seed, (class_2378<class_1959>)biomeRegistry);
        return new ErrorTerrainGenerator(seed, chaosBiomeSource);
    }

    public static class_2794 createVoidGenerator(class_5455 rm) {
        class_2385 biomeRegistry = rm.method_30530(class_2378.field_25114);
        class_5311 structuresConfig = new class_5311(Optional.of(class_5311.field_24823), (Map)Maps.newHashMap((Map)ImmutableMap.of()));
        class_3232 flatChunkGeneratorConfig = new class_3232(structuresConfig, (class_2378)biomeRegistry);
        flatChunkGeneratorConfig.method_14327().add(new class_3229(1, class_2246.field_10124));
        flatChunkGeneratorConfig.method_14330();
        return new class_2897(flatChunkGeneratorConfig);
    }

    private static void tick() {
        if (!Global.enableAlternateDimensions) {
            return;
        }
        class_3218 overworld = McHelper.getServerWorld((class_5321)class_1937.field_25179);
        AlternateDimensions.syncWithOverworldTimeWeather(McHelper.getServerWorld(alternate1), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(McHelper.getServerWorld(alternate2), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(McHelper.getServerWorld(alternate3), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(McHelper.getServerWorld(alternate4), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(McHelper.getServerWorld(alternate5), overworld);
    }
}

