/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.imm_ptl_peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.ChaosBiomeSource;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.RegionErrorTerrainGenerator;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.my_util.LimitedLogger;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3021;
import net.minecraft.class_3098;
import net.minecraft.class_3116;
import net.minecraft.class_3188;
import net.minecraft.class_3195;
import net.minecraft.class_3223;
import net.minecraft.class_3233;
import net.minecraft.class_3543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5311;
import net.minecraft.class_5425;

public class ErrorTerrainGenerator
extends class_2794 {
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(g -> g.worldSeed), (App)ChaosBiomeSource.codec.fieldOf("biomeSource").stable().forGetter(o -> (ChaosBiomeSource)o.method_12098())).apply((Applicative)instance, instance.stable(ErrorTerrainGenerator::new)));
    private final class_2680 air = class_2246.field_10124.method_9564();
    private final class_2680 defaultBlock = class_2246.field_10340.method_9564();
    private final class_2680 defaultFluid = class_2246.field_10382.method_9564();
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private static final class_4966 verticalBlockSample = new class_4966((class_2680[])Stream.concat(Stream.generate(() -> ((class_2248)class_2246.field_10340).method_9564()).limit(64L), Stream.generate(() -> ((class_2248)class_2246.field_10124).method_9564()).limit(192L)).toArray(class_2680[]::new));
    private long worldSeed;
    private final LoadingCache<class_1923, RegionErrorTerrainGenerator> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<class_1923, RegionErrorTerrainGenerator>(){

        public RegionErrorTerrainGenerator load(class_1923 key) {
            return new RegionErrorTerrainGenerator(key.field_9181, key.field_9180, ErrorTerrainGenerator.this.worldSeed);
        }
    });
    private final class_3543 surfaceDepthNoise;
    private static final LimitedLogger limitedLogger = new LimitedLogger(5);

    public ErrorTerrainGenerator(long seed, class_1966 biomeSource) {
        super(biomeSource, new class_5311(true));
        this.worldSeed = seed;
        this.surfaceDepthNoise = new class_3543(new class_2919(seed), IntStream.rangeClosed(-3, 0));
    }

    private static double getProbability(class_3195<?> structureFeature) {
        if (structureFeature instanceof class_3188) {
            return 7.0E-4;
        }
        if (structureFeature instanceof class_3098) {
            return 0.015;
        }
        if (structureFeature instanceof class_3116) {
            return 0.03;
        }
        if (structureFeature instanceof class_3223) {
            return 0.08;
        }
        if (structureFeature instanceof class_3021) {
            return 0.2;
        }
        return 0.15;
    }

    public void method_12107(class_3233 region) {
        int i = region.method_14336();
        int j = region.method_14339();
        class_1959 biome = region.method_23753(new class_1923(i, j).method_8323());
        class_2919 chunkRandom = new class_2919();
        chunkRandom.method_12661(region.method_8412(), i << 4, j << 4);
        class_1948.method_8661((class_5425)region, (class_1959)biome, (int)i, (int)j, (Random)chunkRandom);
    }

    public void method_12088(class_1936 world, class_5138 accessor, class_2791 chunk) {
        class_2839 protoChunk = (class_2839)chunk;
        class_1923 pos = chunk.method_12004();
        class_2902 oceanFloorHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int regionX = Math.floorDiv(pos.field_9181, 4);
        int regionZ = Math.floorDiv(pos.field_9180, 4);
        RegionErrorTerrainGenerator generator = (RegionErrorTerrainGenerator)Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new class_1923(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            class_2826 section = protoChunk.method_16679(sectionY);
            section.method_16676();
            for (int localX = 0; localX < 16; ++localX) {
                for (int localY = 0; localY < 16; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        int worldX = pos.field_9181 * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.field_9180 * 16 + localZ;
                        class_2680 currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.method_12256(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                    }
                }
            }
            section.method_16677();
        }
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmapType) {
        return 64;
    }

    public int method_12104() {
        return 128;
    }

    public int method_16398() {
        return 63;
    }

    public class_1922 method_26261(int x, int z) {
        return verticalBlockSample;
    }

    protected Codec<? extends class_2794> method_28506() {
        return codec;
    }

    public class_2794 method_27997(long seed) {
        return new ErrorTerrainGenerator(seed, this.method_12098().method_27985(seed));
    }

    public void method_12110(class_3233 region, class_2791 chunk) {
        try {
            class_1923 chunkPos = chunk.method_12004();
            int i = chunkPos.field_9181;
            int j = chunkPos.field_9180;
            class_2919 chunkRandom = new class_2919();
            chunkRandom.method_12659(i, j);
            class_1923 chunkPos2 = chunk.method_12004();
            int k = chunkPos2.method_8326();
            int l = chunkPos2.method_8328();
            double d = 0.0625;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int m = 0; m < 16; ++m) {
                for (int n = 0; n < 16; ++n) {
                    int o = k + m;
                    int p = l + n;
                    int q = chunk.method_12005(class_2902.class_2903.field_13194, m, n) + 1;
                    double e = this.surfaceDepthNoise.method_16454((double)o * 0.0625, (double)p * 0.0625, 0.0625, (double)m * 0.0625) * 15.0;
                    region.method_23753((class_2338)mutable.method_10103(k + m, q, l + n)).method_8703((Random)chunkRandom, chunk, o, p, q, e, this.defaultBlock, this.defaultFluid, this.method_16398(), region.method_8412());
                }
            }
            ErrorTerrainGenerator.avoidSandLag(region);
        }
        catch (Throwable e) {
            limitedLogger.invoke(e::printStackTrace);
        }
    }

    private static void avoidSandLag(class_3233 region) {
        class_2791 centerChunk = region.method_8392(region.method_14336(), region.method_14339());
        class_2338.class_2339 temp = new class_2338.class_2339();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                boolean isLastAir = true;
                for (int y = 0; y < 100; ++y) {
                    temp.method_10103(x, y, z);
                    class_2680 blockState = centerChunk.method_8320((class_2338)temp);
                    class_2248 block = blockState.method_26204();
                    if ((block == class_2246.field_10102 || block == class_2246.field_10255) && isLastAir) {
                        centerChunk.method_12010((class_2338)temp, class_2246.field_9979.method_9564(), true);
                    }
                    isLastAir = blockState.method_26215();
                }
            }
        }
    }
}

