/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.imm_ptl_peripheral.altius_world;

import com.qouteall.imm_ptl_peripheral.altius_world.AltiusEntry;
import com.qouteall.imm_ptl_peripheral.altius_world.AltiusGameRule;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.api.PortalAPI;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.VerticalConnectingPortal;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;

public class AltiusInfo {
    public final boolean loop;
    public final List<AltiusEntry> entries;

    public AltiusInfo(List<AltiusEntry> entries, boolean loop) {
        this.entries = entries;
        this.loop = loop;
    }

    public static void initializeFuseViewProperty(Portal portal) {
        if (portal.field_6002.method_8597().method_12491() && portal.getNormal().field_1351 < 0.0) {
            portal.fuseView = true;
        }
    }

    public static void createConnectionBetween(AltiusEntry a, AltiusEntry b) {
        class_3218 fromWorld = McHelper.getServerWorld(a.dimension);
        class_3218 toWorld = McHelper.getServerWorld(b.dimension);
        boolean xorFlipped = a.flipped ^ b.flipped;
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal((class_3218)fromWorld, (VerticalConnectingPortal.ConnectorType)(a.flipped ? VerticalConnectingPortal.ConnectorType.ceil : VerticalConnectingPortal.ConnectorType.floor), (class_3218)toWorld, (double)(b.scale / a.scale), (boolean)xorFlipped, (double)(b.horizontalRotation - a.horizontalRotation));
        VerticalConnectingPortal reverse = (VerticalConnectingPortal)PortalAPI.createReversePortal((Portal)connectingPortal);
        AltiusInfo.initializeFuseViewProperty((Portal)connectingPortal);
        AltiusInfo.initializeFuseViewProperty((Portal)reverse);
        PortalAPI.addGlobalPortal((class_3218)fromWorld, (Portal)connectingPortal);
        PortalAPI.addGlobalPortal((class_3218)toWorld, (Portal)reverse);
    }

    public void createPortals() {
        if (this.entries.isEmpty()) {
            McHelper.sendMessageToFirstLoggedPlayer((class_2561)new class_2585("Error: No dimension for dimension stack"));
            return;
        }
        if (!McHelper.getGlobalPortals((class_1937)McHelper.getServerWorld(this.entries.get((int)0).dimension)).isEmpty()) {
            Helper.err((Object)"There are already global portals when initializing dimension stack");
            return;
        }
        Helper.wrapAdjacentAndMap(this.entries.stream(), (before, after) -> {
            AltiusInfo.createConnectionBetween(before, after);
            return null;
        }).forEach(k -> {});
        if (this.loop) {
            AltiusInfo.createConnectionBetween(this.entries.get(this.entries.size() - 1), this.entries.get(0));
        }
        McHelper.sendMessageToFirstLoggedPlayer((class_2561)new class_2588("imm_ptl.dim_stack_initialized"));
    }

    public static void replaceBedrock(class_3218 world, class_2791 chunk) {
        if (AltiusGameRule.getIsDimensionStack()) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < chunk.method_8322(); ++y) {
                        mutable.method_10103(x, y, z);
                        class_2680 blockState = chunk.method_8320((class_2338)mutable);
                        if (blockState.method_26204() != class_2246.field_9987) continue;
                        chunk.method_12010((class_2338)mutable, class_2246.field_10540.method_9564(), false);
                    }
                }
            }
        }
    }
}

