/*
 * Decompiled with CFR 0.152.
 */
package net.spyman.backpackmod.common.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.spyman.backpackmod.common.init.BackpackRecipes;

public class ShapedRecipeCopyNBT
extends class_1869 {
    private final int targetSlot;
    private final String group;

    public ShapedRecipeCopyNBT(class_2960 id, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 output, int targetSlot) {
        super(id, group, width, height, ingredients, output);
        this.targetSlot = targetSlot;
        this.group = group;
    }

    public class_1799 method_17727(class_1715 matrix) {
        if (this.targetSlot < 0 || this.targetSlot >= matrix.method_5439()) {
            throw new IllegalArgumentException("ShapedRecipeCopyNBT: wrong value for 'target_slot' key, specify the slot the itemstack to copy NBT is");
        }
        class_1799 stack = matrix.method_5438(this.targetSlot);
        if (!stack.method_7960()) {
            class_1799 out = super.method_17727(matrix);
            if (stack.method_7985()) {
                out.method_7948().method_10543(stack.method_7969());
            }
            return out;
        }
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return BackpackRecipes.BACKPACK_UPGRADE;
    }

    public int targetSlot() {
        return this.targetSlot;
    }

    public String group() {
        return this.group;
    }

    public static final class Serializer
    implements class_1865<ShapedRecipeCopyNBT> {
        public ShapedRecipeCopyNBT read(class_2960 identifier, JsonObject obj) {
            String group = class_3518.method_15253((JsonObject)obj, (String)"group", (String)"");
            Map<String, class_1856> map = Serializer.getComponents(class_3518.method_15296((JsonObject)obj, (String)"key"));
            String[] pattern = Serializer.combinePattern(Serializer.getPattern(class_3518.method_15261((JsonObject)obj, (String)"pattern")));
            int i = pattern[0].length();
            int j = pattern.length;
            class_2371<class_1856> inputs = Serializer.getIngredients(pattern, map, i, j);
            class_1799 output = class_1869.method_8155((JsonObject)class_3518.method_15296((JsonObject)obj, (String)"result"));
            return new ShapedRecipeCopyNBT(identifier, group, i, j, inputs, output, obj.get("target_slot").getAsInt());
        }

        public ShapedRecipeCopyNBT read(class_2960 identifier, class_2540 buf) {
            int i = buf.method_10816();
            int j = buf.method_10816();
            String string = buf.method_10800(Short.MAX_VALUE);
            class_2371 inputs = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < inputs.size(); ++k) {
                inputs.set(k, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1799 output = buf.method_10819();
            return new ShapedRecipeCopyNBT(identifier, string, i, j, (class_2371<class_1856>)inputs, output, buf.readInt());
        }

        public void write(class_2540 buf, ShapedRecipeCopyNBT recipe) {
            buf.method_10804(recipe.method_8150());
            buf.method_10804(recipe.method_8158());
            buf.method_10814(recipe.group());
            recipe.method_8117().forEach(i -> i.method_8088(buf));
            buf.method_10793(recipe.method_8110());
            buf.writeInt(recipe.targetSlot());
        }

        private static String[] getPattern(JsonArray json) {
            String[] strings = new String[json.size()];
            if (strings.length > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            if (strings.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int i = 0; i < strings.length; ++i) {
                String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
                if (string.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (i > 0 && strings[0].length() != string.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                strings[i] = string;
            }
            return strings;
        }

        public static Map<String, class_1856> getComponents(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put(entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", class_1856.field_9017);
            return map;
        }

        public static class_2371<class_1856> getIngredients(String[] pattern, Map<String, class_1856> key, int width, int height) {
            class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            HashSet set = Sets.newHashSet(key.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    String string = pattern[i].substring(j, j + 1);
                    class_1856 ingredient = key.get(string);
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                    }
                    set.remove(string);
                    defaultedList.set(j + width * i, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return defaultedList;
        }

        public static int findNextIngredient(String pattern) {
            int i;
            for (i = 0; i < pattern.length() && pattern.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        public static int findNextIngredientReverse(String pattern) {
            int i;
            for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
            }
            return i;
        }

        public static String[] combinePattern(String ... lines) {
            int i = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int m = 0; m < lines.length; ++m) {
                String string = lines[m];
                i = Math.min(i, Serializer.findNextIngredient(string));
                int n = Serializer.findNextIngredientReverse(string);
                j = Math.max(j, n);
                if (n < 0) {
                    if (k == m) {
                        ++k;
                    }
                    ++l;
                    continue;
                }
                l = 0;
            }
            if (lines.length == l) {
                return new String[0];
            }
            String[] strings = new String[lines.length - l - k];
            for (int o = 0; o < strings.length; ++o) {
                strings[o] = lines[o + k].substring(i, j + 1);
            }
            return strings;
        }
    }
}

