/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultrusbot.moborigins.entity.slime;

import io.github.ultrusbot.moborigins.entity.EntityRegistry;
import io.github.ultrusbot.moborigins.entity.slime.OriginSlimeAttackWithOwnerGoal;
import io.github.ultrusbot.moborigins.entity.slime.OriginSlimeFollowOwnerGoal;
import io.github.ultrusbot.moborigins.entity.slime.OriginSlimeTrackOwnerAttackerGoal;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1548;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2919;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class OriginSlimeEntity
extends class_1308
implements class_1569 {
    private static final class_2940<Integer> SLIME_SIZE = class_2945.method_12791(OriginSlimeEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(class_1321.class, (class_2941)class_2943.field_13313);
    public float targetStretch;
    public float stretch;
    public float lastStretch;
    private boolean onGroundLastTick;

    public OriginSlimeEntity(class_1299<? extends OriginSlimeEntity> entityType, class_1937 world) {
        super(EntityRegistry.ORIGIN_SLIME, world);
        this.field_6207 = new SlimeMoveControl(this);
    }

    public OriginSlimeEntity(class_1937 world, double x, double y, double z) {
        this(EntityRegistry.ORIGIN_SLIME, world);
        this.method_5814(x, y, z);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SwimmingGoal(this));
        this.field_6201.method_6277(2, (class_1352)new FaceTowardTargetGoal(this));
        this.field_6201.method_6277(3, (class_1352)new RandomLookGoal(this));
        this.field_6201.method_6277(5, (class_1352)new MoveGoal(this));
        this.field_6201.method_6277(6, (class_1352)new OriginSlimeFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.field_6185.method_6277(1, (class_1352)new OriginSlimeTrackOwnerAttackerGoal(this));
        this.field_6185.method_6277(2, (class_1352)new OriginSlimeAttackWithOwnerGoal(this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLIME_SIZE, (Object)1);
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
    }

    public void setSize(int size, boolean heal) {
        this.field_6011.method_12778(SLIME_SIZE, (Object)size);
        this.method_23311();
        this.method_18382();
        this.method_5996(class_5134.field_23716).method_6192((double)(size * size));
        this.method_5996(class_5134.field_23719).method_6192((double)(0.2f + 0.1f * (float)size));
        this.method_5996(class_5134.field_23721).method_6192((double)size);
        if (heal) {
            this.method_6033(this.method_6063());
        }
        this.field_6194 = 0;
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(SLIME_SIZE);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Size", this.getSize() - 1);
        tag.method_10556("wasOnGround", this.onGroundLastTick);
        if (this.getOwnerUuid() != null) {
            tag.method_25927("Owner", this.getOwnerUuid());
        }
    }

    public void method_5749(class_2487 tag) {
        UUID uUID2;
        int i = tag.method_10550("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSize(i + 1, false);
        super.method_5749(tag);
        this.onGroundLastTick = tag.method_10577("wasOnGround");
        if (tag.method_25928("Owner")) {
            uUID2 = tag.method_25926("Owner");
        } else {
            String string = tag.method_10558("Owner");
            uUID2 = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (uUID2 != null) {
            try {
                this.setOwnerUuid(uUID2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(class_1657 player) {
        this.setOwnerUuid(player.method_5667());
    }

    public boolean canAttackWithOwner(class_1309 target, class_1309 owner) {
        if (!(target instanceof class_1548) && !(target instanceof class_1571)) {
            if (target instanceof class_1493) {
                class_1493 wolfEntity = (class_1493)target;
                return !wolfEntity.method_6181() || wolfEntity.method_6177() != owner;
            }
            if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
                return false;
            }
            if (target instanceof class_1496 && ((class_1496)target).method_6727()) {
                return false;
            }
            return !(target instanceof class_1321) || !((class_1321)target).method_6181();
        }
        return false;
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uUID = this.getOwnerUuid();
            return uUID == null ? null : this.field_6002.method_18470(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean method_18395(class_1309 target) {
        return this.isOwner(target) ? false : super.method_18395(target);
    }

    public boolean isOwner(class_1309 entity) {
        return entity == this.getOwner();
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void method_6078(class_1282 source) {
        if (!this.field_6002.field_9236 && this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
            this.getOwner().method_9203(this.method_6066().method_5548(), class_156.field_25140);
        }
        super.method_6078(source);
    }

    public boolean isSmall() {
        return this.getSize() <= 1;
    }

    protected class_2394 getParticles() {
        return class_2398.field_11246;
    }

    protected boolean method_23734() {
        return this.getSize() > 0;
    }

    public void method_5773() {
        this.stretch += (this.targetStretch - this.stretch) * 0.5f;
        this.lastStretch = this.stretch;
        super.method_5773();
        if (this.field_5952 && !this.onGroundLastTick) {
            int i = this.getSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_5974.nextFloat() * ((float)Math.PI * 2);
                float g = this.field_5974.nextFloat() * 0.5f + 0.5f;
                float h = class_3532.method_15374((float)f) * (float)i * 0.5f * g;
                float k = class_3532.method_15362((float)f) * (float)i * 0.5f * g;
                this.field_6002.method_8406(this.getParticles(), this.method_23317() + (double)h, this.method_23318(), this.method_23321() + (double)k, 0.0, 0.0, 0.0);
            }
            this.method_5783(this.getSquishSound(), this.method_6107(), ((this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.targetStretch = -0.5f;
        } else if (!this.field_5952 && this.onGroundLastTick) {
            this.targetStretch = 1.0f;
        }
        this.onGroundLastTick = this.field_5952;
        this.updateStretch();
    }

    protected void updateStretch() {
        this.targetStretch *= 0.6f;
    }

    protected int getTicksUntilNextJump() {
        return this.field_5974.nextInt(20) + 10;
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public void method_5674(class_2940<?> data) {
        if (SLIME_SIZE.equals(data)) {
            this.method_18382();
            this.field_6031 = this.field_6241;
            this.field_6283 = this.field_6241;
            if (this.method_5799() && this.field_5974.nextInt(20) == 0) {
                this.method_5746();
            }
        }
        super.method_5674(data);
    }

    public class_1299<? extends OriginSlimeEntity> method_5864() {
        return super.method_5864();
    }

    public void method_5650() {
        int i = this.getSize();
        if (!this.field_6002.field_9236 && i > 1 && this.method_29504()) {
            class_2561 text = this.method_5797();
            boolean bl = this.method_5987();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.field_5974.nextInt(3);
            for (int l = 0; l < k; ++l) {
                float g = ((float)(l % 2) - 0.5f) * f;
                float h = ((float)(l / 2) - 0.5f) * f;
                OriginSlimeEntity slimeEntity = (OriginSlimeEntity)this.method_5864().method_5883(this.field_6002);
                if (this.method_5947()) {
                    slimeEntity.method_5971();
                }
                slimeEntity.method_5665(text);
                slimeEntity.method_5977(bl);
                slimeEntity.setOwnerUuid(this.getOwnerUuid());
                slimeEntity.method_5684(this.method_5655());
                slimeEntity.setSize(j, true);
                slimeEntity.method_5808(this.method_23317() + (double)g, this.method_23318() + 0.5, this.method_23321() + (double)h, this.field_5974.nextFloat() * 360.0f, 0.0f);
                this.field_6002.method_8649((class_1297)slimeEntity);
            }
        }
        super.method_5650();
    }

    public void method_5697(class_1297 entity) {
        super.method_5697(entity);
        if (this.canAttackWithOwner((class_1309)entity, this.getOwner()) && this.canAttack() && !(entity instanceof OriginSlimeEntity)) {
            this.damage((class_1309)entity);
        }
    }

    public void method_5694(class_1657 player) {
        if (this.canAttack() && !this.isOwner((class_1309)player)) {
            this.damage((class_1309)player);
        }
    }

    protected void damage(class_1309 target) {
        if (this.method_5805()) {
            int i = this.getSize();
            if (this.method_5858((class_1297)target) < 0.6 * (double)i * 0.6 * (double)i && this.method_6057((class_1297)target) && target.method_5643(class_1282.method_5511((class_1309)this), this.getDamageAmount())) {
                this.method_5783(class_3417.field_14863, 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
                this.method_5723((class_1309)this, (class_1297)target);
            }
        }
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.625f * dimensions.field_18068;
    }

    protected boolean canAttack() {
        return true;
    }

    protected float getDamageAmount() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.isSmall() ? class_3417.field_14620 : class_3417.field_15014;
    }

    protected class_3414 method_6002() {
        return this.isSmall() ? class_3417.field_14849 : class_3417.field_14763;
    }

    protected class_3414 getSquishSound() {
        return this.isSmall() ? class_3417.field_15148 : class_3417.field_15095;
    }

    protected class_2960 method_5991() {
        return this.getSize() == 1 ? this.method_5864().method_16351() : class_39.field_844;
    }

    public static boolean canSpawn(class_1299<OriginSlimeEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        if (world.method_8407() != class_1267.field_5801) {
            boolean bl;
            if (Objects.equals(world.method_31081(pos), Optional.of(class_1972.field_9471)) && pos.method_10264() > 50 && pos.method_10264() < 70 && random.nextFloat() < 0.5f && random.nextFloat() < world.method_30272() && world.method_22339(pos) <= random.nextInt(8)) {
                return OriginSlimeEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
            }
            if (!(world instanceof class_5281)) {
                return false;
            }
            class_1923 chunkPos = new class_1923(pos);
            boolean bl2 = bl = class_2919.method_12662((int)chunkPos.field_9181, (int)chunkPos.field_9180, (long)((class_5281)world).method_8412(), (long)987234911L).nextInt(10) == 0;
            if (random.nextInt(10) == 0 && bl && pos.method_10264() < 40) {
                return OriginSlimeEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
            }
        }
        return false;
    }

    protected float method_6107() {
        return 0.4f * (float)this.getSize();
    }

    public int method_5978() {
        return 0;
    }

    protected boolean makesJumpSound() {
        return this.getSize() > 0;
    }

    protected void method_6043() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, this.method_6106(), vec3d.field_1350);
        this.field_6007 = true;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        int i = this.field_5974.nextInt(3);
        if (i < 2 && this.field_5974.nextFloat() < 0.5f * difficulty.method_5458()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j, true);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    private float getJumpSoundPitch() {
        float f = this.isSmall() ? 1.4f : 0.8f;
        return ((this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f) * f;
    }

    protected class_3414 getJumpSound() {
        return this.isSmall() ? class_3417.field_14694 : class_3417.field_14919;
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383(0.255f * (float)this.getSize());
    }

    static class SlimeMoveControl
    extends class_1335 {
        private float targetYaw;
        private int ticksUntilJump;
        private final OriginSlimeEntity slime;
        private boolean jumpOften;

        public SlimeMoveControl(OriginSlimeEntity slime) {
            super((class_1308)slime);
            this.slime = slime;
            this.targetYaw = 180.0f * slime.field_6031 / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.field_6372 = speed;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void method_6240() {
            this.field_6371.field_6241 = this.field_6371.field_6031 = this.method_6238(this.field_6371.field_6031, this.targetYaw, 90.0f);
            this.field_6371.field_6283 = this.field_6371.field_6031;
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.field_6371.method_24828()) {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = this.slime.getTicksUntilNextJump();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        this.slime.method_5993().method_6233();
                        if (this.slime.makesJumpSound()) {
                            this.slime.method_5783(this.slime.getJumpSound(), this.slime.method_6107(), this.slime.getJumpSoundPitch());
                        }
                    } else {
                        this.slime.field_6212 = 0.0f;
                        this.slime.field_6250 = 0.0f;
                        this.field_6371.method_6125(0.0f);
                    }
                } else {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                }
            }
        }
    }

    static class FaceTowardTargetGoal
    extends class_1352 {
        private final OriginSlimeEntity slime;
        private int ticksLeft;

        public FaceTowardTargetGoal(OriginSlimeEntity slime) {
            this.slime = slime;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.slime.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            return livingEntity instanceof class_1657 && ((class_1657)livingEntity).field_7503.field_7480 ? false : this.slime.method_5962() instanceof SlimeMoveControl;
        }

        public void method_6269() {
            this.ticksLeft = 300;
            super.method_6269();
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.slime.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (livingEntity instanceof class_1657 && ((class_1657)livingEntity).field_7503.field_7480) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void method_6268() {
            this.slime.method_5951((class_1297)this.slime.method_5968(), 10.0f, 10.0f);
            ((SlimeMoveControl)this.slime.method_5962()).look(this.slime.field_6031, this.slime.canAttack());
        }
    }

    static class RandomLookGoal
    extends class_1352 {
        private final OriginSlimeEntity slime;
        private float targetYaw;
        private int timer;

        public RandomLookGoal(OriginSlimeEntity slime) {
            this.slime = slime;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.slime.method_5968() == null && (this.slime.field_5952 || this.slime.method_5799() || this.slime.method_5771() || this.slime.method_6059(class_1294.field_5902)) && this.slime.method_5962() instanceof SlimeMoveControl;
        }

        public void method_6268() {
            if (--this.timer <= 0) {
                this.timer = 40 + this.slime.method_6051().nextInt(60);
                this.targetYaw = this.slime.method_6051().nextInt(360);
            }
            ((SlimeMoveControl)this.slime.method_5962()).look(this.targetYaw, false);
        }
    }

    static class SwimmingGoal
    extends class_1352 {
        private final OriginSlimeEntity slime;

        public SwimmingGoal(OriginSlimeEntity slime) {
            this.slime = slime;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
            slime.method_5942().method_6354(true);
        }

        public boolean method_6264() {
            return (this.slime.method_5799() || this.slime.method_5771()) && this.slime.method_5962() instanceof SlimeMoveControl;
        }

        public void method_6268() {
            if (this.slime.method_6051().nextFloat() < 0.8f) {
                this.slime.method_5993().method_6233();
            }
            ((SlimeMoveControl)this.slime.method_5962()).move(1.2);
        }
    }

    static class MoveGoal
    extends class_1352 {
        private final OriginSlimeEntity slime;

        public MoveGoal(OriginSlimeEntity slime) {
            this.slime = slime;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !this.slime.method_5765();
        }

        public void method_6268() {
            ((SlimeMoveControl)this.slime.method_5962()).move(1.0);
        }
    }
}

