/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.hydrogen.common.collections;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.ArrayUtils;

public class FixedArrayList<T>
implements List<T> {
    private final T[] array;

    public FixedArrayList(List<T> list) {
        this(list.toArray(new Object[0]));
    }

    public FixedArrayList(T[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return ArrayUtils.contains((Object[])this.array, (Object)o);
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.forArray((Object[])this.array);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T1> T1[] toArray(T1[] dst) {
        T[] src = this.array;
        if (dst.length < src.length) {
            return Arrays.copyOf(src, src.length, dst.getClass());
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        if (dst.length > src.length) {
            dst[src.length] = null;
        }
        return dst;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (ArrayUtils.contains((Object[])this.array, o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return ArrayUtils.indexOf((Object[])this.array, (Object)o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ArrayUtils.lastIndexOf((Object[])this.array, (Object)o);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

