/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement;

import me.jellysquid.mods.lithium.common.shapes.VoxelShapeCaster;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3980;

public class BlockCollisionSweeper {
    private final class_2338.class_2339 mpos = new class_2338.class_2339();
    private final class_238 box;
    private final class_265 shape;
    private final class_1941 view;
    private final class_3726 context;
    private final class_3980 cuboidIt;
    private class_265 collidedShape;

    public BlockCollisionSweeper(class_1941 view, class_1297 entity, class_238 box) {
        this.box = box;
        this.shape = class_259.method_1078((class_238)box);
        this.context = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity);
        this.view = view;
        this.cuboidIt = BlockCollisionSweeper.createVolumeIteratorForCollision(box);
    }

    public boolean step() {
        class_265 collisionShape;
        this.collidedShape = null;
        class_3980 cuboidIt = this.cuboidIt;
        if (!cuboidIt.method_17963()) {
            return false;
        }
        int edgesHit = cuboidIt.method_20789();
        if (edgesHit == 3) {
            return true;
        }
        int x = cuboidIt.method_18671();
        int y = cuboidIt.method_18672();
        int z = cuboidIt.method_18673();
        class_1922 chunk = this.view.method_22338(x >> 4, z >> 4);
        if (chunk == null) {
            return true;
        }
        class_2338.class_2339 mpos = this.mpos;
        mpos.method_10103(x, y, z);
        class_2680 state = chunk.method_8320((class_2338)mpos);
        if (BlockCollisionSweeper.canInteractWithBlock(state, edgesHit) && (collisionShape = state.method_26194((class_1922)this.view, (class_2338)mpos, this.context)) != class_259.method_1073()) {
            this.collidedShape = BlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z);
        }
        return true;
    }

    public class_265 getCollidedShape() {
        return this.collidedShape;
    }

    private static class_3980 createVolumeIteratorForCollision(class_238 box) {
        int minX = class_3532.method_15357((double)(box.field_1323 - 1.0E-7)) - 1;
        int maxX = class_3532.method_15357((double)(box.field_1320 + 1.0E-7)) + 1;
        int minY = class_3532.method_15357((double)(box.field_1322 - 1.0E-7)) - 1;
        int maxY = class_3532.method_15357((double)(box.field_1325 + 1.0E-7)) + 1;
        int minZ = class_3532.method_15357((double)(box.field_1321 - 1.0E-7)) - 1;
        int maxZ = class_3532.method_15357((double)(box.field_1324 + 1.0E-7)) + 1;
        return new class_3980(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static boolean canInteractWithBlock(class_2680 state, int edgesHit) {
        return !(edgesHit == 1 && !state.method_26209() || edgesHit == 2 && state.method_26204() != class_2246.field_10008);
    }

    private static class_265 getCollidedShape(class_238 entityBox, class_265 entityShape, class_265 shape, int x, int y, int z) {
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.method_1096((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (class_259.method_1074((class_265)(shape = shape.method_1096((double)x, (double)y, (double)z)), (class_265)entityShape, (class_247)class_247.field_16896)) {
            return shape;
        }
        return null;
    }
}

