/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.entity.EntityClassGroup;
import me.jellysquid.mods.lithium.common.world.chunk.ClassGroupFilterableList;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_3509;
import net.minecraft.class_3532;

public class WorldHelper {
    public static final boolean CUSTOM_TYPE_FILTERABLE_LIST_DISABLED = !MixinLoadTest.class.isAssignableFrom(class_3509.class);

    public static List<class_1297> getEntitiesWithCollisionBoxForEntity(class_1924 entityView, class_238 box, class_1297 collidingEntity) {
        if (CUSTOM_TYPE_FILTERABLE_LIST_DISABLED || collidingEntity != null && EntityClassGroup.MINECART_BOAT_LIKE_COLLISION.contains(collidingEntity.getClass()) || !(entityView instanceof class_1937)) {
            return entityView.method_8335(collidingEntity, box);
        }
        return WorldHelper.getEntitiesOfClassGroup((class_1937)entityView, collidingEntity, EntityClassGroup.BOAT_SHULKER_LIKE_COLLISION, box, class_1301.field_6155);
    }

    public static List<class_1297> getEntitiesOfClassGroup(class_1937 world, class_1297 excluded, EntityClassGroup type, class_238 box, Predicate<class_1297> predicate) {
        world.method_16107().method_24270("getEntities");
        int minChunkX = class_3532.method_15357((double)((box.field_1323 - 2.0) / 16.0));
        int maxChunkX = class_3532.method_15384((double)((box.field_1320 + 2.0) / 16.0));
        int minChunkZ = class_3532.method_15357((double)((box.field_1321 - 2.0) / 16.0));
        int maxChunkZ = class_3532.method_15384((double)((box.field_1324 + 2.0) / 16.0));
        ArrayList entities = Lists.newArrayList();
        class_2802 chunkManager = world.method_8398();
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                class_2818 chunk = chunkManager.method_12126(chunkX, chunkZ, false);
                if (chunk == null) continue;
                WorldHelper.getEntitiesOfClassGroup(chunk, excluded, type, box, entities, predicate);
            }
        }
        return entities;
    }

    public static void getEntitiesOfClassGroup(class_2818 worldChunk, class_1297 excluded, EntityClassGroup type, class_238 box, List<class_1297> out, Predicate<class_1297> predicate) {
        class_3509[] entitySections = worldChunk.method_12215();
        int minSectionY = class_3532.method_15357((double)((box.field_1322 - 2.0) / 16.0));
        int maxSectionY = class_3532.method_15357((double)((box.field_1325 + 2.0) / 16.0));
        minSectionY = class_3532.method_15340((int)minSectionY, (int)0, (int)(entitySections.length - 1));
        maxSectionY = class_3532.method_15340((int)maxSectionY, (int)0, (int)(entitySections.length - 1));
        for (int sectionY = minSectionY; sectionY <= maxSectionY; ++sectionY) {
            for (Object entity : ((ClassGroupFilterableList)entitySections[sectionY]).getAllOfGroupType(type)) {
                if (entity == excluded || !((class_1297)entity).method_5829().method_994(box) || predicate != null && !predicate.test((class_1297)entity)) continue;
                out.add((class_1297)entity);
            }
        }
    }

    public static List<class_1297> getEntitiesOfClass(class_1937 world, class_1297 except, Class<? extends class_1297> entityClass, class_238 box) {
        world.method_16107().method_24270("getEntities");
        int minChunkX = class_3532.method_15357((double)((box.field_1323 - 2.0) / 16.0));
        int maxChunkX = class_3532.method_15384((double)((box.field_1320 + 2.0) / 16.0));
        int minChunkZ = class_3532.method_15357((double)((box.field_1321 - 2.0) / 16.0));
        int maxChunkZ = class_3532.method_15384((double)((box.field_1324 + 2.0) / 16.0));
        ArrayList entities = Lists.newArrayList();
        class_2802 chunkManager = world.method_8398();
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                class_2818 chunk = chunkManager.method_12126(chunkX, chunkZ, false);
                if (chunk == null) continue;
                WorldHelper.getEntitiesOfClass(chunk, except, entityClass, box, entities);
            }
        }
        return entities;
    }

    private static void getEntitiesOfClass(class_2818 worldChunk, class_1297 excluded, Class<? extends class_1297> entityClass, class_238 box, List<class_1297> out) {
        class_3509[] entitySections = worldChunk.method_12215();
        int minChunkY = class_3532.method_15357((double)((box.field_1322 - 2.0) / 16.0));
        int maxChunkY = class_3532.method_15357((double)((box.field_1325 + 2.0) / 16.0));
        minChunkY = class_3532.method_15340((int)minChunkY, (int)0, (int)(entitySections.length - 1));
        maxChunkY = class_3532.method_15340((int)maxChunkY, (int)0, (int)(entitySections.length - 1));
        for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
            for (class_1297 entity : entitySections[chunkY].method_15216(entityClass)) {
                if (entity == excluded || !entity.method_5829().method_994(box)) continue;
                out.add(entity);
            }
        }
    }

    public static boolean areNeighborsWithinSameChunk(class_2338 pos) {
        int localX = pos.method_10263() & 0xF;
        int localY = pos.method_10264() & 0xF;
        int localZ = pos.method_10260() & 0xF;
        return localX > 0 && localY > 0 && localZ > 0 && localX < 15 && localY < 15 && localZ < 15;
    }

    public static boolean areAllNeighborsOutOfBounds(class_2338 pos) {
        return pos.method_10264() < -1 || pos.method_10264() > 256;
    }

    public static interface MixinLoadTest {
    }
}

