/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import ru.bclib.api.BiomeAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;
import ru.betterend.interfaces.ISlime;
import ru.betterend.registry.EndBiomes;

public class EndSlimeEntity
extends class_1621 {
    private static final class_2940<Byte> VARIANT = class_2945.method_12791(EndSlimeEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2338.class_2339 POS = new class_2338.class_2339();

    public EndSlimeEntity(class_1299<EndSlimeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new EndSlimeMoveControl(this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SwimmingGoal());
        this.field_6201.method_6277(2, (class_1352)new FaceTowardTargetGoal());
        this.field_6201.method_6277(3, (class_1352)new RandomLookGoal());
        this.field_6201.method_6277(5, (class_1352)new MoveGoal());
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, livingEntity -> Math.abs(livingEntity.method_23318() - this.method_23318()) <= 4.0));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, 0.15);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityTag) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
        BCLBiome biome = BiomeAPI.getFromBiome((class_1959)world.method_23753(this.method_24515()));
        if (biome == EndBiomes.FOGGY_MUSHROOMLAND) {
            this.setMossy();
        } else if (biome == EndBiomes.MEGALAKE || biome == EndBiomes.MEGALAKE_GROVE) {
            this.setLake();
        } else if (biome == EndBiomes.AMBER_LAND) {
            this.setAmber(true);
        }
        this.method_18382();
        return data;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("Variant", (byte)this.getSlimeType());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Variant")) {
            this.field_6011.method_12778(VARIANT, (Object)tag.method_10571("Variant"));
        }
    }

    protected class_2394 method_7162() {
        return class_2398.field_11214;
    }

    public void method_5650() {
        int i = this.method_7152();
        if (!this.field_6002.field_9236 && i > 1 && this.method_29504()) {
            class_2561 text = this.method_5797();
            boolean bl = this.method_5987();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.field_5974.nextInt(3);
            int type = this.getSlimeType();
            for (int l = 0; l < k; ++l) {
                float g = ((float)(l % 2) - 0.5f) * f;
                float h = ((float)(l / 2) - 0.5f) * f;
                EndSlimeEntity slimeEntity = (EndSlimeEntity)this.method_5864().method_5883(this.field_6002);
                if (this.method_5947()) {
                    slimeEntity.method_5971();
                }
                slimeEntity.setSlimeType(type);
                slimeEntity.method_5665(text);
                slimeEntity.method_5977(bl);
                slimeEntity.method_5684(this.method_5655());
                ((ISlime)((Object)slimeEntity)).be_setSlimeSize(j, true);
                slimeEntity.method_18382();
                slimeEntity.method_5808(this.method_23317() + (double)g, this.method_23318() + 0.5, this.method_23321() + (double)h, this.field_5974.nextFloat() * 360.0f, 0.0f);
                this.field_6002.method_8649((class_1297)slimeEntity);
            }
        }
        this.field_5988 = true;
    }

    protected void method_16077(class_1282 source, boolean causedByPlayer) {
        int maxCount = this.method_7152();
        int minCount = maxCount >> 1;
        if (minCount < 1) {
            minCount = 1;
        }
        if (causedByPlayer && this.field_6258 != null) {
            int looting = class_1890.method_8226((class_1309)this.field_6258);
            minCount += looting;
        }
        int count = minCount < maxCount ? MHelper.randRange((int)minCount, (int)maxCount, (Random)this.field_5974) : maxCount;
        class_1542 drop = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)class_1802.field_8777, count));
        this.field_6002.method_8649((class_1297)drop);
    }

    public int getSlimeType() {
        return ((Byte)this.field_6011.method_12789(VARIANT)).intValue();
    }

    public void setSlimeType(int value) {
        this.field_6011.method_12778(VARIANT, (Object)((byte)value));
    }

    protected void setMossy() {
        this.setSlimeType(1);
    }

    public boolean isMossy() {
        return this.getSlimeType() == 1;
    }

    protected void setLake() {
        this.setSlimeType(2);
    }

    public boolean isLake() {
        return this.getSlimeType() == 2;
    }

    protected void setAmber(boolean mossy) {
        this.field_6011.method_12778(VARIANT, (Object)3);
    }

    public boolean isAmber() {
        return (Byte)this.field_6011.method_12789(VARIANT) == 3;
    }

    public boolean isChorus() {
        return (Byte)this.field_6011.method_12789(VARIANT) == 0;
    }

    public static boolean canSpawn(class_1299<EndSlimeEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return random.nextInt(16) == 0 || EndSlimeEntity.isPermanentBiome(world, pos) || EndSlimeEntity.notManyEntities(world, pos, 32, 3) && EndSlimeEntity.isWaterNear(world, pos, 32, 8);
    }

    private static boolean isPermanentBiome(class_5425 world, class_2338 pos) {
        class_1959 biome = world.method_23753(pos);
        return BiomeAPI.getFromBiome((class_1959)biome) == EndBiomes.CHORUS_FOREST;
    }

    private static boolean notManyEntities(class_5425 world, class_2338 pos, int radius, int maxCount) {
        class_238 box = new class_238(pos).method_1014((double)radius);
        List list = world.method_8390(EndSlimeEntity.class, box, entity -> true);
        return list.size() <= maxCount;
    }

    private static boolean isWaterNear(class_5425 world, class_2338 pos, int radius, int radius2) {
        for (int x = pos.method_10263() - radius; x <= pos.method_10263() + radius; ++x) {
            POS.method_20787(x);
            for (int z = pos.method_10260() - radius; z <= pos.method_10260() + radius; ++z) {
                POS.method_20788(z);
                for (int y = pos.method_10264() - radius2; y <= pos.method_10264() + radius2; ++y) {
                    POS.method_10099(y);
                    if (world.method_8320((class_2338)POS).method_26204() != class_2246.field_10382) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class EndSlimeMoveControl
    extends class_1335 {
        private float targetYaw;
        private int ticksUntilJump;
        private boolean jumpOften;

        public EndSlimeMoveControl(EndSlimeEntity slime) {
            super((class_1308)slime);
            this.targetYaw = 180.0f * slime.field_6031 / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.field_6372 = speed;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void method_6240() {
            this.field_6371.field_6241 = this.field_6371.field_6031 = this.method_6238(this.field_6371.field_6031, this.targetYaw, 90.0f);
            this.field_6371.field_6283 = this.field_6371.field_6031;
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.field_6371.method_24828()) {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = EndSlimeEntity.this.method_7154();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        EndSlimeEntity.this.method_5993().method_6233();
                        if (EndSlimeEntity.this.method_7159()) {
                            EndSlimeEntity.this.method_5783(EndSlimeEntity.this.method_7153(), EndSlimeEntity.this.method_6107(), this.getJumpSoundPitch());
                        }
                    } else {
                        EndSlimeEntity.this.field_6212 = 0.0f;
                        EndSlimeEntity.this.field_6250 = 0.0f;
                        this.field_6371.method_6125(0.0f);
                    }
                } else {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                }
            }
        }

        private float getJumpSoundPitch() {
            float f = EndSlimeEntity.this.method_7157() ? 1.4f : 0.8f;
            return ((EndSlimeEntity.this.field_5974.nextFloat() - EndSlimeEntity.this.field_5974.nextFloat()) * 0.2f + 1.0f) * f;
        }
    }

    class FaceTowardTargetGoal
    extends class_1352 {
        private int ticksLeft;

        public FaceTowardTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = EndSlimeEntity.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            return livingEntity instanceof class_1657 && ((class_1657)livingEntity).field_7503.field_7480 ? false : EndSlimeEntity.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6269() {
            this.ticksLeft = 300;
            super.method_6269();
        }

        public boolean method_6266() {
            class_1309 livingEntity = EndSlimeEntity.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (livingEntity instanceof class_1657 && ((class_1657)livingEntity).field_7503.field_7480) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void method_6268() {
            EndSlimeEntity.this.method_5951((class_1297)EndSlimeEntity.this.method_5968(), 10.0f, 10.0f);
            ((EndSlimeMoveControl)EndSlimeEntity.this.method_5962()).look(EndSlimeEntity.this.field_6031, EndSlimeEntity.this.method_7163());
        }
    }

    class RandomLookGoal
    extends class_1352 {
        private float targetYaw;
        private int timer;

        public RandomLookGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return EndSlimeEntity.this.method_5968() == null && (EndSlimeEntity.this.field_5952 || EndSlimeEntity.this.method_5799() || EndSlimeEntity.this.method_5771() || EndSlimeEntity.this.method_6059(class_1294.field_5902)) && EndSlimeEntity.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6268() {
            if (--this.timer <= 0) {
                this.timer = 40 + EndSlimeEntity.this.method_6051().nextInt(60);
                this.targetYaw = EndSlimeEntity.this.method_6051().nextInt(360);
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.method_5962()).look(this.targetYaw, false);
        }
    }

    class SwimmingGoal
    extends class_1352 {
        public SwimmingGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
            EndSlimeEntity.this.method_5942().method_6354(true);
        }

        public boolean method_6264() {
            return (EndSlimeEntity.this.method_5799() || EndSlimeEntity.this.method_5771()) && EndSlimeEntity.this.method_5962() instanceof EndSlimeMoveControl;
        }

        public void method_6268() {
            if (EndSlimeEntity.this.method_6051().nextFloat() < 0.8f) {
                EndSlimeEntity.this.method_5993().method_6233();
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.method_5962()).move(1.2);
        }
    }

    class MoveGoal
    extends class_1352 {
        public MoveGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (EndSlimeEntity.this.method_5765()) {
                return false;
            }
            float yaw = EndSlimeEntity.this.method_5791();
            float speed = EndSlimeEntity.this.method_6029();
            if ((double)speed > 0.1) {
                float dx = class_3532.method_15374((float)(-yaw * ((float)Math.PI / 180)));
                float dz = class_3532.method_15362((float)(-yaw * ((float)Math.PI / 180)));
                class_2338 pos = EndSlimeEntity.this.method_24515().method_10080((double)(dx * speed * 4.0f), 0.0, (double)(dz * speed * 4.0f));
                int down = BlocksHelper.downRay((class_1936)EndSlimeEntity.this.field_6002, (class_2338)pos, (int)16);
                return down < 5;
            }
            return true;
        }

        public void method_6268() {
            ((EndSlimeMoveControl)EndSlimeEntity.this.method_5962()).move(1.0);
        }
    }
}

