/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.features.terrain.caves;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import ru.bclib.api.BiomeAPI;
import ru.bclib.api.TagAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.world.biomes.BCLBiome;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndBiomes;
import ru.betterend.world.biome.cave.EndCaveBiome;
import ru.betterend.world.features.terrain.caves.EndCaveFeature;

public class TunelCaveFeature
extends EndCaveFeature {
    private Set<class_2338> generate(class_5281 world, class_2338 center, Random random) {
        int cz;
        int cx = center.method_10263() >> 4;
        if ((long)cx * (long)cx + (long)(cz = center.method_10260() >> 4) + (long)cz < 256L) {
            return Sets.newHashSet();
        }
        int x1 = cx << 4;
        int z1 = cz << 4;
        int x2 = x1 + 16;
        int z2 = z1 + 16;
        Random rand = new Random(world.method_8412());
        OpenSimplexNoise noiseH = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseV = new OpenSimplexNoise(rand.nextInt());
        OpenSimplexNoise noiseD = new OpenSimplexNoise(rand.nextInt());
        Set positions = Sets.newConcurrentHashSet();
        float a = this.hasCaves(world, new class_2338(x1, 0, z1)) ? 1.0f : 0.0f;
        float b = this.hasCaves(world, new class_2338(x2, 0, z1)) ? 1.0f : 0.0f;
        float c = this.hasCaves(world, new class_2338(x1, 0, z2)) ? 1.0f : 0.0f;
        float d = this.hasCaves(world, new class_2338(x2, 0, z2)) ? 1.0f : 0.0f;
        class_2791 chunk = world.method_8392(cx, cz);
        IntStream.range(0, 256).parallel().forEach(index -> {
            class_2338.class_2339 pos = new class_2338.class_2339();
            int x = index & 0xF;
            int z = index >> 4;
            int wheight = chunk.method_12005(class_2902.class_2903.field_13194, x, z);
            float dx = (float)x / 16.0f;
            float dz = (float)z / 16.0f;
            pos.method_20787(x + x1);
            pos.method_20788(z + z1);
            float da = class_3532.method_16439((float)dx, (float)a, (float)b);
            float db = class_3532.method_16439((float)dx, (float)c, (float)d);
            float density = 1.0f - class_3532.method_16439((float)dz, (float)da, (float)db);
            if ((double)density < 0.5) {
                for (int y = 0; y < wheight; ++y) {
                    float dist;
                    pos.method_10099(y);
                    float gradient = 1.0f - class_3532.method_15363((float)((float)(wheight - y) * 0.1f), (float)0.0f, (float)1.0f);
                    if ((double)gradient > 0.5) break;
                    float val = class_3532.method_15379((float)((float)noiseH.eval((double)pos.method_10263() * 0.02, (double)y * 0.01, (double)pos.method_10260() * 0.02)));
                    float vert = class_3532.method_15374((float)(((float)y + (float)noiseV.eval((double)pos.method_10263() * 0.01, (double)pos.method_10260() * 0.01) * 20.0f) * 0.1f)) * 0.9f;
                    if (!((double)(val = val + vert * vert + (dist = (float)noiseD.eval((double)pos.method_10263() * 0.1, (double)y * 0.1, (double)pos.method_10260() * 0.1) * 0.12f) + density + gradient) < 0.15) || !world.method_8320((class_2338)pos).method_26164((class_3494)TagAPI.GEN_TERRAIN) || !this.noWaterNear(world, (class_2338)pos)) continue;
                    positions.add(pos.method_10062());
                }
            }
        });
        positions.forEach(bpos -> BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bpos, (class_2680)CAVE_AIR));
        return positions;
    }

    private boolean noWaterNear(class_5281 world, class_2338 pos) {
        class_2338 above1 = pos.method_10084();
        class_2338 above2 = pos.method_10086(2);
        if (!world.method_8316(above1).method_15769() || !world.method_8316(above2).method_15769()) {
            return false;
        }
        for (class_2350 dir : BlocksHelper.HORIZONTAL) {
            if (!world.method_8316(above1.method_10093(dir)).method_15769()) {
                return false;
            }
            if (world.method_8316(above2.method_10093(dir)).method_15769()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 pos, class_3111 config) {
        if (pos.method_10263() * pos.method_10263() + pos.method_10260() * pos.method_10260() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        Set<class_2338> caveBlocks = this.generate(world, pos, random);
        if (caveBlocks.isEmpty()) {
            return false;
        }
        HashMap floorSets = Maps.newHashMap();
        HashMap ceilSets = Maps.newHashMap();
        class_2338.class_2339 mut = new class_2338.class_2339();
        HashSet remove = Sets.newHashSet();
        caveBlocks.forEach(bpos -> {
            mut.method_10101((class_2382)bpos);
            EndCaveBiome bio = EndBiomes.getCaveBiome(bpos.method_10263(), bpos.method_10260());
            int height = world.method_8624(class_2902.class_2903.field_13202, bpos.method_10263(), bpos.method_10260());
            if (mut.method_10264() >= height) {
                remove.add(bpos);
            } else if (world.method_8320((class_2338)mut).method_26207().method_15800()) {
                mut.method_10099(bpos.method_10264() - 1);
                if (world.method_8320((class_2338)mut).method_26164((class_3494)TagAPI.GEN_TERRAIN)) {
                    Set floorPositions = (Set)floorSets.get((Object)bio);
                    if (floorPositions == null) {
                        floorPositions = Sets.newHashSet();
                        floorSets.put(bio, floorPositions);
                    }
                    floorPositions.add(mut.method_10062());
                }
                mut.method_10099(bpos.method_10264() + 1);
                if (world.method_8320((class_2338)mut).method_26164((class_3494)TagAPI.GEN_TERRAIN)) {
                    Set ceilPositions = (Set)ceilSets.get((Object)bio);
                    if (ceilPositions == null) {
                        ceilPositions = Sets.newHashSet();
                        ceilSets.put(bio, ceilPositions);
                    }
                    ceilPositions.add(mut.method_10062());
                }
                this.setBiome(world, (class_2338)bpos, bio);
            }
        });
        caveBlocks.removeAll(remove);
        if (caveBlocks.isEmpty()) {
            return true;
        }
        floorSets.forEach((biome, floorPositions) -> {
            class_2680 surfaceBlock = biome.getBiome().method_30970().method_30985().method_15337();
            this.placeFloor(world, (EndCaveBiome)((Object)biome), (Set<class_2338>)floorPositions, random, surfaceBlock);
        });
        ceilSets.forEach((biome, ceilPositions) -> this.placeCeil(world, (EndCaveBiome)((Object)biome), (Set<class_2338>)ceilPositions, random));
        EndCaveBiome biome2 = EndBiomes.getCaveBiome(pos.method_10263(), pos.method_10260());
        this.placeWalls(world, biome2, caveBlocks, random);
        this.fixBlocks(world, caveBlocks);
        return true;
    }

    @Override
    protected Set<class_2338> generate(class_5281 world, class_2338 center, int radius, Random random) {
        return null;
    }

    @Override
    protected void placeFloor(class_5281 world, EndCaveBiome biome, Set<class_2338> floorPositions, Random random, class_2680 surfaceBlock) {
        float density = biome.getFloorDensity() * 0.2f;
        floorPositions.forEach(pos -> {
            class_3031<?> feature;
            if (!surfaceBlock.method_27852(class_2246.field_10471)) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)surfaceBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.method_13151(world, null, random, pos.method_10084(), null);
            }
        });
    }

    @Override
    protected void placeCeil(class_5281 world, EndCaveBiome biome, Set<class_2338> ceilPositions, Random random) {
        float density = biome.getCeilDensity() * 0.2f;
        ceilPositions.forEach(pos -> {
            class_3031<?> feature;
            class_2680 ceilBlock = biome.getCeil((class_2338)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.method_13151(world, null, random, pos.method_10074(), null);
            }
        });
    }

    protected boolean hasCaves(class_5281 world, class_2338 pos) {
        return this.hasCavesInBiome(world, pos.method_10069(-8, 0, -8)) && this.hasCavesInBiome(world, pos.method_10069(8, 0, -8)) && this.hasCavesInBiome(world, pos.method_10069(-8, 0, 8)) && this.hasCavesInBiome(world, pos.method_10069(8, 0, 8));
    }

    protected boolean hasCavesInBiome(class_5281 world, class_2338 pos) {
        class_1959 biome = world.method_23753(pos);
        BCLBiome endBiome = BiomeAPI.getFromBiome((class_1959)biome);
        return (Boolean)endBiome.getCustomData("has_caves", (Object)true);
    }
}

