/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.structures.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_5455;
import ru.bclib.sdf.PosInfo;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFRotation;
import ru.bclib.sdf.operator.SDFTranslate;
import ru.bclib.sdf.operator.SDFUnion;
import ru.bclib.sdf.primitive.SDFCappedCone;
import ru.bclib.sdf.primitive.SDFPrimitive;
import ru.bclib.util.MHelper;
import ru.betterend.registry.EndBlocks;
import ru.betterend.world.structures.features.SDFStructureFeature;
import ru.betterend.world.structures.piece.VoxelPiece;

public class GiantIceStarStructure
extends SDFStructureFeature {
    private final float minSize = 20.0f;
    private final float maxSize = 35.0f;
    private final int minCount = 25;
    private final int maxCount = 40;

    @Override
    protected SDF getSDF(class_2338 pos, Random random) {
        float size = MHelper.randRange((float)20.0f, (float)35.0f, (Random)random);
        int count = MHelper.randRange((int)25, (int)40, (Random)random);
        List<class_1160> points = this.getFibonacciPoints(count);
        SDFPrimitive sdf = null;
        SDFPrimitive spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(EndBlocks.DENSE_SNOW);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource((SDF)spike);
        for (class_1160 point : points) {
            SDFPrimitive rotated = spike;
            float angle = MHelper.angle((class_1160)class_1160.field_20705, (class_1160)(point = MHelper.normalize((class_1160)point)));
            if (angle > 0.01f && angle < 3.14f) {
                class_1160 axis = MHelper.normalize((class_1160)MHelper.cross((class_1160)class_1160.field_20705, (class_1160)point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource((SDF)spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(class_1160.field_20705, (float)Math.PI).setSource((SDF)spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)rotated);
        }
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        class_2338 center = pos;
        class_2680 ice = EndBlocks.EMERALD_ICE.method_9564();
        class_2680 dense = EndBlocks.DENSE_EMERALD_ICE.method_9564();
        class_2680 ancient = EndBlocks.ANCIENT_EMERALD_ICE.method_9564();
        SDFPrimitive sdfCopy = sdf;
        return sdf.addPostProcess(arg_0 -> GiantIceStarStructure.lambda$getSDF$0(center, (SDF)sdfCopy, random, randScale, ancientRadius, ancient, denseRadius, dense, iceRadius, ice, arg_0));
    }

    private List<class_1160> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<class_1160> result = new ArrayList<class_1160>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new class_1160(x, y, z));
        }
        return result;
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return StarStructureStart::new;
    }

    private static /* synthetic */ class_2680 lambda$getSDF$0(class_2338 center, SDF sdfCopy, Random random, float randScale, float ancientRadius, class_2680 ancient, float denseRadius, class_2680 dense, float iceRadius, class_2680 ice, PosInfo info) {
        float pz;
        float py;
        class_2338 bpos = info.getPos();
        float px = bpos.method_10263() - center.method_10263();
        float distance = MHelper.length((float)px, (float)(py = (float)(bpos.method_10264() - center.method_10264())), (float)(pz = (float)(bpos.method_10260() - center.method_10260()))) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.nextFloat() * randScale;
        if (distance < ancientRadius) {
            return ancient;
        }
        if (distance < denseRadius) {
            return dense;
        }
        if (distance < iceRadius) {
            return ice;
        }
        return info.getState();
    }

    public static class StarStructureStart
    extends class_3449<class_3111> {
        public StarStructureStart(class_3195<class_3111> feature, int chunkX, int chunkZ, class_3341 box, int references, long seed) {
            super(feature, chunkX, chunkZ, box, references, seed);
        }

        public void generatePieces(class_5455 registryManager, class_2794 chunkGenerator, class_3485 manager, int chunkX, int chunkZ, class_1959 biome, class_3111 config) {
            int x = chunkX << 4 | MHelper.randRange((int)4, (int)12, (Random)this.field_16715);
            int z = chunkZ << 4 | MHelper.randRange((int)4, (int)12, (Random)this.field_16715);
            class_2338 start = new class_2338(x, MHelper.randRange((int)32, (int)128, (Random)this.field_16715), z);
            VoxelPiece piece = new VoxelPiece(world -> ((SDFStructureFeature)this.method_16656()).getSDF(start, (Random)this.field_16715).fillRecursive(world, start), this.field_16715.nextInt());
            this.field_15325.add(piece);
            this.method_14969();
        }
    }
}

