/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.ToDoubleBiFunction;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

public class ScaleType {
    public static final ScaleType INVALID = ScaleType.register(ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES));
    public static final ScaleType BASE = ScaleType.registerBaseScale("base");
    public static final ScaleType WIDTH = ScaleType.registerDimensionScale("width");
    public static final ScaleType HEIGHT = ScaleType.registerDimensionScale("height");
    public static final ScaleType MOTION = ScaleType.register("motion", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType REACH = ScaleType.register("reach", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType ATTACK = ScaleType.register("attack", new ScaleModifier[0]);
    public static final ScaleType DEFENSE = ScaleType.register("defense", new ScaleModifier[0]);
    public static final ScaleType HEALTH = ScaleType.register("health", new ScaleModifier[0]);
    public static final ScaleType DROPS = ScaleType.register("drops", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType PROJECTILES = ScaleType.register("projectiles", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType EXPLOSIONS = ScaleType.register("explosions", ScaleModifier.BASE_MULTIPLIER);
    private float defaultBaseScale;
    private int defaultTickDelay;
    private final ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction;
    private final ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction;
    private final Set<ScaleModifier> defaultBaseValueModifiers;
    private final Event<ScaleEventCallback> scaleChangedEvent = ScaleType.createScaleEvent();
    private final Event<ScaleEventCallback> preTickEvent = ScaleType.createScaleEvent();
    private final Event<ScaleEventCallback> postTickEvent = ScaleType.createScaleEvent();

    private ScaleType(Builder builder) {
        this.defaultBaseScale = builder.defaultBaseScale;
        this.defaultTickDelay = builder.defaultTickDelay;
        this.defaultBaseValueModifiers = builder.defaultBaseValueModifiers;
        this.baseScaleClampFunction = builder.baseScaleClampFunction;
        this.targetScaleClampFunction = builder.targetScaleClampFunction;
    }

    public ScaleData getScaleData(class_1297 entity) {
        return ((PehkuiEntityExtensions)entity).pehkui_getScaleData(this);
    }

    public final float getDefaultBaseScale() {
        return this.defaultBaseScale;
    }

    public final int getDefaultTickDelay() {
        return this.defaultTickDelay;
    }

    public double clampBaseScale(ScaleData data, double newScale) {
        return this.baseScaleClampFunction.applyAsDouble(data, newScale);
    }

    public double clampTargetScale(ScaleData data, double newScale) {
        return this.targetScaleClampFunction.applyAsDouble(data, newScale);
    }

    public Set<ScaleModifier> getDefaultBaseValueModifiers() {
        return this.defaultBaseValueModifiers;
    }

    public Event<ScaleEventCallback> getScaleChangedEvent() {
        return this.scaleChangedEvent;
    }

    public Event<ScaleEventCallback> getPreTickEvent() {
        return this.preTickEvent;
    }

    public Event<ScaleEventCallback> getPostTickEvent() {
        return this.postTickEvent;
    }

    private static Event<ScaleEventCallback> createScaleEvent() {
        return EventFactory.createArrayBacked(ScaleEventCallback.class, data -> {}, callbacks -> data -> {
            for (ScaleEventCallback callback : callbacks) {
                callback.onEvent(data);
            }
        });
    }

    private static ScaleType register(class_2960 id, Builder builder) {
        return ScaleRegistries.register(ScaleRegistries.SCALE_TYPES, id, builder.build());
    }

    private static ScaleType register(class_2960 id) {
        Builder builder = Builder.create();
        return ScaleType.register(id, builder);
    }

    private static ScaleType register(String path, ScaleModifier ... modifiers) {
        Builder builder = Builder.create();
        for (ScaleModifier scaleModifier : modifiers) {
            builder.addBaseValueModifier(scaleModifier);
        }
        return ScaleType.register(Pehkui.id(path), builder);
    }

    private static ScaleType registerBaseScale(String path) {
        Builder builder = Builder.create().affectsDimensions().addDependentModifier(ScaleModifier.BASE_MULTIPLIER);
        return ScaleType.register(Pehkui.id(path), builder);
    }

    private static ScaleType registerDimensionScale(String path) {
        Builder builder = Builder.create().affectsDimensions().addBaseValueModifier(ScaleModifier.BASE_MULTIPLIER);
        return ScaleType.register(Pehkui.id(path), builder);
    }

    public static class Builder {
        private Set<ScaleModifier> defaultBaseValueModifiers = new ObjectRBTreeSet();
        private float defaultBaseScale = 1.0f;
        private int defaultTickDelay = 20;
        private float defaultMinPositiveScale = 1.2621775E-29f;
        private float defaultMaxPositiveScale = 4.2949673E9f;
        private ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return scaleData.getTargetScale() < 0.0f ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return newScale < 0.0 ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private boolean affectsDimensions = false;
        private Set<ScaleModifier> dependentModifiers = new ObjectRBTreeSet();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder defaultBaseScale(float defaultBaseScale) {
            this.defaultBaseScale = defaultBaseScale;
            return this;
        }

        public Builder defaultTickDelay(int defaultTickDelay) {
            this.defaultTickDelay = defaultTickDelay;
            return this;
        }

        public Builder defaultMinPositiveScale(float defaultMinPositiveScale) {
            this.defaultMinPositiveScale = defaultMinPositiveScale;
            return this;
        }

        public Builder defaultMaxPositiveScale(float defaultMaxPositiveScale) {
            this.defaultMaxPositiveScale = defaultMaxPositiveScale;
            return this;
        }

        public Builder clampedBaseScale(ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction) {
            this.baseScaleClampFunction = baseScaleClampFunction;
            return this;
        }

        public Builder clampedTargetScale(ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction) {
            this.targetScaleClampFunction = targetScaleClampFunction;
            return this;
        }

        public Builder addBaseValueModifier(ScaleModifier scaleModifier) {
            this.defaultBaseValueModifiers.add(scaleModifier);
            return this;
        }

        public Builder affectsDimensions() {
            this.affectsDimensions = true;
            return this;
        }

        public Builder addDependentModifier(ScaleModifier scaleModifier) {
            this.dependentModifiers.add(scaleModifier);
            return this;
        }

        public ScaleType build() {
            ScaleType type = new ScaleType(this);
            if (this.affectsDimensions) {
                type.getScaleChangedEvent().register(Builder::calculateDimensions);
            }
            if (!this.dependentModifiers.isEmpty()) {
                type.getScaleChangedEvent().register((Object)Builder.createModifiedDataSyncEvent(this.dependentModifiers));
            }
            return type;
        }

        private static void calculateDimensions(ScaleData s) {
            class_1297 e = s.getEntity();
            if (e != null) {
                PehkuiEntityExtensions en = (PehkuiEntityExtensions)e;
                boolean onGround = en.pehkui_getOnGround();
                if (!ScaleUtils.isAboveCollisionThreshold(e)) {
                    e.method_18382();
                }
                en.pehkui_setOnGround(onGround);
            }
        }

        private static ScaleEventCallback createModifiedDataSyncEvent(Collection<ScaleModifier> modifiers) {
            return s -> {
                class_1297 e = s.getEntity();
                if (e != null) {
                    for (ScaleType scaleType : ScaleRegistries.SCALE_TYPES.values()) {
                        ScaleData data = scaleType.getScaleData(e);
                        if (Collections.disjoint(modifiers, data.getBaseValueModifiers())) continue;
                        data.markForSync(true);
                    }
                }
            };
        }
    }
}

