/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import virtuoel.pehkui.util.VersionUtils;

public class PehkuiMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE = "virtuoel.pehkui.mixin";
    private static final boolean REACH_ATTRIBUTES_LOADED = FabricLoader.getInstance().isModLoaded("reach-entity-attributes");
    private static final boolean STEP_HEIGHT_ATTRIBUTES_LOADED = FabricLoader.getInstance().isModLoaded("step-height-entity-attribute");
    private static final boolean IDENTITY_LOADED = FabricLoader.getInstance().isModLoaded("identity");
    private static final boolean OPTIFABRIC_LOADED = FabricLoader.getInstance().isModLoaded("optifabric");
    private static final boolean PATCHWORK_ENTITY_EVENTS_LOADED = FabricLoader.getInstance().isModLoaded("patchwork-events-entity");

    public void onLoad(String mixinPackage) {
        if (!mixinPackage.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package: Expected \"%s\", but found \"%s\".", MIXIN_PACKAGE, mixinPackage));
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package for class \"%s\": Expected \"%s\", but found \"%s\".", targetClassName, MIXIN_PACKAGE, mixinClassName));
        }
        if (!VersionUtils.shouldApplyCompatibilityMixin(mixinClassName)) {
            return false;
        }
        if (mixinClassName.endsWith("InGameOverlayRendererMixin")) {
            return OPTIFABRIC_LOADED == mixinClassName.contains(".optifine.compat.");
        }
        if (mixinClassName.endsWith("EntityCalculateDimensionsMixin")) {
            return PATCHWORK_ENTITY_EVENTS_LOADED == mixinClassName.contains(".patchwork.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.reach")) {
            return REACH_ATTRIBUTES_LOADED == mixinClassName.equals("virtuoel.pehkui.mixin.reach.compat.ReachEntityAttributesMixin");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.step_height")) {
            return STEP_HEIGHT_ATTRIBUTES_LOADED == mixinClassName.equals("virtuoel.pehkui.mixin.step_height.compat.StepHeightEntityAttributeMainMixin");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.identity.compat")) {
            return IDENTITY_LOADED;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

