/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches;

import com.electronwill.nightconfig.core.conversion.Path;
import com.electronwill.nightconfig.core.conversion.SpecDoubleInRange;
import com.electronwill.nightconfig.core.conversion.SpecFloatInRange;
import com.electronwill.nightconfig.core.conversion.SpecIntInRange;
import com.therandomlabs.autoconfigtoml.TOMLConfigSerializer;
import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.client.CauldronWaterTranslucencyHandler;
import com.therandomlabs.randompatches.client.RPKeyBindingHandler;
import com.therandomlabs.randompatches.client.RPWindowHandler;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.StringUtils;

@TOMLConfigSerializer.Comment(value={"RandomPatches configuration.", "All configuration options not under [client] are server-sided unless otherwise stated."})
@Config(name="randompatches")
public final class RPConfig
implements ConfigData {
    @TOMLConfigSerializer.Comment(value={"Client-sided options."})
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public Client client = new Client();
    @TOMLConfigSerializer.Comment(value={"Options related to connection timeouts."})
    @ConfigEntry.Category(value="connection_timeouts")
    @ConfigEntry.Gui.TransitiveObject
    public ConnectionTimeouts connectionTimeouts = new ConnectionTimeouts();
    @TOMLConfigSerializer.Comment(value={"Options related to packet size limits."})
    @ConfigEntry.Category(value="packet_size_limits")
    @ConfigEntry.Gui.TransitiveObject
    public PacketSizeLimits packetSizeLimits = new PacketSizeLimits();
    @TOMLConfigSerializer.Comment(value={"Options related to player speed limits.", "These options are used to fix MC-90062: https://bugs.mojang.com/browse/MC-90062"})
    @ConfigEntry.Category(value="player_speed_limits")
    @ConfigEntry.Gui.TransitiveObject
    public PlayerSpeedLimits playerSpeedLimits = new PlayerSpeedLimits();
    @TOMLConfigSerializer.Comment(value={"Miscellaneous options."})
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.TransitiveObject
    public Misc misc = new Misc();

    public static enum PlayerHeadStackingFixMode {
        DISABLED,
        REQUIRE_SAME_PLAYER_AND_TEXTURE_URL,
        REQUIRE_SAME_PLAYER;

    }

    public static final class MiscBugFixes {
        @Path(value="fix_mc-2025")
        @TOMLConfigSerializer.Comment(value={"Fixes MC-2025: https://bugs.mojang.com/browse/MC-2025", "For more information, see: https://redd.it/8pgd4q"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixMC2025 = true;
        @TOMLConfigSerializer.Comment(value={"Fixes animals which can breed only showing hearts once initially instead of continuously.", "This bug is reported as MC-93826: https://bugs.mojang.com/browse/MC-93826"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixAnimalBreedingHearts = true;
        @TOMLConfigSerializer.Comment(value={"Fixes entities not being considered wet in cauldrons filled with water.", "This allows players to use Riptide in cauldrons filled with water, fixing MC-145311: https://bugs.mojang.com/browse/MC-145311", "The MC-145311 fix works client-side only, so please be mindful of server rules when using this feature.", "This also allows players to receive the Conduit Power effect in cauldrons filled with water."})
        @ConfigEntry.Gui.Tooltip
        public boolean fixEntitiesNotBeingConsideredWetInCauldrons = true;
        @TOMLConfigSerializer.Comment(value={"Fixes mobs not being able to cross rails.", "This bug is reported as MC-33359: https://bugs.mojang.com/browse/MC-33359"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixMobsNotCrossingRails = true;
        @TOMLConfigSerializer.Comment(value={"Fixes boats and players in boats not taking fall damage.", "This bug is reported as both MC-98160: https://bugs.mojang.com/browse/MC-98160", "and MC-105103: https://bugs.mojang.com/browse/MC-105103"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixBoatFallDamage = true;
        @TOMLConfigSerializer.Comment(value={"Fixes player heads from the same player sometimes not stacking.", "DISABLED: Disables this fix.", "REQUIRE_SAME_PLAYER_AND_TEXTURE_URL: Player heads can stack if they are from the same player and have the same texture URL.", "REQUIRE_SAME_PLAYER: Player heads can stack if they are from the same player.", "This bug is reported as MC-100044: https://bugs.mojang.com/browse/MC-100044"})
        @ConfigEntry.Gui.Tooltip
        public PlayerHeadStackingFixMode fixPlayerHeadStacking = PlayerHeadStackingFixMode.REQUIRE_SAME_PLAYER_AND_TEXTURE_URL;
        @Path(value="fix_duplicate_entity_uuids")
        @TOMLConfigSerializer.Comment(value={"Fixes duplicate entity UUIDs by assigning new UUIDs to the affected entities.", "This bug is reported as MC-95649: https://bugs.mojang.com/browse/MC-95649"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixDuplicateEntityUUIDs = true;
        @Path(value="log_fixed_duplicate_entity_uuids")
        @TOMLConfigSerializer.Comment(value={"Logs fixed entity UUIDs."})
        @ConfigEntry.Gui.Tooltip
        public boolean logFixedDuplicateEntityUUIDs = true;
        @TOMLConfigSerializer.Comment(value={"Fixes the recipe book not automatically moving ingredients with NBT tags to the crafting grid.", "This bug is reported as MC-129057: https://bugs.mojang.com/browse/MC-129057"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixRecipeBookNotMovingIngredientsWithTags = true;
    }

    public static final class Misc
    implements ConfigData {
        @TOMLConfigSerializer.Comment(value={"Miscellaneous bug fixes."})
        @ConfigEntry.Category(value="bug_fixes")
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public MiscBugFixes bugFixes = new MiscBugFixes();
        @TOMLConfigSerializer.Comment(value={"The buoyancy of boats when they are under flowing water.", "The vanilla default is -0.0007.", "Setting this to a positive value allows boats to float up when they move into a higher block of water, fixing MC-91206: https://bugs.mojang.com/browse/MC-91206"})
        @ConfigEntry.Gui.Tooltip
        public double boatBuoyancyUnderFlowingWater = FabricLoader.getInstance().isDevelopmentEnvironment() ? 5.0 : 0.023;
        @SpecIntInRange(min=-1, max=0x7FFFFFFF)
        @TOMLConfigSerializer.Comment(value={"How long it takes in ticks for a boat passenger to be ejected when underwater.", "Set this to -1 to disable underwater boat passenger ejection."})
        @ConfigEntry.Gui.Tooltip
        public int underwaterBoatPassengerEjectionDelayTicks = FabricLoader.getInstance().isDevelopmentEnvironment() ? -1 : 60;
        @TOMLConfigSerializer.Comment(value={"The name of the command that reloads this configuration from disk.", "Set this to an empty string to disable the command.", "Changes to this option are applied when a server is loaded."})
        @ConfigEntry.Gui.Tooltip
        public String configReloadCommand = "rpconfigreload";
        @TOMLConfigSerializer.Comment(value={"Disables the execution of DataFixerUpper.", "This reduces RAM usage and decreases the Minecraft loading time.", "WARNING: THIS IS NOT RECOMMENDED! RandomPatches is not responsible for any damage caused by this feature.", "- DataFixerUpper is responsible for the backwards compatibility of worlds.", "- Ensure you have used the Optimize feature on any worlds from previous versions of Minecraft before enabling this feature.", "- Before migrating worlds to new versions of Minecraft, ensure this feature is disabled, and use the Optimize feature again before re-enabling it.", "- Take regular backups of your worlds.", "Changes to this option are applied after a game restart."})
        @ConfigEntry.Gui.Tooltip
        public boolean disableDataFixerUpper = FabricLoader.getInstance().isDevelopmentEnvironment();
        @TOMLConfigSerializer.Comment(value={"A list of mixins that should not be applied.", "These are the mixins that are not automatically disabled when the features that depend on them are:", "- AbstractClientPlayerEntity, PlayerEntityRendererContributorCapes, PlayerListEntry: Required for contributor capes.", "- AnimalEntity: Required for fixing animal breeding hearts.", "- BoatEntity: Required for modifying boat options.", "- ChannelInitializer: Required for changing the read timeout.", "- ClientPlayerEntity: Required for the secondary sprint and dismount key bindings.", "- ClientPlayNetworkHandler: Required for making the dismount overlay message show the correct key when the dismount key binding is enabled.", "- CommandManager: Required for the server-sided configuration reload command.", "- CompoundTag: Required for fixing player head stacking.", "- CustomPayloadC2SPacket: Required for setting the maximum client custom payload packet size.", "- EnchantedBookItem: Required for removing the glowing effect from enchanted books.", "- EndPortalBlockEntityRenderer: Required for fixing end portal rendering.", "- Entity:", "  - Required for fixing MC-2025.", "  - Required for fixing entities not being considered wet in cauldrons filled with water.", "- FinishQuit: Required for making Minecraft show the main menu screen after disconnecting rather than the Realms or multiplayer screen if Seamless Loading Screen is installed.", "- GameMenuScreen:", "  - Required for making Minecraft show the main menu screen after disconnecting rather than the Realms or multiplayer screen.", "  - If Seamless Loading Screen is installed, this is disabled, and FinishQuit is used instead.", "- GameOptions: Required for all key bindings added by RandomPatches.", "- InputSlotFiller: Required for fixing the recipe book not moving ingredients with tags.", "- KeyBinding:", "  - Required for the secondary sprint key.", "  - Required for making the sneak key not conflict with the dismount key.", "- Keyboard: Required for the narrator toggle, pause, GUI toggle and debug key bindings.", "- LandPathNodeMaker: Required for fixing mobs not being able to cross rails.", "- MinecraftClient:", "  - Required for changing Minecraft window options.", "  - Required for disabling the warning that displays when loading a world that uses experimental settings.", "- Mouse: Required for using mouse buttons for the narrator toggle, pause, GUI toggle and debug key bindings.", "- Option: Required for modifying the framerate limit slider step size.", "- PacketByteBuf: Required for setting the maximum NBT compound tag packet size.", "- PacketInflater: Required for setting the maximum compressed packet size.", "- PlayerInputC2SPacket: Required for the dismount key binding.", "- PotionItem: Required for removing the glowing effect from potions.", "- RenderLayers: Required for fixing water in cauldrons rendering as opaque.", "- ServerLoginNetworkHandler: Required for changing the login timeout.", "- ServerPlayNetworkHandlerKeepAlive: Required for changing KeepAlive packet settings.", "- ServerPlayNetworkHandlerPlayerSpeedLimits: Required for changing player speed limits.", "- ThreadedAnvilChunkStorage: Required for fixing duplicate entity UUIDs.", "This option is both client and server-sided.", "Changes to this option are applied after a game restart."})
        @ConfigEntry.Gui.Tooltip
        public List<String> mixinBlacklist = new ArrayList<String>();

        public void validatePostLoad() {
            this.configReloadCommand = this.configReloadCommand.trim();
            Collections.sort(this.mixinBlacklist);
        }

        public boolean isMixinClassEnabled(String mixinClassName) {
            String[] parts = StringUtils.split((String)mixinClassName, (char)'.');
            String simpleName = StringUtils.substring((String)parts[parts.length - 1], (int)0, (int)-5);
            if ("MinecraftClientPostInit".equals(simpleName)) {
                return true;
            }
            if ("VillagerResemblingModel".equals(simpleName) && !RandomPatches.config().client.bugFixes.fixVillagerRobeTextures) {
                return false;
            }
            if ("PlayerEntityRenderer".equals(simpleName) && !RandomPatches.config().client.bugFixes.fixInvisiblePlayerModel) {
                return false;
            }
            if ("BambooBlock".equals(simpleName) && !RandomPatches.config().client.optimizeBambooRendering) {
                return false;
            }
            if ("FinishQuit".equals(simpleName) && !FabricLoader.getInstance().isModLoaded("seamless_loading_screen")) {
                return false;
            }
            if ("GameMenuScreen".equals(simpleName) && FabricLoader.getInstance().isModLoaded("seamless_loading_screen")) {
                return false;
            }
            if ("Option".equals(simpleName) && FabricLoader.getInstance().isModLoaded("optifabric")) {
                return false;
            }
            if ("InputSlotFiller".equals(simpleName) && FabricLoader.getInstance().isModLoaded("nbtcrafting")) {
                return false;
            }
            if (("PacketByteBuf".equals(simpleName) || "PacketInflater".equals(simpleName)) && FabricLoader.getInstance().isModLoaded("xlpackets")) {
                return false;
            }
            if (mixinClassName.contains("datafixerupper") && !this.disableDataFixerUpper) {
                return false;
            }
            return !this.mixinBlacklist.contains(simpleName);
        }
    }

    public static final class PlayerSpeedLimits {
        @TOMLConfigSerializer.Comment(value={"The maximum player speed when not riding a vehicle or flying with elytra.", "The vanilla default is 100.0."})
        @SpecFloatInRange(min=0.0f, max=3.4028235E38f)
        @ConfigEntry.Gui.Tooltip
        public float defaultMaxSpeed = 1000000.0f;
        @TOMLConfigSerializer.Comment(value={"The maximum player elytra speed.", "The vanilla default is 300.0."})
        @SpecFloatInRange(min=0.0f, max=3.4028235E38f)
        @ConfigEntry.Gui.Tooltip
        public float maxElytraSpeed = 1000000.0f;
        @TOMLConfigSerializer.Comment(value={"The maximum player vehicle speed.", "The vanilla default is 100.0."})
        @SpecDoubleInRange(min=0.0, max=1.7976931348623157E308)
        @ConfigEntry.Gui.Tooltip
        public double maxVehicleSpeed = 1000000.0;
    }

    public static final class PacketSizeLimits {
        @SpecIntInRange(min=256, max=0x7FFFFFFF)
        @TOMLConfigSerializer.Comment(value={"The maximum compressed packet size.", "The vanilla limit is 2097152.", "This option is both client and server-sided.", "Setting this to a higher value than the vanilla limit can fix MC-185901, which may cause players to be disconnected: https://bugs.mojang.com/browse/MC-185901"})
        @ConfigEntry.Gui.Tooltip
        public int maxCompressedPacketSize = 0x1000000;
        @Path(value="max_nbt_compound_tag_packet_size")
        @SpecIntInRange(min=256, max=0x7FFFFFFF)
        @TOMLConfigSerializer.Comment(value={"The maximum NBT compound tag packet size.", "The vanilla limit is 2097152.", "This option is both client and server-sided.", "Setting this to a higher value than the vanilla limit may prevent players from being disconnected."})
        @ConfigEntry.Gui.Tooltip
        public int maxNBTCompoundTagPacketSize = 0x1000000;
        @SpecIntInRange(min=256, max=0x7FFFFFFF)
        @TOMLConfigSerializer.Comment(value={"The maximum client custom payload packet size.", "The vanilla limit is 32767.", "Setting this to a higher value than the vanilla limit may prevent the client from being disconnected."})
        @ConfigEntry.Gui.Tooltip
        public int maxClientCustomPayloadPacketSize = 0x1000000;
    }

    public static final class ConnectionTimeouts
    implements ConfigData {
        @TOMLConfigSerializer.Comment(value={"The connection read timeout in seconds.", "This value is used on both the client and the server."})
        @SpecIntInRange(min=1, max=0x7FFFFFFF)
        @ConfigEntry.Gui.Tooltip
        public int readTimeoutSeconds = 120;
        @TOMLConfigSerializer.Comment(value={"The login timeout in ticks."})
        @SpecIntInRange(min=1, max=0x7FFFFFFF)
        @ConfigEntry.Gui.Tooltip
        public int loginTimeoutTicks = 2400;
        @TOMLConfigSerializer.Comment(value={"The interval in seconds at which KeepAlive packets are sent to clients."})
        @SpecIntInRange(min=1, max=0x7FFFFFFF)
        @ConfigEntry.Gui.Tooltip
        public int keepAlivePacketIntervalSeconds = 15;
        @TOMLConfigSerializer.Comment(value={"The KeepAlive timeout in seconds.", "This is how long the server waits for a player to return a KeepAlive packet before disconnecting them.", "This is automatically rounded up to a multiple of the KeepAlive packet interval."})
        @SpecIntInRange(min=1, max=0x7FFFFFFF)
        @ConfigEntry.Gui.Tooltip
        public int keepAliveTimeoutSeconds = 120;

        public void validatePostLoad() {
            if (this.keepAliveTimeoutSeconds < this.keepAlivePacketIntervalSeconds) {
                this.keepAliveTimeoutSeconds = this.keepAlivePacketIntervalSeconds;
            } else if (this.keepAliveTimeoutSeconds % this.keepAlivePacketIntervalSeconds != 0) {
                int multiple = this.keepAliveTimeoutSeconds / this.keepAlivePacketIntervalSeconds + 1;
                this.keepAliveTimeoutSeconds = this.keepAlivePacketIntervalSeconds * multiple;
            }
        }
    }

    public static final class Window
    implements ConfigData {
        @ConfigEntry.Gui.Excluded
        public static final String DEFAULT_TITLE = FabricLoader.getInstance().isDevelopmentEnvironment() ? "RandomPatches (${username})" : "Minecraft ${mcversion}";
        @ConfigEntry.Gui.Excluded
        private static final String DEFAULT_ICON = FabricLoader.getInstance().isDevelopmentEnvironment() ? "../src/main/resources/assets/randompatches/icon.png" : "";
        @TOMLConfigSerializer.Comment(value={"Enables custom Minecraft window titles."})
        @ConfigEntry.Gui.Tooltip
        public boolean customTitle = true;
        @TOMLConfigSerializer.Comment(value={"The Minecraft window title.", "The current activity is not available.", "Variables:", " - ${mcversion}: The Minecraft version", " - ${username}: The username.", " - ${modsloaded}: The number of mods loaded.", " - ${modversion:modid}: The version of the mod with the specified ID.", "'$' can be escaped by using an extra '$'."})
        @ConfigEntry.Gui.Tooltip
        public String title = FabricLoader.getInstance().isDevelopmentEnvironment() ? "RandomPatches (${username}) - ${modsloaded} mods loaded" : DEFAULT_TITLE;
        @TOMLConfigSerializer.Comment(value={"The Minecraft window title that also takes into account the current activity.", "Variables:", " - ${mcversion}: The Minecraft version", " - ${activity}: The current activity.", " - ${username}: The username.", " - ${modsloaded}: The number of mods loaded.", " - ${modversion:modid}: The version of the mod with the specified ID.", "'$' can be escaped by using an extra '$'."})
        @ConfigEntry.Gui.Tooltip
        public String titleWithActivity = FabricLoader.getInstance().isDevelopmentEnvironment() ? "RandomPatches (${username}) - ${modsloaded} mods loaded - ${activity}" : "Minecraft ${mcversion} - ${activity}";
        @TOMLConfigSerializer.Comment(value={"Enables custom Minecraft window icons."})
        @ConfigEntry.Gui.Tooltip
        public boolean customIcon = true;
        @Path(value="icon_16x16")
        @TOMLConfigSerializer.Comment(value={"The path to the 16x16 Minecraft window icon relative to the Minecraft instance directory.", "Forward slashes should be used even on Windows to preserve compatibility with other platforms.", "Backward slashes will automatically be replaced."})
        @ConfigEntry.Gui.Tooltip
        public String icon16 = DEFAULT_ICON;
        @Path(value="icon_32x32")
        @TOMLConfigSerializer.Comment(value={"The path to the 16x16 Minecraft window icon relative to the Minecraft instance directory.", "Forward slashes should be used even on Windows to preserve compatibility with other platforms.", "Backward slashes will automatically be replaced."})
        @ConfigEntry.Gui.Tooltip
        public String icon32 = DEFAULT_ICON;
        @Path(value="icon_256x256")
        @TOMLConfigSerializer.Comment(value={"The path to the 256x256 Minecraft window icon relative to the Minecraft instance directory.", "This is only used on Mac OS X."})
        @ConfigEntry.Gui.Tooltip
        public String icon256 = DEFAULT_ICON;

        public void validatePostLoad() {
            this.icon16 = this.validateIconPath(this.icon16);
            this.icon32 = this.validateIconPath(this.icon32);
            this.icon256 = this.validateIconPath(this.icon256);
            if (this.icon16.isEmpty()) {
                if (!this.icon256.isEmpty()) {
                    this.icon16 = this.icon256;
                } else if (!this.icon32.isEmpty()) {
                    this.icon16 = this.icon32;
                }
            }
            if (this.icon32.isEmpty()) {
                String string = this.icon32 = this.icon256.isEmpty() ? this.icon16 : this.icon256;
            }
            if (this.icon256.isEmpty()) {
                this.icon256 = this.icon32;
            }
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                RPWindowHandler.onConfigReload();
            }
        }

        private String validateIconPath(String path) {
            try {
                Paths.get(path, new String[0]);
                return path.replace('\\', '/');
            }
            catch (InvalidPathException ex) {
                return DEFAULT_ICON;
            }
        }
    }

    public static final class KeyBindings
    implements ConfigData {
        @TOMLConfigSerializer.Comment(value={"The secondary sprint key binding.", "This allows double-tap sprinting to be disabled, fixing MC-203401: https://bugs.mojang.com/browse/MC-203401"})
        @ConfigEntry.Gui.Tooltip
        public boolean secondarySprint = true;
        @TOMLConfigSerializer.Comment(value={"The dismount key binding.", "This allows the dismount key to be different from the sneak key."})
        @ConfigEntry.Gui.Tooltip
        public boolean dismount = true;
        @TOMLConfigSerializer.Comment(value={"The narrator toggle key binding.", "This fixes MC-122645: https://bugs.mojang.com/browse/MC-122645"})
        @ConfigEntry.Gui.Tooltip
        public boolean toggleNarrator = true;
        @TOMLConfigSerializer.Comment(value={"The pause key binding.", "This is only for pausing and unpausing the game; the Escape key is still used to close GUI screens.", "This partially fixes MC-147718: https://bugs.mojang.com/browse/MC-147718"})
        @ConfigEntry.Gui.Tooltip
        public boolean pause = true;
        @Path(value="toggle_gui")
        @TOMLConfigSerializer.Comment(value={"The GUI toggle key binding.", "This partially fixes MC-147718: https://bugs.mojang.com/browse/MC-147718"})
        @ConfigEntry.Gui.Tooltip
        public boolean toggleGUI = true;
        @TOMLConfigSerializer.Comment(value={"The debug info toggle key binding.", "The F3 key is still used for F3 actions.", "This partially fixes MC-147718: https://bugs.mojang.com/browse/MC-147718"})
        @ConfigEntry.Gui.Tooltip
        public boolean toggleDebugInfo = true;
        @TOMLConfigSerializer.Comment(value={"Allows double-tap sprinting while flying.", "This fixes MC-68453: https://bugs.mojang.com/browse/MC-68453"})
        @ConfigEntry.Gui.Tooltip
        public boolean doubleTapSprintingWhileFlying = true;

        public void validatePostLoad() {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                RPKeyBindingHandler.onConfigReload(null);
            }
        }

        public boolean secondarySprint() {
            return this.secondarySprint && !RandomPatches.config().misc.mixinBlacklist.contains("ClientPlayerEntity") && !RandomPatches.config().misc.mixinBlacklist.contains("KeyBinding");
        }

        public boolean dismount() {
            List<String> mixinBlacklist = RandomPatches.config().misc.mixinBlacklist;
            return this.dismount && !mixinBlacklist.contains("ClientPlayerEntity") && !mixinBlacklist.contains("PlayerInputC2SPacket");
        }
    }

    public static final class ClientBugFixes
    implements ConfigData {
        @TOMLConfigSerializer.Comment(value={"Fixes water in cauldrons rendering as opaque.", "This bug is reported as MC-13187: https://bugs.mojang.com/browse/MC-13187", "Changes to this option are applied after resources are reloaded or a world restart."})
        @ConfigEntry.Gui.Tooltip
        public boolean fixWaterInCauldronsRenderingAsOpaque = true;
        @TOMLConfigSerializer.Comment(value={"Fixes end portals only rendering from above.", "This bug is reported as MC-3366: https://bugs.mojang.com/browse/MC-3366"})
        @ConfigEntry.Gui.Tooltip
        public boolean fixEndPortalsOnlyRenderingFromAbove = true;
        @TOMLConfigSerializer.Comment(value={"Fixes only 18 out of 20 rows of pixels showing of villager robe textures.", "This issue also affects witches.", "This bug is reported as MC-53312: https://bugs.mojang.com/browse/MC-53312", "Changes to this option are applied after a game restart."})
        @ConfigEntry.Gui.Tooltip
        public boolean fixVillagerRobeTextures = true;
        @TOMLConfigSerializer.Comment(value={"Fixes the player model sometimes disappearing in certain instances.", "This is most noticeable when flying with elytra in a straight line in third-person mode.", "A video of this issue can be found here: https://youtu.be/YdbxknpfJHQ", "Changes to this option are applied after a game restart."})
        @ConfigEntry.Gui.Tooltip
        public boolean fixInvisiblePlayerModel = true;

        public void validatePostLoad() {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                CauldronWaterTranslucencyHandler.onConfigReload();
            }
        }
    }

    public static final class Client {
        @TOMLConfigSerializer.Comment(value={"Client-sided bug fixes."})
        @ConfigEntry.Category(value="bug_fixes")
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public ClientBugFixes bugFixes = new ClientBugFixes();
        @TOMLConfigSerializer.Comment(value={"Options related to key bindings."})
        @ConfigEntry.Category(value="key_bindings")
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public KeyBindings keyBindings = new KeyBindings();
        @TOMLConfigSerializer.Comment(value={"Options related to the Minecraft window."})
        @ConfigEntry.Category(value="window")
        @ConfigEntry.Gui.CollapsibleObject
        @ConfigEntry.Gui.Tooltip
        public Window window = new Window();
        @TOMLConfigSerializer.Comment(value={"Optimizes bamboo rendering.", "This works by overriding the method that returns the ambient occlusion light value for the bamboo block, which runs some expensive logic, but always returns 1.0F.", "Changes to this option are applied after a game restart."})
        @ConfigEntry.Gui.Tooltip
        public boolean optimizeBambooRendering = true;
        @TOMLConfigSerializer.Comment(value={"Removes the glowing effect from potions.", "This makes the potion colors more visible."})
        @ConfigEntry.Gui.Tooltip
        public boolean removeGlowingEffectFromPotions = true;
        @TOMLConfigSerializer.Comment(value={"Removes the glowing effect from enchanted books."})
        @ConfigEntry.Gui.Tooltip
        public boolean removeGlowingEffectFromEnchantedBooks = FabricLoader.getInstance().isDevelopmentEnvironment();
        @TOMLConfigSerializer.Comment(value={"Disables the warning that displays when loading a world that uses experimental settings."})
        @ConfigEntry.Gui.Tooltip
        public boolean disableExperimentalSettingsWarning = true;
        @SpecFloatInRange(min=1.4E-45f, max=260.0f)
        @TOMLConfigSerializer.Comment(value={"The framerate limit slider step size.", "The vanilla default is 10.0."})
        @ConfigEntry.Gui.Tooltip
        public float framerateLimitSliderStepSize = 1.0f;
        @TOMLConfigSerializer.Comment(value={"Causes Minecraft to show the main menu screen after disconnecting rather than the Realms or multiplayer screen."})
        @ConfigEntry.Gui.Tooltip
        public boolean returnToMainMenuAfterDisconnect = FabricLoader.getInstance().isDevelopmentEnvironment();
        @TOMLConfigSerializer.Comment(value={"Gives capes to RandomPatches contributors."})
        @ConfigEntry.Gui.Tooltip
        public boolean contributorCapes = true;

        public boolean contributorCapes() {
            List<String> mixinBlacklist = RandomPatches.config().misc.mixinBlacklist;
            return this.contributorCapes && !mixinBlacklist.contains("ClientPlayerEntity") && !mixinBlacklist.contains("PlayerEntityRendererContributorCapes") && !mixinBlacklist.contains("PlayerListEntry");
        }
    }
}

