/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.oneshot;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.jellysquid.mods.sodium.client.SodiumHooks;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.gl.util.GlMultiDrawBatch;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.oneshot.ChunkOneshotGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.oneshot.ChunkProgramOneshot;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkRenderShaderBackend;
import net.minecraft.class_2960;
import org.lwjgl.opengl.GL20;

public abstract class ChunkRenderBackendOneshot<T extends ChunkOneshotGraphicsState>
extends ChunkRenderShaderBackend<T, ChunkProgramOneshot> {
    private final GlMultiDrawBatch batch = new GlMultiDrawBatch(ModelQuadFacing.COUNT);
    private final MemoryTracker memoryTracker = new MemoryTracker();

    public ChunkRenderBackendOneshot(ChunkVertexType vertexType) {
        super(vertexType);
    }

    @Override
    protected ChunkProgramOneshot createShaderProgram(class_2960 name, int handle, ChunkFogMode fogMode) {
        return new ChunkProgramOneshot(name, handle, fogMode.getFactory());
    }

    @Override
    protected GlShader createVertexShader(ChunkFogMode fogMode) {
        class_2960 identifier = SodiumHooks.useClipping.getAsBoolean() ? new class_2960("sodium", "chunk_clip_gl30.v.glsl") : new class_2960("sodium", "chunk_gl20.v.glsl");
        return ShaderLoader.loadShader(ShaderType.VERTEX, identifier, fogMode.getDefines());
    }

    @Override
    protected GlShader createFragmentShader(ChunkFogMode fogMode) {
        return ShaderLoader.loadShader(ShaderType.FRAGMENT, new class_2960("sodium", "chunk_gl20.f.glsl"), fogMode.getDefines());
    }

    @Override
    public void upload(Iterator<ChunkBuildResult<T>> queue) {
        while (queue.hasNext()) {
            ChunkBuildResult<T> result = queue.next();
            ChunkRenderContainer<ChunkOneshotGraphicsState> render = result.render;
            ChunkRenderData data = result.data;
            for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                ChunkOneshotGraphicsState state = (ChunkOneshotGraphicsState)render.getGraphicsState(pass);
                ChunkMeshData mesh = data.getMesh(pass);
                if (mesh.hasVertexData()) {
                    if (state == null) {
                        state = this.createGraphicsState(this.memoryTracker, render);
                    }
                    state.upload(mesh);
                } else {
                    if (state != null) {
                        state.delete();
                    }
                    state = null;
                }
                render.setGraphicsState(pass, state);
            }
            render.setData(data);
        }
    }

    @Override
    public void render(ChunkRenderListIterator<T> it, ChunkCameraContext camera) {
        while (it.hasNext()) {
            ChunkOneshotGraphicsState state = (ChunkOneshotGraphicsState)it.getGraphicsState();
            int visibleFaces = it.getVisibleFaces();
            this.buildBatch(state, visibleFaces);
            if (this.batch.isBuilding()) {
                this.prepareDrawBatch(camera, state);
                this.drawBatch(state);
            }
            it.advance();
        }
    }

    protected void prepareDrawBatch(ChunkCameraContext camera, T state) {
        float modelX = camera.getChunkModelOffset(((ChunkGraphicsState)state).getX(), camera.blockOriginX, camera.originX);
        float modelY = camera.getChunkModelOffset(((ChunkGraphicsState)state).getY(), camera.blockOriginY, camera.originY);
        float modelZ = camera.getChunkModelOffset(((ChunkGraphicsState)state).getZ(), camera.blockOriginZ, camera.originZ);
        ((ChunkProgramOneshot)this.activeProgram).setModelOffset(modelX, modelY, modelZ);
    }

    protected void buildBatch(T state, int visibleFaces) {
        GlMultiDrawBatch batch = this.batch;
        batch.begin();
        for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
            if ((visibleFaces & 1 << i) == 0) continue;
            long part = ((ChunkOneshotGraphicsState)state).getModelPart(i);
            batch.addChunkRender(BufferSlice.unpackStart(part), BufferSlice.unpackLength(part));
        }
    }

    protected void drawBatch(T state) {
        this.batch.end();
        ((ChunkOneshotGraphicsState)state).bind();
        GL20.glMultiDrawArrays((int)7, (IntBuffer)this.batch.getIndicesBuffer(), (IntBuffer)this.batch.getLengthBuffer());
    }

    protected abstract T createGraphicsState(MemoryTracker var1, ChunkRenderContainer<T> var2);

    @Override
    public void delete() {
        super.delete();
        this.batch.delete();
    }

    @Override
    public List<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("VRAM Usage: %s MB", MemoryTracker.toMiB(this.memoryTracker.getUsedMemory())));
        return list;
    }
}

