/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.collections;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class FixedLongHashTable<V>
implements Hash {
    protected final long[] key;
    protected final V[] value;
    protected final int mask;
    protected final int capacity;
    protected boolean containsNullKey;
    protected int size;

    public FixedLongHashTable(int capacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("The expected number of elements must be non-negative");
        }
        this.capacity = HashCommon.arraySize((int)capacity, (float)loadFactor);
        this.mask = this.capacity - 1;
        this.key = new long[this.capacity + 1];
        this.value = new Object[this.capacity + 1];
    }

    private V removeEntry(int pos) {
        V prev = this.value[pos];
        this.value[pos] = null;
        --this.size;
        this.shiftKeys(pos);
        return prev;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        V prev = this.value[this.capacity];
        this.value[this.capacity] = null;
        --this.size;
        return prev;
    }

    private int find(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.capacity : -(this.capacity + 1);
        }
        long[] key = this.key;
        int pos = (int)HashCommon.mix((long)k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private void insert(int pos, long k, V v) {
        if (pos == this.capacity) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.capacity) {
            throw new IllegalStateException("Exceeded capacity of map");
        }
    }

    public V put(long k, V v) {
        int pos = this.find(k);
        if (pos < 0) {
            this.insert(-pos - 1, k, v);
            return null;
        }
        V prev = this.value[pos];
        this.value[pos] = v;
        return prev;
    }

    protected final void shiftKeys(int pos) {
        long[] key = this.key;
        while (true) {
            long curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0L) {
                    key[last] = 0L;
                    this.value[last] = null;
                    return;
                }
                int slot = (int)HashCommon.mix((long)curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    public V remove(long k) {
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return null;
        }
        long[] key = this.key;
        int pos = (int)HashCommon.mix((long)k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return null;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return null;
        } while (k != curr);
        return this.removeEntry(pos);
    }

    public V get(long k) {
        if (k == 0L) {
            return this.containsNullKey ? (V)this.value[this.capacity] : null;
        }
        long[] key = this.key;
        int pos = (int)HashCommon.mix((long)k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return null;
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return null;
        } while (k != curr);
        return this.value[pos];
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0L);
        Arrays.fill(this.value, null);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ObjectIterator<Long2ObjectMap.Entry<V>> iterator() {
        return new FastEntryIterator();
    }

    private class FastEntryIterator
    implements ObjectIterator<Long2ObjectMap.Entry<V>> {
        private final MapEntry entry;
        private int pos;
        private int c;
        private boolean mustReturnNullKey;

        private FastEntryIterator() {
            this.entry = new MapEntry();
            this.pos = FixedLongHashTable.this.capacity;
            this.c = FixedLongHashTable.this.size;
            this.mustReturnNullKey = FixedLongHashTable.this.containsNullKey;
        }

        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                return FixedLongHashTable.this.capacity;
            }
            long[] key = FixedLongHashTable.this.key;
            while (key[--this.pos] == 0L) {
            }
            return this.pos;
        }
    }

    private final class MapEntry
    implements Long2ObjectMap.Entry<V>,
    Map.Entry<Long, V> {
        private int index;

        private MapEntry() {
        }

        public long getLongKey() {
            return FixedLongHashTable.this.key[this.index];
        }

        @Override
        public V getValue() {
            return FixedLongHashTable.this.value[this.index];
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return FixedLongHashTable.this.key[this.index] + "=>" + FixedLongHashTable.this.value[this.index];
        }
    }
}

