/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_287;
import net.minecraft.class_4581;
import net.minecraft.class_4585;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585 {
    @Shadow
    private boolean field_21594;

    public void method_22920(class_4587.class_4665 matrices, class_777 quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.field_21594) {
            super.method_22920(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        class_1159 modelMatrix = matrices.method_23761();
        class_4581 normalMatrix = matrices.method_23762();
        int norm = MatrixUtil.computeNormal(normalMatrix, quad.method_3358());
        QuadVertexSink drain = VertexDrain.of((class_4588)this).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            class_1162 pos = new class_1162(x, y, z, 1.0f);
            pos.method_22674(modelMatrix);
            drain.writeQuad(pos.method_4953(), pos.method_4956(), pos.method_4957(), color, u, v, light[i], overlay, norm);
        }
        drain.flush();
    }
}

