/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.resources;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import juuxel.adorn.Adorn;
import juuxel.adorn.client.resources.ColorManager;
import juuxel.adorn.client.resources.ColorPalette;
import juuxel.adorn.util.ColorsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00020\u00012\u00020\u0006:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0007J2\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0012H\u0002J*\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljuuxel/adorn/client/resources/ColorManager;", "Lnet/minecraft/resource/SinglePreparationResourceReloadListener;", "", "Lnet/minecraft/util/Identifier;", "", "Lblue/endless/jankson/JsonObject;", "Lnet/fabricmc/fabric/api/resource/IdentifiableResourceReloadListener;", "()V", "COLOR_REGEX", "Lkotlin/text/Regex;", "FALLBACK", "ID", "JANKSON", "Lblue/endless/jankson/Jankson;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "PREFIX", "", "SUFFIX_LENGTH", "", "map", "", "Ljuuxel/adorn/client/resources/ColorPalette;", "apply", "", "manager", "Lnet/minecraft/resource/ResourceManager;", "profiler", "Lnet/minecraft/util/profiler/Profiler;", "getColors", "id", "getFabricId", "parseHexColor", "str", "prepare", "ColorPair", "Adorn"})
@Environment(value=EnvType.CLIENT)
public final class ColorManager
extends class_4080<Map<class_2960, ? extends List<? extends JsonObject>>>
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER;
    private static final Jankson JANKSON;
    private static final class_2960 ID;
    private static final class_2960 FALLBACK;
    private static final String PREFIX = "adorn/color_palettes";
    private static final int SUFFIX_LENGTH = 6;
    private static final Regex COLOR_REGEX;
    private static final Map<class_2960, ColorPalette> map;
    @NotNull
    public static final ColorManager INSTANCE;

    @NotNull
    public class_2960 getFabricId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected Map<class_2960, List<JsonObject>> prepare(@NotNull class_3300 manager, @NotNull class_3695 profiler) {
        Collection ids2;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Collection collection = ids2 = manager.method_14488(PREFIX, (Predicate)prepare.ids.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ids");
        Iterable $this$associateWith$iv = collection;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void id;
            class_2960 class_29602 = (class_2960)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = manager.method_14489((class_2960)id);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manager.getAllResources(id)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonObject jsonObject;
                void resource;
                class_3298 class_32982 = (class_3298)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                void v2 = resource;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resource");
                Closeable closeable = v2.method_14482();
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)JANKSON.load(input), (String)"JANKSON.load(input)");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                JsonObject jsonObject2 = jsonObject;
                collection2.add(jsonObject2);
            }
            List list2 = (List)destination$iv$iv;
            map.put(t, list2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    protected void apply(@NotNull Map<class_2960, ? extends List<? extends JsonObject>> map, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        class_2960 class_29602 = map;
        boolean bl = false;
        Iterator iterator = class_29602.entrySet().iterator();
        while (iterator.hasNext()) {
            void id;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            class_29602 = (class_2960)entry2.getKey();
            entry2 = entry;
            boolean bl3 = false;
            List jsons = (List)entry2.getValue();
            HashMap scheme = new HashMap();
            for (JsonObject jsonObject : jsons) {
                Object object = (Map)jsonObject;
                boolean bl4 = false;
                Iterator iterator2 = object.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void key;
                    Map.Entry entry3;
                    Map.Entry entry4 = entry3 = iterator2.next();
                    boolean bl5 = false;
                    object = (String)entry4.getKey();
                    entry4 = entry3;
                    bl5 = false;
                    JsonElement value = (JsonElement)entry4.getValue();
                    class_2960 keyId = class_2960.method_12829((String)key);
                    if (keyId == null) {
                        LOGGER.warn("[Adorn] Invalid key '{}' in color palette {} - must be a valid identifier", (Object)key, (Object)id);
                        continue;
                    }
                    Map map2 = scheme;
                    JsonElement jsonElement = value;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"value");
                    map2.put(keyId, ColorPair.Companion.fromJson(jsonElement));
                }
            }
            String string = id.method_12836();
            String string2 = id.method_12832();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.path");
            String string3 = string2;
            int entry3 = 21;
            int iterator2 = id.method_12832().length() - 6;
            boolean object = false;
            Object object2 = string3;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)object2).substring(entry3, iterator2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            class_2960 class_29603 = new class_2960(string, string4);
            ColorManager.map.put(class_29603, new ColorPalette(scheme));
        }
    }

    private final int parseHexColor(String str) {
        int n;
        CharSequence charSequence = str;
        Regex regex = COLOR_REGEX;
        int n2 = 0;
        boolean bl = regex.matches(charSequence);
        boolean bl2 = false;
        n2 = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Color must be a hex color beginning with '#' - found '" + str + '\'';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = str;
        n2 = 1;
        int n3 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String colorStr = string3;
        int len = colorStr.length();
        switch (len) {
            case 6: {
                String string4 = colorStr;
                n3 = 16;
                boolean bl4 = false;
                n = ColorsKt.color$default(Integer.parseInt(string4, CharsKt.checkRadix((int)n3)), 0, 2, null);
                break;
            }
            case 8: {
                String string5 = colorStr;
                n3 = 16;
                boolean bl5 = false;
                n = Integer.parseInt(string5, CharsKt.checkRadix((int)n3));
                break;
            }
            default: {
                String string6 = "Invalid color length: " + len;
                n3 = 0;
                throw (Throwable)new IllegalStateException(string6.toString());
            }
        }
        return n;
    }

    @NotNull
    public final ColorPalette getColors(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ColorPalette colorPalette = map.get(id);
        if (colorPalette == null) {
            colorPalette = map.get(FALLBACK);
        }
        if (colorPalette == null) {
            throw (Throwable)new IllegalStateException("Could not find fallback palette!");
        }
        return colorPalette;
    }

    private ColorManager() {
    }

    static {
        ColorManager colorManager;
        INSTANCE = colorManager = new ColorManager();
        LOGGER = LogManager.getLogger();
        JANKSON = Jankson.builder().build();
        ID = Adorn.INSTANCE.id("color_manager");
        FALLBACK = Adorn.INSTANCE.id("fallback");
        COLOR_REGEX = new Regex("#(?:[0-9A-Fa-f]{2})?[0-9A-Fa-f]{6}");
        map = new HashMap();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "", "bg", "", "fg", "(II)V", "getBg", "()I", "getFg", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "Adorn"})
    public static final class ColorPair {
        private final int bg;
        private final int fg;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final int getBg() {
            return this.bg;
        }

        public final int getFg() {
            return this.fg;
        }

        public ColorPair(int bg, int fg) {
            this.bg = bg;
            this.fg = fg;
        }

        public /* synthetic */ ColorPair(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = 0x404040;
            }
            this(n, n2);
        }

        public final int component1() {
            return this.bg;
        }

        public final int component2() {
            return this.fg;
        }

        @NotNull
        public final ColorPair copy(int bg, int fg) {
            return new ColorPair(bg, fg);
        }

        public static /* synthetic */ ColorPair copy$default(ColorPair colorPair, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = colorPair.bg;
            }
            if ((n3 & 2) != 0) {
                n2 = colorPair.fg;
            }
            return colorPair.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ColorPair(bg=" + this.bg + ", fg=" + this.fg + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.bg) * 31 + Integer.hashCode(this.fg);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ColorPair)) break block3;
                    ColorPair colorPair = (ColorPair)object;
                    if (this.bg != colorPair.bg || this.fg != colorPair.fg) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\t"}, d2={"Ljuuxel/adorn/client/resources/ColorManager$ColorPair$Companion;", "", "()V", "fromJson", "Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "json", "Lblue/endless/jankson/JsonElement;", "asString", "", "Adorn"})
        public static final class Companion {
            private final String asString(JsonElement $this$asString) {
                JsonElement jsonElement = $this$asString;
                if (jsonElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type blue.endless.jankson.JsonPrimitive");
                }
                String string = ((JsonPrimitive)jsonElement).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as JsonPrimitive).asString()");
                return string;
            }

            @NotNull
            public final ColorPair fromJson(@NotNull JsonElement json) {
                ColorPair colorPair;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                JsonElement jsonElement = json;
                if (jsonElement instanceof JsonObject) {
                    colorPair = ((JsonObject)json).containsKey((Object)"fg") ? new ColorPair(INSTANCE.parseHexColor(this.asString((JsonElement)((JsonObject)json).get((Object)"bg"))), INSTANCE.parseHexColor(this.asString((JsonElement)((JsonObject)json).get((Object)"fg")))) : new ColorPair(INSTANCE.parseHexColor(this.asString((JsonElement)((JsonObject)json).get((Object)"bg"))), 0, 2, null);
                } else if (jsonElement instanceof JsonPrimitive) {
                    String string = ((JsonPrimitive)json).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.asString()");
                    colorPair = new ColorPair(INSTANCE.parseHexColor(string), 0, 2, null);
                } else {
                    throw (Throwable)new IllegalArgumentException("Invalid color value: " + json);
                }
                return colorPair;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

