/*
 * Decompiled with CFR 0.152.
 */
package com.skaggsm.treechoppermod;

import com.skaggsm.treechoppermod.ChopMode;
import com.skaggsm.treechoppermod.FabricTreeChopperFiberConfig;
import com.skaggsm.treechoppermod.FullChopDurabilityMode;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import me.shedaniel.fiber2cloth.api.Fiber2Cloth;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0016J\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001fH\u0002J\u0015\u0010$\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020&H\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0019\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/skaggsm/treechoppermod/FabricTreeChopper;", "Lnet/fabricmc/api/ModInitializer;", "()V", "MODID", "", "config", "Lcom/skaggsm/treechoppermod/FabricTreeChopperFiberConfig;", "getConfig", "()Lcom/skaggsm/treechoppermod/FabricTreeChopperFiberConfig;", "setConfig", "(Lcom/skaggsm/treechoppermod/FabricTreeChopperFiberConfig;)V", "configFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getConfigFile", "()Ljava/nio/file/Path;", "configTree", "Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;", "getConfigTree", "()Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;", "setConfigTree", "(Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;)V", "oldConfigFile", "getOldConfigFile", "oldConfigFileBackup", "getOldConfigFileBackup", "serializer", "Lio/github/fablabsmc/fablabs/api/fiber/v1/serialization/JanksonValueSerializer;", "getSerializer", "()Lio/github/fablabsmc/fablabs/api/fiber/v1/serialization/JanksonValueSerializer;", "deserialize", "", "handleOldConfigs", "onInitialize", "serialize", "updateConfigTree", "until", "Ljava/time/Duration;", "Ljava/time/Instant;", "other", "fabric-tree-chopper"})
public final class FabricTreeChopper
implements ModInitializer {
    @NotNull
    public static final String MODID = "fabric-tree-chopper";
    @NotNull
    private static final JanksonValueSerializer serializer;
    private static final Path configFile;
    private static final Path oldConfigFile;
    private static final Path oldConfigFileBackup;
    public static FabricTreeChopperFiberConfig config;
    public static ConfigBranch configTree;
    @NotNull
    public static final FabricTreeChopper INSTANCE;

    @NotNull
    public final JanksonValueSerializer getSerializer() {
        return serializer;
    }

    public final Path getConfigFile() {
        return configFile;
    }

    public final Path getOldConfigFile() {
        return oldConfigFile;
    }

    public final Path getOldConfigFileBackup() {
        return oldConfigFileBackup;
    }

    @NotNull
    public final FabricTreeChopperFiberConfig getConfig() {
        FabricTreeChopperFiberConfig fabricTreeChopperFiberConfig = config;
        if (fabricTreeChopperFiberConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return fabricTreeChopperFiberConfig;
    }

    public final void setConfig(@NotNull FabricTreeChopperFiberConfig fabricTreeChopperFiberConfig) {
        Intrinsics.checkNotNullParameter((Object)fabricTreeChopperFiberConfig, (String)"<set-?>");
        config = fabricTreeChopperFiberConfig;
    }

    @NotNull
    public final ConfigBranch getConfigTree() {
        ConfigBranch configBranch = configTree;
        if (configBranch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configTree");
        }
        return configBranch;
    }

    public final void setConfigTree(@NotNull ConfigBranch configBranch) {
        Intrinsics.checkNotNullParameter((Object)configBranch, (String)"<set-?>");
        configTree = configBranch;
    }

    public void onInitialize() {
        config = new FabricTreeChopperFiberConfig();
        this.handleOldConfigs();
        AnnotatedSettings.Builder settingsBuilder = AnnotatedSettings.builder();
        FabricLoader fabricLoader = FabricLoader.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fabricLoader, (String)"FabricLoader.getInstance()");
        if (fabricLoader.getEnvironmentType() == EnvType.CLIENT) {
            Fiber2Cloth.configure((AnnotatedSettings.Builder)settingsBuilder);
        }
        AnnotatedSettings settings = settingsBuilder.build();
        ConfigTreeBuilder configTreeBuilder = ConfigTree.builder();
        FabricTreeChopperFiberConfig fabricTreeChopperFiberConfig = config;
        if (fabricTreeChopperFiberConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        ConfigBranch configBranch = configTreeBuilder.applyFromPojo((Object)fabricTreeChopperFiberConfig, settings).build();
        Intrinsics.checkNotNullExpressionValue((Object)configBranch, (String)"ConfigTree.builder().app\u2026config, settings).build()");
        configTree = configBranch;
        if (Files.notExists(configFile, new LinkOption[0])) {
            this.serialize();
        }
        this.deserialize();
    }

    private final Duration until(Instant $this$until, Instant other) {
        Duration duration = Duration.between($this$until, other);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(this, other)");
        return duration;
    }

    private final void handleOldConfigs() {
        if (Files.exists(oldConfigFile, new LinkOption[0])) {
            this.updateConfigTree();
        }
        if (Files.exists(oldConfigFileBackup, new LinkOption[0])) {
            Instant instant = Files.getLastModifiedTime(oldConfigFileBackup, new LinkOption[0]).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Files.getLastModifiedTim\u2026igFileBackup).toInstant()");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"Instant.now()");
            if (this.until(instant, instant2).compareTo(Duration.ofDays(14L)) >= 0) {
                Files.delete(oldConfigFileBackup);
            }
        }
    }

    private final void updateConfigTree() {
        Scanner scan = new Scanner(oldConfigFile);
        Regex regex = new Regex("(.+) = \"?(\\w+)\"?");
        String line = "";
        MatchResult matchResult = null;
        while (scan.hasNextLine()) {
            Intrinsics.checkNotNullExpressionValue((Object)scan.nextLine(), (String)"scan.nextLine()");
            Intrinsics.checkNotNull((Object)Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null));
            switch ((String)matchResult.getGroupValues().get(1)) {
                case "fastLeafDecay": {
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    String string = (String)matchResult.getGroupValues().get(2);
                    boolean bl = false;
                    config.fastLeafDecay = Boolean.parseBoolean(string);
                    break;
                }
                case "treeChopMode": {
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    config.treeChopMode = ChopMode.valueOf((String)matchResult.getGroupValues().get(2));
                    break;
                }
                case "fullChopDurabilityUsage": {
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    config.fullChopDurabilityUsage = FullChopDurabilityMode.valueOf((String)matchResult.getGroupValues().get(2));
                    break;
                }
                case "sneakToDisable": {
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    String string = (String)matchResult.getGroupValues().get(2);
                    boolean bl = false;
                    config.sneakToDisable = Boolean.parseBoolean(string);
                    break;
                }
                case "requireLeavesToChop": {
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    }
                    String string = (String)matchResult.getGroupValues().get(2);
                    boolean bl = false;
                    config.requireLeavesToChop = Boolean.parseBoolean(string);
                    break;
                }
            }
        }
        Files.move(oldConfigFile, oldConfigFileBackup, new CopyOption[0]);
    }

    public final void serialize() {
        ConfigBranch configBranch = configTree;
        if (configBranch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configTree");
        }
        FiberSerialization.serialize((ConfigTree)((ConfigTree)configBranch), (OutputStream)Files.newOutputStream(configFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE), (ValueSerializer)((ValueSerializer)serializer));
    }

    public final void deserialize() {
        ConfigBranch configBranch = configTree;
        if (configBranch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configTree");
        }
        FiberSerialization.deserialize((ConfigTree)((ConfigTree)configBranch), (InputStream)Files.newInputStream(configFile, StandardOpenOption.READ), (ValueSerializer)((ValueSerializer)serializer));
    }

    private FabricTreeChopper() {
    }

    static {
        FabricTreeChopper fabricTreeChopper;
        INSTANCE = fabricTreeChopper = new FabricTreeChopper();
        serializer = new JanksonValueSerializer(false);
        configFile = Paths.get("config", "fabric-tree-chopper.json");
        oldConfigFile = Paths.get("config", "fabric-tree-chopper.toml");
        oldConfigFileBackup = Paths.get("config", "fabric-tree-chopper.toml.old");
    }
}

