/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.core.BYGBlocks;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;

public class GiantFlowerConfig
implements class_3037 {
    public static final Codec<GiantFlowerConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)class_4651.field_24937.fieldOf("petal_provider").forGetter(config -> config.petalProvider), (App)class_4651.field_24937.fieldOf("petal2_provider").forGetter(config -> config.petalProvider), (App)class_4651.field_24937.fieldOf("petal3_provider").forGetter(config -> config.petalProvider), (App)class_4651.field_24937.fieldOf("pollen_provider").forGetter(config -> config.pollenProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)1).forGetter(config -> config.maxPossibleHeight)).apply((Applicative)codecRecorder, GiantFlowerConfig::new));
    private final class_4651 stemProvider;
    private final class_4651 petalProvider;
    private final class_4651 petal2Provider;
    private final class_4651 petal3Provider;
    private final class_4651 pollenProvider;
    private final int minHeight;
    private final int maxPossibleHeight;
    private boolean forcedPlacement = false;

    GiantFlowerConfig(class_4651 stemProvider, class_4651 petalProvider, class_4651 petal2Provider, class_4651 petal3Provider, class_4651 pollenProvider, int minHeight, int maxPossibleHeight) {
        this.stemProvider = stemProvider;
        this.petalProvider = petalProvider;
        this.petal2Provider = petal2Provider;
        this.petal3Provider = petal3Provider;
        this.pollenProvider = pollenProvider;
        this.minHeight = minHeight;
        this.maxPossibleHeight = maxPossibleHeight;
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public class_4651 getStemProvider() {
        return this.stemProvider;
    }

    public class_4651 getPetalProvider() {
        return this.petalProvider;
    }

    public class_4651 getPetal2Provider() {
        return this.petal2Provider;
    }

    public class_4651 getPetal3Provider() {
        return this.petal3Provider;
    }

    public class_4651 getPollenProvider() {
        return this.pollenProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxPossibleHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private class_4651 stemProvider = new class_4656(class_2246.field_10431.method_9564());
        private class_4651 petalProvider;
        private class_4651 petal2Provider = this.petalProvider = new class_4656(class_2246.field_10503.method_9564());
        private class_4651 petal3Provider = this.petalProvider;
        private class_4651 pollenProvider = new class_4656(BYGBlocks.POLLEN_BLOCK.method_9564());
        private int minHeight = 15;
        private int maxPossibleHeight = 1;

        public Builder setStemBlock(class_2248 block) {
            this.stemProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setStemBlock(class_2680 state) {
            this.stemProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10431.method_9564());
            return this;
        }

        public Builder setPetalBlock(class_2248 block) {
            this.petalProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setPetalBlock(class_2680 state) {
            this.petalProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setPetalBlock(class_4657 statesList) {
            this.petalProvider = statesList != null ? statesList : new class_4656(class_2246.field_10503.method_9564());
            return this;
        }

        public Builder setPetal2Block(class_2248 block) {
            this.petal2Provider = block != null ? new class_4656(block.method_9564()) : this.petalProvider;
            return this;
        }

        public Builder setPetal2Block(class_2680 state) {
            this.petal2Provider = state != null ? new class_4656(state) : this.petalProvider;
            return this;
        }

        public Builder setPetal3Block(class_2248 block) {
            this.petal3Provider = block != null ? new class_4656(block.method_9564()) : this.petalProvider;
            return this;
        }

        public Builder setPetal3Block(class_2680 state) {
            this.petal3Provider = state != null ? new class_4656(state) : this.petalProvider;
            return this;
        }

        public Builder setPollenBlock(class_2248 block) {
            this.petal3Provider = block != null ? new class_4656(block.method_9564()) : this.petalProvider;
            return this;
        }

        public Builder setPollenBlock(class_2680 state) {
            this.petal3Provider = state != null ? new class_4656(state) : this.petalProvider;
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder copy(GiantFlowerConfig config) {
            this.maxPossibleHeight = config.maxPossibleHeight;
            this.minHeight = config.minHeight;
            this.stemProvider = config.stemProvider;
            this.petalProvider = config.petalProvider;
            this.petal2Provider = config.petal2Provider;
            this.petal3Provider = config.petal3Provider;
            this.pollenProvider = config.pollenProvider;
            return this;
        }

        public GiantFlowerConfig build() {
            return new GiantFlowerConfig(this.stemProvider, this.petalProvider, this.petal2Provider, this.petal3Provider, this.pollenProvider, this.minHeight, this.maxPossibleHeight);
        }
    }
}

