/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import corgiaoc.byg.common.world.feature.overworld.river.MegaChunkPos;
import corgiaoc.byg.common.world.feature.overworld.river.RiverGenerator;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.io.ByteArrayOutputStream;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_5281;

public class MegaChunk {
    private final MegaChunkPos megaChunkPos;
    private final class_1966 provider;
    private final class_2794 chunkGenerator;
    private final Set<class_1959> allowedBiomes;
    private final byte[] canyonChunks;
    private RiverGenerator riverGenerator;

    public MegaChunk(MegaChunkPos megaChunkPos, class_2794 chunkGenerator, Set<class_1959> allowedBiomes) {
        this.megaChunkPos = megaChunkPos;
        this.chunkGenerator = chunkGenerator;
        this.provider = chunkGenerator.method_12098();
        this.allowedBiomes = allowedBiomes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_1923 chunkPos = megaChunkPos.toChunkPos(x, z);
                class_1959 noiseBiome = chunkGenerator.method_12098().method_16359((chunkPos.field_9181 << 2) + 2, 0, (chunkPos.field_9180 << 2) + 2);
                if (!allowedBiomes.contains(noiseBiome)) continue;
                byteArrayOutputStream.write(MegaChunkPos.packLocalPos(x, z));
            }
        }
        this.canyonChunks = byteArrayOutputStream.toByteArray();
    }

    public int getCount() {
        return this.canyonChunks.length;
    }

    public MegaChunkPos getMegaChunkPos() {
        return this.megaChunkPos;
    }

    public RiverGenerator getRiverGenerator() {
        return this.riverGenerator;
    }

    public void createRiverGeneratorStart(FastNoise noise, class_5281 world, long worldSeed, int maxRiverDistance) {
        class_2919 seedRandom = new class_2919(worldSeed);
        seedRandom.method_12664(934893458905904595L, this.megaChunkPos.getX(), this.megaChunkPos.getZ());
        byte canyonChunkByte = this.canyonChunks[seedRandom.nextInt(this.canyonChunks.length)];
        class_2338 startPos = this.megaChunkPos.unpackLocalPos(canyonChunkByte).method_8323();
        this.riverGenerator = new RiverGenerator(noise, world, new class_2338(startPos.method_10263(), this.chunkGenerator.method_20402(startPos.method_10263(), startPos.method_10260(), class_2902.class_2903.field_13195), startPos.method_10260()), this.chunkGenerator, blockpos -> false, blockpos -> {
            class_1959.class_1961 category = this.provider.method_16359(blockpos.method_10263() >> 2, blockpos.method_10264() >> 2, blockpos.method_10260() >> 2).method_8688();
            return category == class_1959.class_1961.field_9369 || category == class_1959.class_1961.field_9367 || this.chunkGenerator.method_16397(blockpos.method_10263(), blockpos.method_10260(), class_2902.class_2903.field_13195) <= this.chunkGenerator.method_16398();
        }, maxRiverDistance);
    }

    public void createRiverGenerator(FastNoise noise, class_2338 generatorStartPos, class_5281 world, int maxRiverDistance) {
        this.riverGenerator = new RiverGenerator(noise, world, new class_2338(generatorStartPos.method_10263(), 218, generatorStartPos.method_10260()), this.chunkGenerator, blockpos -> false, blockpos -> {
            class_1959.class_1961 category = this.provider.method_16359(blockpos.method_10263() >> 2, blockpos.method_10264() >> 2, blockpos.method_10260() >> 2).method_8688();
            return category == class_1959.class_1961.field_9369 || category == class_1959.class_1961.field_9367 || this.chunkGenerator.method_16397(blockpos.method_10263(), blockpos.method_10260(), class_2902.class_2903.field_13195) <= this.chunkGenerator.method_16398();
        }, maxRiverDistance);
    }
}

