/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5321;

public class RiverGenerator {
    private final List<Node> nodes;
    private final Map<class_1923, List<Node>> fastNodes;

    public RiverGenerator(FastNoise noise, class_5281 world, class_2338 startPos, class_2794 generator, Predicate<class_2338> isInvalid, Predicate<class_2338> isValid, int maxDistance) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<class_1923, List<Node>> fastNodes = new HashMap<class_1923, List<Node>>();
        nodes.add(new Node(startPos, 0));
        int distanceInNodes = maxDistance / 5;
        int startY = startPos.method_10264();
        for (int i = 1; i < distanceInNodes; ++i) {
            class_2338 pos;
            Node nextNode;
            Node prevNode = (Node)nodes.get(i - 1);
            float angle = noise.GetNoise(prevNode.getPos().method_10263(), 0.0f, prevNode.getPos().method_10260());
            class_241 dAngle = RiverGenerator.get2DAngle(angle * 5.0f, 5.0f);
            class_2338 previousNodePos = prevNode.getPos();
            class_2382 vecAngle = new class_2382((double)dAngle.field_1343, 0.0, (double)dAngle.field_1342);
            class_2338 addedPos = previousNodePos.method_10081(vecAngle);
            class_5321 biomeRegistryKey = (class_5321)world.method_30349().method_30530(class_2378.field_25114).method_29113((Object)generator.method_12098().method_16359(addedPos.method_10263() >> 2, addedPos.method_10264() >> 2, addedPos.method_10260() >> 2)).get();
            int newY = generator.method_20402(addedPos.method_10263(), addedPos.method_10260(), class_2902.class_2903.field_13195);
            if (newY > previousNodePos.method_10264()) {
                newY = previousNodePos.method_10264();
            }
            if (newY < generator.method_16398() + 1) {
                newY = generator.method_16398() + 1;
            }
            if (isInvalid.test((nextNode = new Node(pos = new class_2338(addedPos.method_10263(), newY, addedPos.method_10260()), i)).getPos())) break;
            class_1923 key = new class_1923(nextNode.getPos());
            if (isValid.test(nextNode.getPos())) {
                nodes.add(nextNode);
                fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
                this.nodes = nodes;
                this.fastNodes = fastNodes;
                return;
            }
            nodes.add(nextNode);
            fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
        }
        this.nodes = null;
        this.fastNodes = null;
    }

    public boolean exists() {
        return this.nodes != null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Node> getNodesForChunk(class_1923 pos) {
        return this.fastNodes.get(pos);
    }

    public Set<class_1923> getNodeChunkPositions() {
        return this.fastNodes.keySet();
    }

    public class_2338 getFinalPosition() {
        return this.nodes.get(this.nodes.size() - 1).getPos();
    }

    public int getTotalNumberOfNodes() {
        return this.nodes.size();
    }

    public class_2338 getStartPos() {
        return this.nodes.get(0).getPos();
    }

    public static class_241 get2DAngle(float angle, float length) {
        float x = (float)(Math.sin(angle) * (double)length);
        float y = (float)(Math.cos(angle) * (double)length);
        return new class_241(x, y);
    }

    static class Node {
        private final int idx;
        private class_2338 pos;

        private Node(class_2338 pos, int idx) {
            this.pos = pos;
            this.idx = idx;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public void upgradeY(int y) {
            this.pos = new class_2338(this.pos.method_10263(), y, this.pos.method_10260());
        }

        public int getIdx() {
            return this.idx;
        }
    }
}

