/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.server.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import corgiaoc.byg.BYG;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_31;
import net.minecraft.class_3504;
import net.minecraft.class_3828;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5285;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class GenDataCommand {
    public static void dataGenCommand(CommandDispatcher<class_2168> dispatcher) {
        String commandString = "gendata";
        ArrayList modIdList = new ArrayList();
        FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
            String modId = modContainer.getMetadata().getId();
            modIdList.add(modId);
        });
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).then(class_2170.method_9244((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9264(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            GenDataCommand.createBiomeDatapack((String)cs.getArgument("modid", String.class), (CommandContext<class_2168>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).redirect((CommandNode)source));
    }

    public static void createBiomeDatapack(String modId, CommandContext<class_2168> commandSource) {
        ArrayList biomeList = new ArrayList();
        boolean stopSpamFlag = false;
        Path dataPackPath = GenDataCommand.dataPackPath(((class_2168)commandSource.getSource()).method_9225().method_8503().method_27050(class_5218.field_24186), modId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        class_5455 manager = ((class_2168)commandSource.getSource()).method_9225().method_30349();
        class_2385 biomeRegistry = manager.method_30530(class_2378.field_25114);
        class_2385 featuresRegistry = manager.method_30530(class_2378.field_25914);
        class_2385 structuresRegistry = manager.method_30530(class_2378.field_25915);
        class_2385 carverRegistry = manager.method_30530(class_2378.field_25913);
        class_2385 surfaceBuilderRegistry = manager.method_30530(class_2378.field_25912);
        class_2385 structureProcessorRegistry = manager.method_30530(class_2378.field_25916);
        Function dimensionGeneratorSettingsCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_5285.field_24826);
        DataResult jsonResult = (DataResult)dimensionGeneratorSettingsCodec.apply(((class_31)((class_2168)commandSource.getSource()).method_9225().method_8401()).method_28057());
        try {
            Path worldImportPath = GenDataCommand.worldImportJsonPath(dataPackPath.getParent(), "world_settings");
            Files.createDirectories(worldImportPath.getParent(), new FileAttribute[0]);
            Files.write(worldImportPath, gson.toJson((JsonElement)jsonResult.get().left().get()).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GenDataCommand.createJson(modId, dataPackPath, gson, surfaceBuilderRegistry, class_3504.field_25015);
        GenDataCommand.createJson(modId, dataPackPath, gson, featuresRegistry, class_2975.field_24833);
        GenDataCommand.createJson(modId, dataPackPath, gson, carverRegistry, class_2922.field_24828);
        GenDataCommand.createJson(modId, dataPackPath, gson, structuresRegistry, class_5312.field_24834);
        GenDataCommand.createJson(modId, dataPackPath, gson, structureProcessorRegistry, class_3828.field_25877);
        GenDataCommand.createBiomeJsonAndPackMcMeta(modId, commandSource, dataPackPath, gson, (class_2378<class_1959>)biomeRegistry, featuresRegistry, structuresRegistry, carverRegistry, surfaceBuilderRegistry);
    }

    private static void createBiomeJsonAndPackMcMeta(String modId, CommandContext<class_2168> commandSource, Path dataPackPath, Gson gson, class_2378<class_1959> biomeRegistry, class_2378<class_2975<?, ?>> featuresRegistry, class_2378<class_5312<?, ?>> structuresRegistry, class_2378<class_2922<?>> carverRegistry, class_2378<class_3504<?>> surfaceBuilderRegistry) {
        int hits = 0;
        int failedHits = 0;
        for (Map.Entry entry : biomeRegistry.method_29722()) {
            class_2960 key = ((class_5321)entry.getKey()).method_29177();
            class_1959 biome = (class_1959)entry.getValue();
            if (!key.toString().contains(modId)) continue;
            ++hits;
            Path biomeJsonPath = GenDataCommand.biomeJsonPath(dataPackPath, key, modId);
            Function biomeCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_1959.field_24677);
            try {
                Files.createDirectories(biomeJsonPath.getParent(), new FileAttribute[0]);
                Optional optional = ((DataResult)biomeCodec.apply(() -> biome)).result();
                if (optional.isPresent()) {
                    JsonElement root = (JsonElement)optional.get();
                    JsonArray features = new JsonArray();
                    for (List list : biome.method_30970().method_30983()) {
                        class_2893.class_2894[] stage = new JsonArray();
                        for (Supplier feature : list) {
                            featuresRegistry.method_29113(feature.get()).ifPresent(arg_0 -> GenDataCommand.lambda$createBiomeJsonAndPackMcMeta$4((JsonArray)stage, arg_0));
                        }
                        features.add((JsonElement)stage);
                    }
                    root.getAsJsonObject().add("features", (JsonElement)features);
                    String surfaceBuilder = ((class_5321)surfaceBuilderRegistry.method_29113(biome.method_30970().method_30984().get()).get()).method_29177().toString();
                    root.getAsJsonObject().addProperty("surface_builder", surfaceBuilder);
                    JsonObject carvers = new JsonObject();
                    for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                        JsonArray stage = new JsonArray();
                        for (Supplier carver : biome.method_30970().method_30976(step)) {
                            carverRegistry.method_29113(carver.get()).ifPresent(carverKey -> stage.add(carverKey.method_29177().toString()));
                        }
                        if (stage.size() <= 0) continue;
                        carvers.add(step.method_12581(), (JsonElement)stage);
                    }
                    root.getAsJsonObject().add("carvers", (JsonElement)carvers);
                    JsonArray starts = new JsonArray();
                    for (Supplier start : biome.method_30970().method_30975()) {
                        structuresRegistry.method_29113(start.get()).ifPresent(structureKey -> starts.add(structureKey.method_29177().toString()));
                    }
                    root.getAsJsonObject().add("starts", (JsonElement)starts);
                    Files.write(biomeJsonPath, gson.toJson(root).getBytes(), new OpenOption[0]);
                    continue;
                }
                ++failedHits;
                BYG.LOGGER.warn("No parsable element found for: " + key);
                ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.failed.parse", new Object[]{key}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))), false);
            }
            catch (IOException e) {
                ++failedHits;
                e.printStackTrace();
                ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.failed.ioexception", new Object[]{key, e.getMessage()}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), false);
            }
        }
        try {
            GenDataCommand.createPackMCMeta(dataPackPath, modId);
        }
        catch (IOException e) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)new class_2588("commands.gendata.mcmeta.failed", new Object[]{modId}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))));
        }
        class_5250 filePathText = new class_2585(dataPackPath.toString()).method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10958(new class_2558(class_2558.class_2559.field_11746, dataPackPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("commands.gendata.hovertext"))));
        class_5250 filePathText2 = new class_2585("https://github.com/CorgiTaco/BYG/issues/194").method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1079)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/CorgiTaco/BYG/issues/194")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("commands.gendata.hovertext.link"))));
        if (failedHits > 0) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)new class_2588("commands.gendata.failed.parse.recommend.new.world", new Object[]{filePathText2}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))));
        }
        if (hits > 0) {
            ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.success", new Object[]{commandSource.getArgument("modid", String.class), filePathText}), false);
        } else {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)new class_2588("commands.gendata.listisempty", new Object[]{modId}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))));
        }
    }

    private static <T> void createJson(String modId, Path dataPackPath, Gson gson, class_2378<T> registry, Codec<Supplier<T>> encoder) {
        for (Map.Entry entry : registry.method_29722()) {
            Optional optional;
            Function featureCodec = JsonOps.INSTANCE.withEncoder(encoder);
            Object object = entry.getValue();
            if (!((class_5321)entry.getKey()).method_29177().toString().contains(modId) || object == null || !Objects.requireNonNull(registry.method_10221(object)).toString().contains(modId) || !(optional = ((DataResult)featureCodec.apply(() -> object)).result()).isPresent()) continue;
            try {
                Path cfPath = GenDataCommand.createPath(dataPackPath, Objects.requireNonNull(registry.method_10221(object)), modId, registry.method_30517());
                Files.createDirectories(cfPath.getParent(), new FileAttribute[0]);
                Files.write(cfPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path worldImportJsonPath(Path path, String jsonName) {
        return path.resolve("import/" + jsonName + ".json");
    }

    private static <T> Path createPath(Path path, class_2960 identifier, String modId, class_5321<? extends class_2378<T>> registry) {
        return path.resolve("data/" + modId + "/" + registry.method_29177().toString().replace("minecraft:", "") + "/" + identifier.method_12832() + ".json");
    }

    private static Path biomeJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.method_12832() + ".json");
    }

    private static Path dataPackPath(Path path, String modId) {
        return path.resolve("gendata/" + modId + "-custom");
    }

    private static void createPackMCMeta(Path dataPackPath, String modID) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 6,\n\t\t\"description\": \"Custom biome datapack for " + modID + ".\"\n\t}\n}\n";
        Files.write(dataPackPath.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }

    private static /* synthetic */ void lambda$createBiomeJsonAndPackMcMeta$4(JsonArray stage, class_5321 featureKey) {
        stage.add(featureKey.method_29177().toString());
    }
}

