/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.api;

import java.util.HashMap;
import java.util.Map;
import me.lambdaurora.lambdynlights.LambDynLights;
import me.lambdaurora.lambdynlights.api.DynamicLightHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicLightHandlers {
    private static Map<class_1299<? extends class_1297>, DynamicLightHandler<? extends class_1297>> ENTITES_HANDLER = new HashMap<class_1299<? extends class_1297>, DynamicLightHandler<? extends class_1297>>();
    private static Map<class_2591<? extends class_2586>, DynamicLightHandler<? extends class_2586>> BLOCK_ENTITIES_HANDLER = new HashMap<class_2591<? extends class_2586>, DynamicLightHandler<? extends class_2586>>();

    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6099, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6046, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6091, (T entity) -> {
            int luminance = 0;
            if (entity.method_7027() != null) {
                luminance = entity.method_7027().method_26213();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6052, (T entity) -> LambDynLights.getLuminanceFromItemStack(entity.method_6983(), entity.method_5869()));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6043, (T entity) -> {
            class_1937 world = entity.method_5770();
            return LambDynLights.getLuminanceFromItemStack(entity.method_6940(), !world.method_8316(entity.method_24515()).method_15769());
        });
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6102, (T entity) -> (double)entity.field_7388 > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6135, (T entity) -> 8);
    }

    public static <T extends class_1297> void registerDynamicLightHandler(@NotNull class_1299<T> type, @NotNull DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = DynamicLightHandlers.getDynamicLightHandler(type);
        if (registeredHandler != null) {
            DynamicLightHandler<class_1297> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            ENTITES_HANDLER.put(type, newHandler);
        }
        ENTITES_HANDLER.put(type, handler);
    }

    public static <T extends class_2586> void registerDynamicLightHandler(@NotNull class_2591<T> type, @NotNull DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = DynamicLightHandlers.getDynamicLightHandler(type);
        if (registeredHandler != null) {
            DynamicLightHandler<class_2586> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            BLOCK_ENTITIES_HANDLER.put(type, newHandler);
        }
        BLOCK_ENTITIES_HANDLER.put(type, handler);
    }

    @Nullable
    public static <T extends class_1297> DynamicLightHandler<T> getDynamicLightHandler(@NotNull class_1299<T> type) {
        return ENTITES_HANDLER.get(type);
    }

    @Nullable
    public static <T extends class_2586> DynamicLightHandler<T> getDynamicLightHandler(@NotNull class_2591<T> type) {
        return BLOCK_ENTITIES_HANDLER.get(type);
    }

    public static <T extends class_1297> int getLuminanceFrom(@NotNull T entity) {
        if (!LambDynLights.get().config.hasEntitiesLightSource()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.method_5864());
        if (handler == null) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.method_5770().method_8316(new class_2338(entity.method_23317(), entity.method_23320(), entity.method_23321())).method_15769()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static <T extends class_2586> int getLuminanceFrom(@NotNull T entity) {
        if (!LambDynLights.get().config.hasBlockEntitiesLightSource()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.method_11017());
        if (handler == null) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && entity.method_10997() != null && !entity.method_10997().method_8316(entity.method_11016()).method_15769()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

