/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.DynamicStackHandler;

public class CurioStacksHandler
implements ICurioStacksHandler {
    private IDynamicStackHandler stackHandler;
    private IDynamicStackHandler cosmeticStackHandler;
    private int sizeShift;
    private boolean visible;
    private boolean cosmetic;
    private class_2371<Boolean> renderHandler;

    public CurioStacksHandler() {
        this(1, 0, true, false);
    }

    public CurioStacksHandler(int size, int shift, boolean visible, boolean cosmetic) {
        this.setSize(size + shift);
        this.sizeShift = shift;
        this.visible = visible;
        this.cosmetic = cosmetic;
    }

    public void setSize(int size) {
        this.stackHandler = new DynamicStackHandler(size);
        this.cosmeticStackHandler = new DynamicStackHandler(size);
        this.renderHandler = class_2371.method_10213((int)size, (Object)true);
        this.sizeShift = 0;
    }

    @Override
    public IDynamicStackHandler getStacks() {
        return this.stackHandler;
    }

    @Override
    public IDynamicStackHandler getCosmeticStacks() {
        return this.cosmeticStackHandler;
    }

    @Override
    public class_2371<Boolean> getRenders() {
        return this.renderHandler;
    }

    @Override
    public int getSlots() {
        return this.stackHandler.method_5439();
    }

    @Override
    public int getSizeShift() {
        return this.sizeShift;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    @Override
    public void grow(int amount) {
        this.validateSizeChange(amount);
        this.stackHandler.grow(amount);
        this.cosmeticStackHandler.grow(amount);
        class_2371 newList = class_2371.method_10213((int)(this.renderHandler.size() + amount), (Object)true);
        for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
            newList.set(i, this.renderHandler.get(i));
        }
        this.renderHandler = newList;
        this.sizeShift += amount;
    }

    @Override
    public void shrink(int amount) {
        this.validateSizeChange(amount);
        amount = Math.min(this.stackHandler.method_5439() - 1, amount);
        this.stackHandler.shrink(amount);
        this.cosmeticStackHandler.shrink(amount);
        class_2371 newList = class_2371.method_10213((int)(this.renderHandler.size() - amount), (Object)true);
        for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
            newList.set(i, this.renderHandler.get(i));
        }
        this.renderHandler = newList;
        this.sizeShift -= amount;
    }

    private void validateSizeChange(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative!");
        }
    }

    @Override
    public class_2487 serializeTag() {
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_10566("Stacks", (class_2520)this.stackHandler.serializeTag());
        compoundNBT.method_10566("Cosmetics", (class_2520)this.cosmeticStackHandler.serializeTag());
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            class_2487 tag = new class_2487();
            tag.method_10569("Slot", i);
            tag.method_10556("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Renders", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.renderHandler.size());
        compoundNBT.method_10566("Renders", (class_2520)nbt);
        compoundNBT.method_10569("SizeShift", this.sizeShift);
        compoundNBT.method_10556("HasCosmetic", this.cosmetic);
        compoundNBT.method_10556("Visible", this.visible);
        return compoundNBT;
    }

    @Override
    public void deserializeTag(class_2487 tag) {
        if (tag.method_10545("Stacks")) {
            this.stackHandler.deserializeTag(tag.method_10562("Stacks"));
        }
        if (tag.method_10545("Cosmetics")) {
            this.cosmeticStackHandler.deserializeTag(tag.method_10562("Cosmetics"));
        }
        if (tag.method_10545("Renders")) {
            class_2487 tag1 = tag.method_10562("Renders");
            this.renderHandler = class_2371.method_10213((int)(tag1.method_10573("Size", 3) ? tag1.method_10550("Size") : this.stackHandler.method_5439()), (Object)true);
            class_2499 tagList = tag1.method_10554("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 tags = tagList.method_10602(i);
                int slot = tags.method_10550("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.method_10577("Render"));
            }
        }
        if (tag.method_10545("SizeShift")) {
            this.sizeShift = tag.method_10550("SizeShift");
        }
        this.cosmetic = tag.method_10545("HasCosmetic") ? tag.method_10577("HasCosmetic") : this.cosmetic;
        this.visible = tag.method_10545("Visible") ? tag.method_10577("Visible") : this.visible;
    }
}

