/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory.screen;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1723;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.server.MinecraftServer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.component.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosCommon;
import top.theillusivec4.curios.common.CuriosNetwork;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.integration.OriginsIntegration;
import top.theillusivec4.curios.mixin.IScreenHandlerAccessor;

public class CuriosScreenHandler
extends class_1714 {
    private static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private final class_1715 craftingInput = new class_1715((class_1703)this, 2, 2);
    private final class_1731 craftingResult = new class_1731();
    private final class_1657 owner;
    private final ICuriosItemHandler curiosHandler;
    private final boolean onServer;
    private int lastScrollIndex;
    private boolean cosmeticColumn;

    public CuriosScreenHandler(int syncId, final class_1661 playerInventory) {
        super(syncId, playerInventory);
        int m;
        int n;
        this.field_7761.clear();
        this.owner = playerInventory.field_7546;
        this.onServer = !playerInventory.field_7546.field_6002.method_8608();
        this.method_7621((class_1735)new class_1734(playerInventory.field_7546, this.craftingInput, (class_1263)this.craftingResult, 0, 154, 28));
        for (n = 0; n < 2; ++n) {
            for (m = 0; m < 2; ++m) {
                this.method_7621(new class_1735((class_1263)this.craftingInput, m + n * 2, 98 + m * 18, 18 + n * 18));
            }
        }
        for (n = 0; n < 4; ++n) {
            final class_1304 equipmentSlot = EQUIPMENT_SLOT_ORDER[n];
            this.method_7621(new class_1735((class_1263)playerInventory, 39 - n, 8, 8 + n * 18){

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 stack) {
                    if (CuriosCommon.isOriginsLoaded && !OriginsIntegration.canEquip(stack, playerInventory.field_7546)) {
                        return false;
                    }
                    return equipmentSlot == class_1308.method_5953((class_1799)stack);
                }

                public boolean method_7674(class_1657 playerEntity) {
                    class_1799 itemStack = this.method_7677();
                    return (itemStack.method_7960() || playerEntity.method_7337() || !class_1890.method_8224((class_1799)itemStack)) && super.method_7674(playerEntity);
                }

                @Environment(value=EnvType.CLIENT)
                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.method_5927()]);
                }
            });
        }
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < 9; ++m) {
                this.method_7621(new class_1735((class_1263)playerInventory, m + (n + 1) * 9, 8 + m * 18, 84 + n * 18));
            }
        }
        for (n = 0; n < 9; ++n) {
            this.method_7621(new class_1735((class_1263)playerInventory, n, 8 + n * 18, 142));
        }
        this.method_7621(new class_1735((class_1263)playerInventory, 40, 77, 62){

            @Environment(value=EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
        this.curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)playerInventory.field_7546).orElse(null);
        this.getCuriosHandler().ifPresent(curios -> {
            Map<String, ICurioStacksHandler> curioMap = curios.getCurios();
            int slots = 0;
            int yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (int i = 0; i < stackHandler.method_5439() && slots < 8; ++slots, ++i) {
                    this.method_7621(new CurioSlot(this.owner, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                    if (stacksHandler.hasCosmetic()) {
                        IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                        this.cosmeticColumn = true;
                        this.method_7621(new CosmeticCurioSlot(this.owner, cosmeticHandler, i, identifier, -37, yOffset));
                    }
                    yOffset += 18;
                }
            }
        });
        this.scrollToIndex(0);
    }

    public boolean hasCosmeticColumn() {
        return this.cosmeticColumn;
    }

    public Optional<ICuriosItemHandler> getCuriosHandler() {
        return Optional.of(this.curiosHandler);
    }

    public void scrollToIndex(int indexIn) {
        this.getCuriosHandler().ifPresent(curios -> {
            Map<String, ICurioStacksHandler> curioMap = curios.getCurios();
            int slots = 0;
            int yOffset = 12;
            int index = 0;
            this.field_7761.subList(46, this.field_7761.size()).clear();
            class_2371<class_1799> stacks = ((IScreenHandlerAccessor)((Object)this)).getTrackedStacks();
            if (stacks != null) {
                stacks.subList(46, stacks.size()).clear();
            }
            for (String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (int i = 0; i < stackHandler.method_5439() && slots < 8; ++i) {
                    if (index >= indexIn) {
                        this.method_7621(new CurioSlot(this.owner, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                        if (stacksHandler.hasCosmetic()) {
                            IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                            this.cosmeticColumn = true;
                            this.method_7621(new CosmeticCurioSlot(this.owner, cosmeticHandler, i, identifier, -37, yOffset));
                        }
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            if (!this.owner.field_6002.method_8608()) {
                class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
                packetByteBuf.writeInt(this.field_7763);
                packetByteBuf.writeInt(indexIn);
                ServerSidePacketRegistry.INSTANCE.sendToPlayer(this.owner, CuriosNetwork.SCROLL, packetByteBuf);
            }
            this.lastScrollIndex = indexIn;
        });
    }

    public void scrollToPosition(float pos) {
        this.getCuriosHandler().ifPresent(curios -> {
            int k = curios.getVisibleSlots() - 8;
            int j = (int)((double)(pos * (float)k) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (j == this.lastScrollIndex) {
                return;
            }
            if (!this.onServer) {
                class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
                packetByteBuf.writeInt(this.field_7763);
                packetByteBuf.writeInt(j);
                ClientSidePacketRegistry.INSTANCE.sendToServer(CuriosNetwork.SCROLL, packetByteBuf);
            }
        });
    }

    public boolean canScroll() {
        return this.getCuriosHandler().map(curios -> curios.getVisibleSlots() > 8).orElse(false);
    }

    public class_3917<?> method_17358() {
        return CuriosRegistry.CURIOS_SCREENHANDLER;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7654(class_1662 finder) {
        this.craftingInput.method_7683(finder);
    }

    public void method_7657() {
        this.craftingResult.method_5448();
        this.craftingInput.method_5448();
    }

    public void method_7609(class_1263 inventory) {
        if (!this.owner.field_6002.field_9236) {
            class_3222 serverPlayerEntity = (class_3222)this.owner;
            class_1799 itemStack = class_1799.field_8037;
            MinecraftServer server = this.owner.field_6002.method_8503();
            if (server != null) {
                class_3955 craftingRecipe;
                Optional optional = this.owner.field_6002.method_8503().method_3772().method_8132(class_3956.field_17545, (class_1263)this.craftingInput, this.owner.field_6002);
                if (optional.isPresent() && this.craftingResult.method_7665(this.owner.field_6002, serverPlayerEntity, (class_1860)(craftingRecipe = (class_3955)optional.get()))) {
                    itemStack = craftingRecipe.method_8116((class_1263)this.craftingInput);
                }
                this.craftingResult.method_5447(0, itemStack);
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 0, itemStack));
            }
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.craftingResult.method_5448();
        if (!player.field_6002.field_9236) {
            this.method_7607(player, player.field_6002, (class_1263)this.craftingInput);
        }
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            int i;
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            class_1304 entityequipmentslot = class_1308.method_5953((class_1799)itemstack);
            if (index == 0) {
                if (!this.method_7616(itemstack1, 9, 45, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (index < 5 ? !this.method_7616(itemstack1, 9, 45, false) : (index < 9 ? !this.method_7616(itemstack1, 9, 45, false) : (entityequipmentslot.method_5925() == class_1304.class_1305.field_6178 && !((class_1735)this.field_7761.get(8 - entityequipmentslot.method_5927())).method_7681() ? !this.method_7616(itemstack1, i = 8 - entityequipmentslot.method_5927(), i + 1, false) : (index < 46 && !CuriosApi.getCuriosHelper().getCurioTags(itemstack.method_7909()).isEmpty() ? !this.method_7616(itemstack1, 46, this.field_7761.size(), false) : (entityequipmentslot == class_1304.field_6171 && !((class_1735)this.field_7761.get(45)).method_7681() ? !this.method_7616(itemstack1, 45, 46, false) : (index < 36 ? !this.method_7616(itemstack1, 36, 45, false) : (index < 45 ? !this.method_7616(itemstack1, 9, 36, false) : !this.method_7616(itemstack1, 9, 45, false)))))))) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            class_1799 itemstack2 = slot.method_7667(playerIn, itemstack1);
            if (index == 0) {
                playerIn.method_7328(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean method_7652(class_1860<? super class_1715> recipe) {
        return recipe.method_8115((class_1263)this.craftingInput, this.owner.field_6002);
    }

    public int method_7655() {
        return 0;
    }

    public int method_7653() {
        return this.craftingInput.method_17398();
    }

    public int method_7656() {
        return this.craftingInput.method_17397();
    }

    @Environment(value=EnvType.CLIENT)
    public int method_7658() {
        return 5;
    }
}

