/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.mixin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_3545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeCallback;
import top.theillusivec4.curios.api.event.CurioDropsCallback;
import top.theillusivec4.curios.api.event.DropRulesCallback;
import top.theillusivec4.curios.api.type.component.ICurio;
import top.theillusivec4.curios.api.type.component.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Shadow
    int field_6238;

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    protected void drop(class_1282 source, CallbackInfo cb) {
        class_1309 livingEntity = (class_1309)this;
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
            class_1309 wearer = handler.getWearer();
            class_1297 entity = source.method_5529();
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            int looting = entity instanceof class_1309 ? class_1890.method_8226((class_1309)((class_1309)entity)) : 0;
            boolean recentlyHit = this.field_6238 > 0;
            ArrayList<class_3545<Predicate<class_1799>, ICurio.DropRule>> overrides = new ArrayList<class_3545<Predicate<class_1799>, ICurio.DropRule>>();
            ((DropRulesCallback)DropRulesCallback.EVENT.invoker()).dropRules(wearer, (ICuriosItemHandler)handler, source, looting, recentlyHit, (List<class_3545<Predicate<class_1799>, ICurio.DropRule>>)overrides);
            boolean keepInventory = wearer.field_6002.method_8450().method_8355(class_1928.field_19389);
            handler.getCurios().forEach((id, stacksHandler) -> {
                LivingEntityMixin.handleDrops(wearer, overrides, stacksHandler.getStacks(), drops, keepInventory);
                LivingEntityMixin.handleDrops(wearer, overrides, stacksHandler.getCosmeticStacks(), drops, keepInventory);
            });
            if (((CurioDropsCallback)CurioDropsCallback.EVENT.invoker()).drop(livingEntity, (ICuriosItemHandler)handler, source, (Collection<class_1799>)drops, looting, recentlyHit)) {
                if (wearer instanceof class_1657) {
                    drops.forEach(stack -> ((class_1657)wearer).method_7329(stack, true, false));
                } else {
                    drops.forEach(arg_0 -> ((class_1309)livingEntity).method_5775(arg_0));
                }
            }
        });
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo cb) {
        class_1309 livingEntity = (class_1309)this;
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
            handler.handleInvalidStacks();
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                ICurioStacksHandler stacksHandler = entry.getValue();
                String identifier = entry.getKey();
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.method_5439(); ++i) {
                    class_1799 prevCosmeticStack;
                    class_1799 cosmeticStack;
                    class_1799 stack = stackHandler.method_5438(i);
                    Optional<ICurio> currentCurio = CuriosApi.getCuriosHelper().getCurio(stack);
                    int index = i;
                    if (!stack.method_7960()) {
                        stack.method_7917(livingEntity.field_6002, (class_1297)livingEntity, -1, false);
                        currentCurio.ifPresent(curio -> {
                            curio.curioTick(identifier, index, livingEntity);
                            if (livingEntity.field_6002.method_8608()) {
                                curio.curioAnimate(identifier, index, livingEntity);
                            }
                        });
                    }
                    if (livingEntity.field_6002.method_8608()) continue;
                    class_1799 prevStack = stackHandler.getPreviousStack(i);
                    boolean sync = false;
                    if (!class_1799.method_7973((class_1799)stack, (class_1799)prevStack)) {
                        Optional<ICurio> prevCurio = CuriosApi.getCuriosHelper().getCurio(prevStack);
                        sync = true;
                        ((CurioChangeCallback)CurioChangeCallback.EVENT.invoker()).change(livingEntity, identifier, i, prevStack, stack);
                        if (!prevStack.method_7960()) {
                            livingEntity.method_6127().method_26847(CuriosApi.getCuriosHelper().getAttributeModifiers(identifier, prevStack));
                            prevCurio.ifPresent(curio -> curio.onUnequip(identifier, index, livingEntity));
                        }
                        if (!stack.method_7960()) {
                            livingEntity.method_6127().method_26854(CuriosApi.getCuriosHelper().getAttributeModifiers(identifier, stack));
                            currentCurio.ifPresent(curio -> curio.onEquip(identifier, index, livingEntity));
                        }
                        stackHandler.setPreviousStack(i, stack.method_7960() ? class_1799.field_8037 : stack.method_7972());
                    }
                    if (!class_1799.method_7973((class_1799)(cosmeticStack = cosmeticStackHandler.method_5438(i)), (class_1799)(prevCosmeticStack = cosmeticStackHandler.getPreviousStack(i)))) {
                        sync = true;
                        cosmeticStackHandler.setPreviousStack(index, cosmeticStack.method_7960() ? class_1799.field_8037 : cosmeticStack.method_7972());
                    }
                    if (!sync) continue;
                    handler.sync();
                }
            }
        });
    }

    private static void handleDrops(class_1309 livingEntity, List<class_3545<Predicate<class_1799>, ICurio.DropRule>> dropRules, IDynamicStackHandler stacks, Collection<class_1799> drops, boolean keepInventory) {
        for (int i = 0; i < stacks.method_5439(); ++i) {
            ICurio.DropRule dropRule;
            class_1799 stack = stacks.method_5438(i);
            if (stack.method_7960()) continue;
            ICurio.DropRule dropRuleOverride = null;
            for (class_3545<Predicate<class_1799>, ICurio.DropRule> override : dropRules) {
                if (!((Predicate)override.method_15442()).test(stack)) continue;
                dropRuleOverride = (ICurio.DropRule)((Object)override.method_15441());
            }
            ICurio.DropRule dropRule2 = dropRule = dropRuleOverride != null ? dropRuleOverride : CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.getDropRule(livingEntity)).orElse(ICurio.DropRule.DEFAULT);
            if (dropRule == ICurio.DropRule.DEFAULT && keepInventory || dropRule == ICurio.DropRule.ALWAYS_KEEP) continue;
            if (!class_1890.method_8221((class_1799)stack) && dropRule != ICurio.DropRule.DESTROY) {
                drops.add(stack);
            }
            stacks.method_5447(i, class_1799.field_8037);
        }
    }
}

