/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1317;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1545;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class BlazeGuardianEntity
extends class_1588 {
    private float eyeOffset = 0.5f;
    private int eyeOffsetCooldown;
    private static final class_2940<Byte> GUARDIAN_FLAGS = class_2945.method_12791(BlazeGuardianEntity.class, (class_2941)class_2943.field_13319);
    private boolean isTryingToShockwave = false;

    public BlazeGuardianEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, 8.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createBlazeGuardianAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_23719, 0.24).method_26868(class_5134.field_23717, 52.0).method_26868(class_5134.field_23724, 2.0);
    }

    public void method_5959() {
        this.field_6201.method_6277(3, (class_1352)new ShockWaveGoal(this));
        this.field_6201.method_6277(4, (class_1352)new ShootFireballGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{class_1545.class}));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GUARDIAN_FLAGS, (Object)0);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14991;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14842;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14580;
    }

    public float method_5718() {
        return 1.0f;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public void method_6007() {
        if (!this.field_5952 && this.method_18798().field_1351 < 0.0) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (this.field_6002.field_9236) {
            if (this.field_5974.nextInt(24) == 0 && !this.method_5701()) {
                this.field_6002.method_8486(this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5, class_3417.field_14734, this.method_5634(), 1.0f + this.field_5974.nextFloat(), this.field_5974.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11237, this.method_23322(0.6), this.method_23319(), this.method_23325(0.6), 0.0, 0.0, 0.0);
            }
        }
        super.method_6007();
    }

    public boolean method_29503() {
        return true;
    }

    public void method_5958() {
        class_1309 livingEntity;
        --this.eyeOffsetCooldown;
        if (this.eyeOffsetCooldown <= 0) {
            this.eyeOffsetCooldown = 100;
            this.eyeOffset = 0.5f + (float)this.field_5974.nextGaussian() * 3.0f;
        }
        if ((livingEntity = this.method_5968()) != null && livingEntity.method_23320() > this.method_23320() + (double)this.eyeOffset && this.method_18395(livingEntity) && !this.isTryingToShockwave) {
            class_243 vec3d = this.method_18798();
            this.method_18799(this.method_18798().method_1031(0.0, ((double)0.3f - vec3d.field_1351) * (double)0.3f, 0.0));
            this.field_6007 = true;
        }
        super.method_5958();
    }

    public boolean method_5809() {
        return this.isFireActive();
    }

    private boolean isFireActive() {
        return ((Byte)this.field_6011.method_12789(GUARDIAN_FLAGS) & 1) != 0;
    }

    private void setFireActive(boolean fireActive) {
        byte b = (Byte)this.field_6011.method_12789(GUARDIAN_FLAGS);
        b = fireActive ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_6011.method_12778(GUARDIAN_FLAGS, (Object)b);
    }

    public boolean method_5643(class_1282 source, float amount) {
        int chance = 0;
        chance = source.method_5533() ? this.field_6002.field_9229.nextInt(3) : (!source.method_5504() && this.method_6032() < this.method_6063() / 2.0f ? this.field_6002.field_9229.nextInt(4) : this.field_6002.field_9229.nextInt(6));
        if (chance == 1) {
            this.field_6002.method_8449(null, (class_1297)this, class_3417.field_15150, class_3419.field_15251, 1.0f, 1.0f);
            return false;
        }
        return this.method_5679(source) ? false : super.method_5643(source, amount);
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (spawnReason.equals((Object)class_3730.field_16459) || spawnReason.equals((Object)class_3730.field_16474) || spawnReason.equals((Object)class_3730.field_16472)) {
            block0: for (int i = 0; i < serverWorldAccess.method_8409().nextInt(3) + 2; ++i) {
                for (int u = 0; u < 10; ++u) {
                    class_2338 pos = new class_2338((class_2382)this.method_24515().method_10069(this.field_6002.field_9229.nextInt(5), this.field_6002.field_9229.nextInt(5), this.field_6002.field_9229.nextInt(5)));
                    if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)this.field_6002, (class_2338)pos, (class_1299)class_1299.field_6099)) continue;
                    class_1545 blazeEntity = (class_1545)class_1299.field_6099.method_5883((class_1937)serverWorldAccess.method_8410());
                    blazeEntity.method_5725(pos, this.field_6002.field_9229.nextFloat() * 360.0f, 0.0f);
                    blazeEntity.method_5943(serverWorldAccess, this.field_6002.method_8404(pos), class_3730.field_16459, null, null);
                    serverWorldAccess.method_8649((class_1297)blazeEntity);
                    continue block0;
                }
            }
        }
        return super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
    }

    public static boolean canSpawn(class_1299<BlazeGuardianEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        boolean bl;
        Optional optional = world.method_31081(pos);
        boolean bl2 = bl = world.method_8407() != class_1267.field_5801 && world.method_8314(class_1944.field_9282, pos) < 10 && BlazeGuardianEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random) || spawnReason == class_3730.field_16469;
        if (Objects.equals(optional, Optional.of(class_1972.field_9461))) {
            return bl;
        }
        return false;
    }

    static class ShockWaveGoal
    extends class_1352 {
        private final BlazeGuardianEntity guardian;
        private int explosionTicker;

        public ShockWaveGoal(BlazeGuardianEntity guardian) {
            this.guardian = guardian;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.guardian.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.guardian.method_18395(livingEntity) && this.guardian.method_5858((class_1297)livingEntity) < 8.0;
        }

        public void method_6269() {
            this.explosionTicker = 20;
            this.guardian.setFireActive(true);
            this.guardian.isTryingToShockwave = true;
        }

        public void method_6270() {
            this.guardian.setFireActive(false);
            this.explosionTicker = 0;
            this.guardian.isTryingToShockwave = false;
        }

        public void method_6268() {
            --this.explosionTicker;
            class_1309 livingEntity = this.guardian.method_5968();
            if (livingEntity != null) {
                if (!this.guardian.field_6002.field_9236) {
                    for (int o = 0; o < 3; ++o) {
                        this.guardian.field_6002.method_8406((class_2394)class_2398.field_11239, this.guardian.method_23322(0.7), this.guardian.method_23319(), this.guardian.method_23325(0.7), 0.0, 0.0, 0.0);
                        ((class_3218)this.guardian.field_6002).method_14199((class_2394)class_2398.field_11239, this.guardian.method_23322(0.7), this.guardian.method_23319(), this.guardian.method_23325(0.7), 0, 0.0, 0.0, 0.0, 0.01);
                    }
                    if (!this.guardian.field_6002.field_9236 && this.explosionTicker == 1) {
                        this.guardian.field_6002.method_8537((class_1297)this.guardian, this.guardian.method_23317(), this.guardian.method_23318(), this.guardian.method_23321(), 6.0f, true, class_1927.class_4179.field_18685);
                    }
                }
                super.method_6268();
            }
        }
    }

    static class ShootFireballGoal
    extends class_1352 {
        private final BlazeGuardianEntity guardian;
        private int fireballsFired;
        private int fireballCooldown;
        private int targetNotVisibleTicks;

        public ShootFireballGoal(BlazeGuardianEntity guardian) {
            this.guardian = guardian;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.guardian.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.guardian.method_18395(livingEntity);
        }

        public void method_6269() {
            this.fireballsFired = 0;
        }

        public void method_6270() {
            this.guardian.setFireActive(false);
            this.targetNotVisibleTicks = 0;
        }

        public void method_6268() {
            --this.fireballCooldown;
            class_1309 livingEntity = this.guardian.method_5968();
            if (livingEntity != null) {
                boolean bl = this.guardian.method_5985().method_6369((class_1297)livingEntity);
                this.targetNotVisibleTicks = bl ? 0 : ++this.targetNotVisibleTicks;
                double d = this.guardian.method_5858((class_1297)livingEntity);
                if (d < 4.0) {
                    if (!bl) {
                        return;
                    }
                    if (this.fireballCooldown <= 0) {
                        this.fireballCooldown = 20;
                        this.guardian.method_6121((class_1297)livingEntity);
                    }
                    this.guardian.method_5962().method_6239(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), 1.0);
                } else if (d < this.getFollowRange() * this.getFollowRange() && bl) {
                    double e = livingEntity.method_23317() - this.guardian.method_23317();
                    double f = livingEntity.method_23323(0.5) - this.guardian.method_23323(0.5);
                    double g = livingEntity.method_23321() - this.guardian.method_23321();
                    if (this.fireballCooldown <= 0) {
                        ++this.fireballsFired;
                        if (this.fireballsFired == 1) {
                            this.fireballCooldown = 60;
                            this.guardian.setFireActive(true);
                        } else if (this.fireballsFired <= 6) {
                            this.fireballCooldown = 6;
                        } else {
                            this.fireballCooldown = 100;
                            this.fireballsFired = 0;
                            this.guardian.setFireActive(false);
                        }
                        if (this.fireballsFired > 1) {
                            float h = class_3532.method_15355((float)class_3532.method_15368((double)d)) * 0.7f;
                            if (!this.guardian.method_5701()) {
                                this.guardian.field_6002.method_8444((class_1657)null, 1018, this.guardian.method_24515(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                class_1677 smallFireballEntity = new class_1677(this.guardian.field_6002, (class_1309)this.guardian, e + this.guardian.method_6051().nextGaussian() * (double)h, f, g + this.guardian.method_6051().nextGaussian() * (double)h);
                                smallFireballEntity.method_5814(smallFireballEntity.method_23317(), this.guardian.method_23323(0.5) + 0.5, smallFireballEntity.method_23321());
                                this.guardian.field_6002.method_8649((class_1297)smallFireballEntity);
                            }
                        }
                    }
                    this.guardian.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.guardian.method_5962().method_6239(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.guardian.method_26825(class_5134.field_23717);
        }
    }
}

