/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wraith.waystones.Config;
import wraith.waystones.PlayerEntityMixinAccess;
import wraith.waystones.Utils;
import wraith.waystones.WaystoneStorage;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.registries.BlockEntityRegistry;
import wraith.waystones.registries.BlockRegistry;
import wraith.waystones.registries.CustomScreenHandlerRegistry;
import wraith.waystones.registries.ItemRegistry;

public class Waystones
implements ModInitializer {
    public static final String MOD_ID = "waystones";
    public static WaystoneStorage WAYSTONE_STORAGE;
    public static final Logger LOGGER;

    public void onInitialize() {
        LogManager.getLogger().info("[Fabric-Waystones] is initializing.");
        Config.getInstance().loadConfig();
        BlockRegistry.registerBlocks();
        BlockEntityRegistry.registerBlockEntities();
        ItemRegistry.registerItems();
        CustomScreenHandlerRegistry.registerScreenHandlers();
        this.registerEvents();
        this.registerPacketHandlers();
        LogManager.getLogger().info("[Fabric-Waystones] has successfully been initialized.");
        LogManager.getLogger().info("[Fabric-Waystones] If you have any issues or questions, feel free to join our Discord: https://discord.gg/vMjzgS4.");
    }

    private void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("remove_waystone_owner"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && WAYSTONE_STORAGE.getWaystone(hash).getOwner().equals(owner) || player.method_5687(2))) {
                    WAYSTONE_STORAGE.setOwner(hash, null);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("waystone_gui_slot_click"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("sync_id") || !tag.method_10545("clicked_slot")) {
                    return;
                }
                int syncId = tag.method_10550("sync_id");
                int button = tag.method_10550("clicked_slot");
                if (player.field_7512.field_7763 == syncId) {
                    player.field_7512.method_7604((class_1657)player, button);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("rename_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (!(tag != null && tag.method_10545("waystone_name") && tag.method_10545("waystone_hash") && tag.method_10545("waystone_owner"))) {
                return;
            }
            String name = tag.method_10558("waystone_name");
            String hash = tag.method_10558("waystone_hash");
            UUID owner = tag.method_25926("waystone_owner");
            server.execute(() -> {
                if (WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && WAYSTONE_STORAGE.getWaystone(hash).getOwner().equals(owner) || player.method_5687(2))) {
                    WAYSTONE_STORAGE.renameWaystone(hash, name);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("forget_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            String hash = tag.method_10558("waystone_hash");
            server.execute(() -> {
                WaystoneBlockEntity waystone = WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null || waystone.isGlobal()) {
                    return;
                }
                ((PlayerEntityMixinAccess)player).forgetWaystone(hash);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("request_player_waystone_update"), (server, player, networkHandler, data, sender) -> server.execute(((PlayerEntityMixinAccess)player)::syncData));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("toggle_global_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                return;
            }
            server.execute(() -> {
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && WAYSTONE_STORAGE.getWaystone(hash).getOwner().equals(owner) || player.method_5687(2))) {
                    WAYSTONE_STORAGE.toggleGlobal(hash);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("sync_player_from_client"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> ((PlayerEntityMixinAccess)player).fromTagW(tag));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("teleport_to_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            server.execute(() -> {
                if (!tag.method_10545("waystone_hash")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                boolean isAbyssWatcher = tag.method_10545("from_abyss_watcher") && tag.method_10577("from_abyss_watcher");
                WaystoneBlockEntity waystone = WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null) {
                    return;
                }
                if (waystone.method_10997() != null && waystone.method_10997().method_8320(waystone.method_11016()).method_26204() != BlockRegistry.WAYSTONE) {
                    WAYSTONE_STORAGE.removeWaystone(hash);
                    waystone.method_10997().method_8544(waystone.method_11016());
                } else if (Utils.canTeleport((class_1657)player, hash)) {
                    class_2338 waystonePos;
                    class_2338 playerPos = player.method_24515();
                    waystone.teleportPlayer((class_1657)player, isAbyssWatcher);
                    player.field_6002.method_8396((class_1657)player, playerPos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
                    if (isAbyssWatcher) {
                        player.field_6002.method_8396((class_1657)player, playerPos, class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    if (!(waystonePos = waystone.method_11016()).method_19771((class_2382)playerPos, 6.0)) {
                        player.field_6002.method_8396((class_1657)player, waystonePos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            });
        });
    }

    public void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            WAYSTONE_STORAGE = new WaystoneStorage(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            WAYSTONE_STORAGE.loadOrSaveWaystones(true);
            WAYSTONE_STORAGE = null;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10794(Config.getInstance().toCompoundTag());
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)Utils.ID("waystone_config_update"), (class_2540)data);
            WAYSTONE_STORAGE.sendToPlayer(handler.field_14140);
            WAYSTONE_STORAGE.sendCompatData(handler.field_14140);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> ((PlayerEntityMixinAccess)newPlayer).syncData());
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(1))).executes(context -> {
            Config.getInstance().loadConfig();
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10794(Config.getInstance().toCompoundTag());
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)Utils.ID("waystone_config_update"), (class_2540)data);
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                player.method_7353((class_2561)new class_2585("\u00a76[\u00a7eWaystones\u00a76] \u00a73has successfully reloaded!"), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"display").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            Config.getInstance().print(player);
            return 1;
        }))));
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

