/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.block;

import java.util.HashSet;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import wraith.waystones.Config;
import wraith.waystones.PlayerEntityMixinAccess;
import wraith.waystones.Waystones;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.item.LocalVoid;
import wraith.waystones.item.WaystoneScroll;
import wraith.waystones.registries.BlockRegistry;
import wraith.waystones.registries.ItemRegistry;

public class WaystoneBlock
extends class_2237 {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2753 FACING = class_2383.field_11177;
    protected static final class_265 VOXEL_SHAPE_TOP;
    protected static final class_265 VOXEL_SHAPE_BOTTOM;

    public WaystoneBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public class_2586 method_10123(class_1922 world) {
        return new WaystoneBlockEntity();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{HALF, FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        if (blockPos.method_10264() < 255 && ctx.method_8045().method_8320(blockPos.method_10084()).method_26166(ctx)) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(HALF, (Comparable)class_2756.field_12607);
        }
        return null;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            return VOXEL_SHAPE_BOTTOM;
        }
        return VOXEL_SHAPE_TOP;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 botPos;
        class_2338 topPos;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            topPos = pos;
            botPos = pos.method_10074();
        } else {
            topPos = pos.method_10084();
            botPos = pos;
        }
        class_2586 entity = world.method_8321(botPos);
        if (entity instanceof WaystoneBlockEntity) {
            if (!player.method_7337() && player.method_7305(world.method_8320(botPos)) && world instanceof class_3218) {
                WaystoneBlockEntity waystoneBlockEntity = (WaystoneBlockEntity)entity;
                if (!world.field_9236) {
                    class_1799 itemStack = new class_1799((class_1935)ItemRegistry.ITEMS.get("waystone"));
                    class_2487 compoundTag = waystoneBlockEntity.method_11007(new class_2487());
                    if (!compoundTag.isEmpty()) {
                        itemStack.method_7959("BlockEntityTag", (class_2520)compoundTag);
                    }
                    class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                    itemEntity.method_6988();
                    world.method_8649((class_1297)itemEntity);
                } else {
                    waystoneBlockEntity.method_11289(player);
                }
            }
            if (Waystones.WAYSTONE_STORAGE != null) {
                Waystones.WAYSTONE_STORAGE.removeWaystone((WaystoneBlockEntity)entity);
            }
            world.method_8544(botPos);
        }
        entity = world.method_8321(topPos);
        if (Waystones.WAYSTONE_STORAGE != null && entity instanceof WaystoneBlockEntity) {
            Waystones.WAYSTONE_STORAGE.removeWaystone((WaystoneBlockEntity)entity);
            world.method_8544(topPos);
        }
        world.method_8650(topPos, false);
        world.method_8408(topPos, class_2246.field_10124);
        super.method_9576(world, pos, state, player);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8501(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609));
        class_2586 entity = world.method_8321(pos);
        if (placer instanceof class_3222 && entity instanceof WaystoneBlockEntity) {
            ((WaystoneBlockEntity)entity).setOwner((class_1657)placer);
            if (Waystones.WAYSTONE_STORAGE != null) {
                Waystones.WAYSTONE_STORAGE.addWaystone((WaystoneBlockEntity)entity);
            }
        }
    }

    public static WaystoneBlockEntity getEntity(class_1937 world, class_2338 pos) {
        class_2586 entity;
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() != BlockRegistry.WAYSTONE) {
            return null;
        }
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
        }
        if ((entity = world.method_8321(pos)) instanceof WaystoneBlockEntity) {
            return (WaystoneBlockEntity)entity;
        }
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            WaystoneBlockEntity blockEntity;
            HashSet<String> discovered = ((PlayerEntityMixinAccess)player).getDiscoveredWaystones();
            if (player.method_6047().method_7909() instanceof WaystoneScroll || player.method_6047().method_7909() instanceof LocalVoid) {
                return class_1269.field_5811;
            }
            class_2338 openPos = pos;
            if (state.method_11654(HALF) == class_2756.field_12609) {
                openPos = pos.method_10074();
            }
            if ((blockEntity = (WaystoneBlockEntity)world.method_8321(openPos)) == null) {
                return class_1269.field_5814;
            }
            if (player.method_5715() && player.method_5687(2) || Config.getInstance().canOwnersRedeemPayments() && blockEntity.getOwner().equals(player.method_5667())) {
                if (blockEntity.hasStorage()) {
                    class_1264.method_17349((class_1937)world, (class_2338)openPos.method_10086(2), blockEntity.getInventory());
                    blockEntity.setInventory((class_2371<class_1799>)class_2371.method_10213((int)0, (Object)class_1799.field_8037));
                }
            } else {
                class_3908 screenHandlerFactory;
                if (blockEntity.getOwner() == null) {
                    blockEntity.setOwner(player);
                }
                if (!Waystones.WAYSTONE_STORAGE.containsHash(blockEntity.getHash())) {
                    Waystones.WAYSTONE_STORAGE.addWaystone(blockEntity);
                }
                if (!discovered.contains(blockEntity.getHash())) {
                    if (!blockEntity.isGlobal()) {
                        player.method_7353((class_2561)new class_2585(blockEntity.getWaystoneName() + " ").method_10852((class_2561)new class_2588("waystones.discover_waystone")).method_27692(class_124.field_1075), false);
                    }
                    ((PlayerEntityMixinAccess)player).discoverWaystone(blockEntity);
                }
                if ((screenHandlerFactory = state.method_26196(world, openPos)) != null) {
                    player.method_17355(screenHandlerFactory);
                }
            }
            blockEntity.method_5431();
        }
        return class_1269.method_29236((boolean)world.method_8608());
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2756 facing;
        class_2338 newPos;
        world.method_8544(pos);
        if (state.method_26204() != this) {
            super.method_9536(state, world, pos, newState, moved);
            return;
        }
        if (state.method_11654(HALF) == class_2756.field_12609) {
            newPos = pos.method_10074();
            facing = class_2756.field_12607;
        } else {
            newPos = pos.method_10084();
            facing = class_2756.field_12609;
        }
        if (newState.method_26215()) {
            world.method_8501(newPos, newState);
            world.method_8544(newPos);
        }
        if (newState.method_26204() != BlockRegistry.WAYSTONE) {
            class_2586 entity;
            class_2338 testPos = pos;
            if (state.method_11654(HALF) == class_2756.field_12609) {
                testPos = pos.method_10074();
            }
            if ((entity = world.method_8321(testPos)) instanceof WaystoneBlockEntity) {
                Waystones.WAYSTONE_STORAGE.removeWaystone(((WaystoneBlockEntity)entity).getHash());
            }
        } else {
            world.method_8501(newPos, (class_2680)newState.method_11657(HALF, (Comparable)facing));
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public static String getDimensionName(class_1937 world) {
        return world.method_27983().method_29177().toString();
    }

    static {
        class_265 vs1_1 = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        class_265 vs2_1 = class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
        class_265 vs3_1 = class_2248.method_9541((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        class_265 vs1_2 = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
        class_265 vs2_2 = class_2248.method_9541((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
        class_265 vs3_2 = class_2248.method_9541((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
        class_265 vs4_2 = class_2248.method_9541((double)7.0, (double)5.0, (double)1.0, (double)9.0, (double)8.0, (double)3.0);
        class_265 vs5_2 = class_2248.method_9541((double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)10.0, (double)4.0);
        class_265 vs6_2 = class_2248.method_9541((double)1.0, (double)5.0, (double)7.0, (double)3.0, (double)8.0, (double)9.0);
        class_265 vs7_2 = class_2248.method_9541((double)3.0, (double)7.0, (double)7.0, (double)4.0, (double)10.0, (double)9.0);
        class_265 vs8_2 = class_2248.method_9541((double)7.0, (double)5.0, (double)13.0, (double)9.0, (double)8.0, (double)15.0);
        class_265 vs9_2 = class_2248.method_9541((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)10.0, (double)13.0);
        class_265 vs10_2 = class_2248.method_9541((double)13.0, (double)5.0, (double)7.0, (double)15.0, (double)8.0, (double)9.0);
        class_265 vs11_2 = class_2248.method_9541((double)12.0, (double)7.0, (double)7.0, (double)13.0, (double)10.0, (double)9.0);
        VOXEL_SHAPE_TOP = class_259.method_17786((class_265)vs1_2, (class_265[])new class_265[]{vs2_2, vs3_2, vs4_2, vs5_2, vs6_2, vs7_2, vs8_2, vs9_2, vs10_2, vs11_2}).method_1097();
        VOXEL_SHAPE_BOTTOM = class_259.method_17786((class_265)vs1_1, (class_265[])new class_265[]{vs2_1, vs3_1}).method_1097();
    }
}

