/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.screens;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Comparator;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2645;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import wraith.waystones.ClientStuff;
import wraith.waystones.PlayerAccess;
import wraith.waystones.PlayerEntityMixinAccess;
import wraith.waystones.Utils;
import wraith.waystones.WaystonesClient;
import wraith.waystones.mixin.ClientPlayerEntityAccessor;
import wraith.waystones.mixin.ServerPlayerEntityAccessor;

public abstract class UniversalWaystoneScreenHandler
extends class_1703 {
    protected final class_1657 player;
    protected ArrayList<String> sortedWaystones = new ArrayList();
    protected ArrayList<String> filteredWaystones = new ArrayList();
    protected String filter = "";

    protected UniversalWaystoneScreenHandler(class_3917<? extends UniversalWaystoneScreenHandler> type, int syncId, class_1657 player) {
        super(type, syncId);
        this.updateWaystones(player);
        this.player = player;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)this.player.field_7514, x + y * 9 + 9, 2000000000, 2000000000));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)this.player.field_7514, x, 2000000000, 2000000000));
        }
    }

    public void updateWaystones(class_1657 player) {
        if (!player.field_6002.field_9236) {
            return;
        }
        this.sortedWaystones = new ArrayList();
        if (((PlayerEntityMixinAccess)player).shouldViewDiscoveredWaystones()) {
            this.sortedWaystones.addAll(((PlayerAccess)player).getHashesSorted());
        }
        if (((PlayerEntityMixinAccess)player).shouldViewGlobalWaystones()) {
            for (String waystone : WaystonesClient.WAYSTONE_STORAGE.getGlobals()) {
                if (this.sortedWaystones.contains(waystone)) continue;
                this.sortedWaystones.add(waystone);
            }
        }
        this.sortedWaystones.sort(Comparator.comparing(a -> WaystonesClient.WAYSTONE_STORAGE.getName((String)a)));
        this.filteredWaystones = new ArrayList<String>(this.sortedWaystones);
        this.filterWaystones();
    }

    public boolean method_7604(class_1657 player, int id) {
        if (!player.field_6002.field_9236) {
            return false;
        }
        int waystoneID = Math.floorDiv(id, 2);
        if (waystoneID >= this.filteredWaystones.size()) {
            return false;
        }
        String waystone = this.filteredWaystones.get(waystoneID);
        if (waystone == null) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2487 tag = new class_2487();
        tag.method_10582("waystone_hash", waystone);
        data.method_10794(tag);
        if (id % 2 != 0) {
            this.sortedWaystones.remove(waystone);
            this.filteredWaystones.remove(waystone);
            ClientPlayNetworking.send((class_2960)Utils.ID("forget_waystone"), (class_2540)data);
            this.onForget(waystone);
        } else {
            if (Utils.canTeleport(player, waystone)) {
                ClientPlayNetworking.send((class_2960)Utils.ID("teleport_to_waystone"), (class_2540)data);
                this.playSounds();
            }
            this.closeScreen();
        }
        return true;
    }

    protected void closeScreen() {
        if (this.player == null) {
            return;
        }
        if (this.player.field_6002.field_9236) {
            this.closeOnClient();
        } else {
            ((ServerPlayerEntityAccessor)this.player).getNetworkHandler().method_14364((class_2596)new class_2645(this.field_7763));
            this.player.field_7512.method_7595(this.player);
            this.player.field_7512 = this.player.field_7498;
        }
    }

    protected void closeOnClient() {
        ((ClientPlayerEntityAccessor)this.player).getNetworkHandler().method_2883((class_2596)new class_2815(this.field_7763));
        this.player.field_7514.method_7396(class_1799.field_8037);
        this.player.field_7512 = this.player.field_7498;
        class_310.method_1551().method_1507(null);
    }

    protected void playSounds() {
        if (!this.player.field_6002.field_9236) {
            return;
        }
        ClientStuff.playSound(class_3417.field_14879, 1.0f);
    }

    public abstract void onForget(String var1);

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getWaystonesCount() {
        return this.filteredWaystones.size();
    }

    public ArrayList<String> getSearchedWaystones() {
        return this.filteredWaystones;
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
    }

    public void filterWaystones() {
        this.filteredWaystones.clear();
        for (String waystone : this.sortedWaystones) {
            if (!"".equals(this.filter) && !WaystonesClient.WAYSTONE_STORAGE.getName(waystone).toLowerCase().startsWith(this.filter)) continue;
            this.filteredWaystones.add(waystone);
        }
    }
}

