/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class PlayerVolumeConfig {
    private Properties properties;
    private Path path = FMLPaths.CONFIGDIR.get().resolve("voicechat").resolve("player-volumes.properties");

    public PlayerVolumeConfig() {
        this.properties = new Properties();
        try {
            this.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() throws IOException {
        File file = this.path.toFile();
        if (file.exists()) {
            this.properties.load(new FileInputStream(file));
        }
    }

    public void save() throws IOException {
        File file = this.path.toFile();
        file.getParentFile().mkdirs();
        this.properties.store(new FileWriter(file, false), "The adjusted volumes for all other players");
    }

    public double getVolume(UUID uuid, double def) {
        String property = this.properties.getProperty(uuid.toString());
        if (property == null) {
            return this.setVolume(uuid, def);
        }
        try {
            return Double.parseDouble(property);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return this.setVolume(uuid, def);
        }
    }

    public double getVolume(UUID playerID) {
        return this.getVolume(playerID, 1.0);
    }

    public double setVolume(UUID uuid, double value) {
        this.properties.put(uuid.toString(), String.valueOf(value));
        new Thread(() -> {
            try {
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        return value;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

