/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.DataLines;
import de.maxhenkel.voicechat.voice.common.OpusDecoder;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.commons.lang3.tuple.Pair;

public class AudioChannel
extends Thread {
    private Minecraft minecraft;
    private ClientPlayerStateManager playerStateManager;
    private Client client;
    private UUID uuid;
    private BlockingQueue<SoundPacket> queue;
    private long lastPacketTime;
    private SourceDataLine speaker;
    private FloatControl gainControl;
    private boolean stopped;
    private OpusDecoder decoder;
    private long lastSequenceNumber;

    public AudioChannel(Client client, UUID uuid) {
        this.client = client;
        this.uuid = uuid;
        this.queue = new LinkedBlockingQueue<SoundPacket>();
        this.lastPacketTime = System.currentTimeMillis();
        this.stopped = false;
        this.decoder = new OpusDecoder(AudioChannelConfig.getSampleRate(), AudioChannelConfig.getFrameSize(), (Integer)Main.SERVER_CONFIG.voiceChatMtuSize.get());
        this.lastSequenceNumber = -1L;
        this.minecraft = Minecraft.func_71410_x();
        this.playerStateManager = Main.CLIENT_VOICE_EVENTS.getPlayerStateManager();
        this.setDaemon(true);
        this.setName("AudioChannelThread-" + uuid.toString());
        Main.LOGGER.debug("Creating audio channel for " + uuid);
    }

    public boolean canKill() {
        return System.currentTimeMillis() - this.lastPacketTime > 30000L;
    }

    public void closeAndKill() {
        Main.LOGGER.debug("Closing audio channel for " + this.uuid);
        this.stopped = true;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addToQueue(SoundPacket p) {
        this.queue.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AudioFormat af = AudioChannelConfig.getStereoFormat();
            this.speaker = DataLines.getSpeaker();
            this.speaker.open(af);
            this.gainControl = (FloatControl)this.speaker.getControl(FloatControl.Type.MASTER_GAIN);
            while (!this.stopped) {
                SoundPacket packet;
                if (Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().isDisabled()) {
                    this.speaker.stop();
                    this.queue.clear();
                    this.closeAndKill();
                    this.flushRecording();
                    return;
                }
                if (this.speaker.isActive() && this.speaker.getBufferSize() - this.speaker.available() <= 0) {
                    this.speaker.stop();
                    this.lastSequenceNumber = -1L;
                    this.flushRecording();
                }
                if (((Boolean)Main.CLIENT_CONFIG.clearFullAudioBuffer.get()).booleanValue() && this.speaker.isActive() && this.speaker.getBufferSize() - this.speaker.available() > AudioChannelConfig.maxSpeakerBufferSize()) {
                    CooldownTimer.run("clear_audio_buffer", () -> Main.LOGGER.warn("Clearing buffers to avoid audio delay"));
                    this.speaker.stop();
                    this.speaker.flush();
                    this.lastSequenceNumber = -1L;
                    this.flushRecording();
                }
                if ((packet = this.queue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                this.lastPacketTime = System.currentTimeMillis();
                if (this.lastSequenceNumber >= 0L && packet.getSequenceNumber() <= this.lastSequenceNumber) continue;
                if (this.speaker.getBufferSize() - this.speaker.available() <= 0) {
                    byte[] data = new byte[Math.min(AudioChannelConfig.getFrameSize() * (Integer)Main.CLIENT_CONFIG.outputBufferSize.get(), this.speaker.getBufferSize() - AudioChannelConfig.getFrameSize())];
                    this.speaker.write(data, 0, data.length);
                }
                if (this.minecraft.field_71441_e == null || this.minecraft.field_71439_g == null) continue;
                this.client.getTalkCache().updateTalking(this.uuid);
                if (this.lastSequenceNumber >= 0L) {
                    int packetsToCompensate = (int)(packet.getSequenceNumber() - (this.lastSequenceNumber + 1L));
                    for (int i = 0; i < packetsToCompensate; ++i) {
                        if (this.speaker.available() < AudioChannelConfig.getFrameSize()) {
                            Main.LOGGER.debug("Could not compensate more than " + i + " audio packets");
                            break;
                        }
                        this.writeToSpeaker(this.decoder.decode(null));
                    }
                }
                this.lastSequenceNumber = packet.getSequenceNumber();
                byte[] decodedAudio = this.decoder.decode(packet.getData());
                this.writeToSpeaker(decodedAudio);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.speaker != null) {
                this.speaker.stop();
                this.speaker.flush();
                this.speaker.close();
            }
            this.decoder.close();
            this.flushRecording();
            Main.LOGGER.debug("Closed audio channel for " + this.uuid);
        }
    }

    private void flushRecording() {
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.writeChunkThreaded(this.uuid);
    }

    private void writeToSpeaker(byte[] monoData) {
        byte[] stereo;
        PlayerState state = this.playerStateManager.getState(this.uuid);
        if (state == null) {
            CooldownTimer.run("write_no_state", () -> Main.LOGGER.warn("Received audio from player without state ({})", (Object)this.uuid));
            return;
        }
        if (state.hasGroup() && state.getGroup().equals(this.playerStateManager.getGroup())) {
            stereo = Utils.convertToStereo(monoData, 1.0f, 1.0f);
        } else {
            PlayerEntity player = this.minecraft.field_71441_e.func_217371_b(this.uuid);
            if (player == null) {
                return;
            }
            float distance = player.func_70032_d((Entity)this.minecraft.field_71439_g);
            float fadeDistance = ((Double)Main.SERVER_CONFIG.voiceChatFadeDistance.get()).floatValue();
            float maxDistance = ((Double)Main.SERVER_CONFIG.voiceChatDistance.get()).floatValue();
            float percentage = 1.0f;
            if (distance > fadeDistance) {
                percentage = 1.0f - Math.min((distance - fadeDistance) / (maxDistance - fadeDistance), 1.0f);
            }
            if (((Boolean)Main.CLIENT_CONFIG.stereo.get()).booleanValue()) {
                Pair<Float, Float> stereoVolume = Utils.getStereoVolume(this.minecraft, player.func_213303_ch(), maxDistance);
                stereo = Utils.convertToStereo(monoData, percentage * ((Float)stereoVolume.getLeft()).floatValue(), percentage * ((Float)stereoVolume.getRight()).floatValue());
            } else {
                stereo = Utils.convertToStereo(monoData, percentage, percentage);
            }
        }
        this.gainControl.setValue(Math.min(Math.max(Utils.percentageToDB(((Double)Main.CLIENT_CONFIG.voiceChatVolume.get()).floatValue() * (float)Main.VOLUME_CONFIG.getVolume(this.uuid)), this.gainControl.getMinimum()), this.gainControl.getMaximum()));
        if (this.client.getRecorder() != null) {
            try {
                this.client.getRecorder().appendChunk(state.getGameProfile(), System.currentTimeMillis(), stereo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.speaker.write(stereo, 0, stereo.length);
        this.speaker.start();
    }

    public boolean isClosed() {
        return this.stopped;
    }
}

