/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import com.sun.jna.ptr.PointerByReference;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.opus4j.Opus;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;

public class OpusDecoder {
    protected PointerByReference opusDecoder;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;
    protected boolean closed;

    public OpusDecoder(int sampleRate, int frameSize, int maxPayloadSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        IntBuffer error = IntBuffer.allocate(1);
        this.opusDecoder = Opus.INSTANCE.opus_decoder_create(sampleRate, 1, error);
        if (error.get() != 0 && this.opusDecoder == null) {
            throw new IllegalStateException("Opus decoder error " + error.get());
        }
        Main.LOGGER.info("Initializing Opus decoder with sample rate " + sampleRate + " Hz, frame size " + frameSize + " bytes and max payload size " + maxPayloadSize + " bytes");
    }

    public byte[] decode(@Nullable byte[] data) {
        if (this.closed) {
            throw new IllegalStateException("Trying to decode with a closed decoder");
        }
        ShortBuffer decoded = ShortBuffer.allocate(4096);
        int result = data == null || data.length == 0 ? Opus.INSTANCE.opus_decode(this.opusDecoder, null, 0, decoded, this.frameSize / 2, 0) : Opus.INSTANCE.opus_decode(this.opusDecoder, data, data.length, decoded, this.frameSize / 2, 0);
        if (result < 0) {
            throw new RuntimeException("Failed to decode audio data");
        }
        short[] audio = new short[result];
        decoded.get(audio);
        byte[] outData = new byte[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            byte[] split = Utils.shortToBytes(audio[i]);
            outData[i * 2] = split[0];
            outData[i * 2 + 1] = split[1];
        }
        return outData;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        Opus.INSTANCE.opus_decoder_destroy(this.opusDecoder);
    }
}

