/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.net.AuthenticationMessage;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerVoiceEvents {
    private Server server;

    public void serverStarting(FMLServerStartedEvent event) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (event.getServer() instanceof DedicatedServer) {
            try {
                this.server = new Server((Integer)Main.SERVER_CONFIG.voiceChatPort.get(), event.getServer());
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initializePlayerConnection(ServerPlayerEntity player) {
        if (this.server == null) {
            return;
        }
        this.server.getPlayerStateManager().onPlayerLoggedIn(player);
        UUID secret = this.server.getSecret(player.func_110124_au());
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AuthenticationMessage(player.func_110124_au(), secret));
        Main.LOGGER.info("Sent secret to " + player.func_145748_c_().getString());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.initializePlayerConnection((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.server == null) {
            return;
        }
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            this.server.getPlayerStateManager().onPlayerLoggedOut(player);
            this.server.disconnectClient(player.func_110124_au());
            Main.LOGGER.info("Disconnecting client " + player.func_145748_c_().getString());
        }
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }
}

