/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;

public class LiquidRegionController {
    private FastNoise liquidRegionSampler;
    private class_5281 world;
    private String dimensionName;
    private Random rand;
    private class_2680 lavaBlock;
    private class_2680 waterBlock;
    private float liquidRegionThreshold;
    private static final float SMOOTH_RANGE = 0.04f;
    private static final float SMOOTH_DELTA = 0.01f;

    public LiquidRegionController(class_5281 worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.dimensionName = Objects.requireNonNull(this.world.method_8410().method_27983().method_29177()).toString();
        this.rand = new Random();
        this.lavaBlock = this.getLavaBlockFromString(config.lavaBlock.get());
        this.waterBlock = this.getWaterBlockFromString(config.waterBlock.get());
        this.liquidRegionThreshold = NoiseUtils.simplexNoiseOffsetByPercent(-1.0f, config.waterRegionSpawnChance.get().floatValue() / 100.0f);
        float waterRegionSize = config.cavernRegionSize.get().equalsIgnoreCase("extralarge") ? 0.001f : 0.004f;
        this.liquidRegionSampler = new FastNoise();
        this.liquidRegionSampler.SetSeed((int)this.world.method_8412() + 444);
        this.liquidRegionSampler.SetFrequency(waterRegionSize);
    }

    public class_2680[][] getLiquidBlocksForChunk(int chunkX, int chunkZ) {
        this.rand.setSeed(this.world.method_8412() ^ (long)chunkX ^ (long)chunkZ);
        class_2680[][] blocks = new class_2680[16][16];
        ColPos.Mutable pos = new ColPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.set(chunkX * 16 + x, chunkZ * 16 + z);
                blocks[x][z] = this.getLiquidBlockAtPos(this.rand, (ColPos)pos);
            }
        }
        return blocks;
    }

    private class_2680 getLiquidBlockAtPos(Random rand, ColPos colPos) {
        class_2680 liquidBlock = this.lavaBlock;
        if (this.liquidRegionThreshold > -1.0f) {
            float randOffset;
            float waterRegionNoise = this.liquidRegionSampler.GetNoise((float)colPos.getX(), (float)colPos.getZ());
            if (waterRegionNoise < this.liquidRegionThreshold - (randOffset = rand.nextFloat() * 0.01f + 0.04f)) {
                liquidBlock = this.waterBlock;
            } else if (waterRegionNoise < this.liquidRegionThreshold + randOffset) {
                liquidBlock = null;
            }
        }
        return liquidBlock;
    }

    private class_2680 getLavaBlockFromString(String lavaString) {
        class_2680 lavaBlock;
        try {
            lavaBlock = ((class_2248)class_2378.field_11146.method_10223(new class_2960(lavaString))).method_9564();
            BetterCaves.LOGGER.info(String.format("Using block '%s' as lava in cave generation for dimension %s", lavaBlock, this.dimensionName));
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn(String.format("Unable to use block '%s': %s", lavaString, e));
            BetterCaves.LOGGER.warn("Using vanilla lava instead...");
            lavaBlock = class_2246.field_10164.method_9564();
        }
        if (lavaBlock == null || lavaBlock == class_2246.field_10124.method_9564() && !lavaString.equals("minecraft:air")) {
            BetterCaves.LOGGER.warn(String.format("Unable to use block '%s': null block returned.\n Using vanilla lava instead...", lavaString));
            lavaBlock = class_2246.field_10164.method_9564();
        }
        return lavaBlock;
    }

    private class_2680 getWaterBlockFromString(String waterString) {
        class_2680 waterBlock;
        try {
            waterBlock = ((class_2248)class_2378.field_11146.method_10223(new class_2960(waterString))).method_9564();
            BetterCaves.LOGGER.info(String.format("Using block '%s' as water in cave generation for dimension %s", waterBlock, this.dimensionName));
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn(String.format("Unable to use block '%s': %s", waterString, e));
            BetterCaves.LOGGER.warn("Using vanilla water instead...");
            waterBlock = class_2246.field_10382.method_9564();
        }
        if (waterBlock == null || waterBlock == class_2246.field_10124.method_9564() && !waterString.equals("minecraft:air")) {
            BetterCaves.LOGGER.warn(String.format("Unable to use block '%s': null block returned.\n Using vanilla water instead...", waterString));
            waterBlock = class_2246.field_10382.method_9564();
        }
        return waterBlock;
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
    }
}

