/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ravine.BetterRavineCarver;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2920;
import net.minecraft.class_2922;
import net.minecraft.class_2939;
import net.minecraft.class_3133;
import net.minecraft.class_5281;

public class RavineCarverController {
    private class_5281 world;
    private class_2919 random = new class_2919();
    private boolean isRavinesEnabled;
    private boolean isDebugViewEnabled;
    private class_2922<class_3133> configuredCarver;
    private BetterRavineCarver betterRavineCarver;

    public RavineCarverController(class_5281 worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isRavinesEnabled = config.enableVanillaRavines.get();
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.betterRavineCarver = new BetterRavineCarver(this.world, config, (Codec<class_3133>)class_3133.field_24899);
        this.configuredCarver = new class_2922((class_2939)this.betterRavineCarver, (class_2920)new class_3133(0.02f));
    }

    public void carveChunk(class_2791 chunkIn, int chunkX, int chunkZ, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.isDebugViewEnabled || !this.isRavinesEnabled) {
            return;
        }
        for (int currChunkX = chunkX - 8; currChunkX <= chunkX + 8; ++currChunkX) {
            for (int currChunkZ = chunkZ - 8; currChunkZ <= chunkZ + 8; ++currChunkZ) {
                this.random.method_12663(this.world.method_8412(), currChunkX, currChunkZ);
                if (!this.configuredCarver.method_12669((Random)this.random, chunkX, chunkZ)) continue;
                this.betterRavineCarver.carve(chunkIn, (Random)this.random, this.world.method_8615(), currChunkX, currChunkZ, chunkX, chunkZ, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
            }
        }
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
        this.betterRavineCarver.setWorld(worldIn);
    }
}

