/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.ravine;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2918;
import net.minecraft.class_3133;
import net.minecraft.class_3532;
import net.minecraft.class_5281;

public class BetterRavineCarver
extends class_2918 {
    private class_5281 world;
    private boolean isFloodedRavinesEnabled;
    private boolean isReplaceGravelEnabled;
    private int liquidAltitude;
    private final float[] heightToHorizontalStretchFactor = new float[1024];

    public BetterRavineCarver(class_5281 worldIn, ConfigHolder config, Codec<class_3133> codec) {
        super(codec);
        this.world = worldIn;
        this.isFloodedRavinesEnabled = config.enableFloodedRavines.get();
        this.isReplaceGravelEnabled = config.replaceFloatingGravel.get();
        this.liquidAltitude = config.liquidAltitude.get();
    }

    public void carve(class_2791 chunkIn, Random rand, int seaLevel, int chunkX, int chunkZ, int originChunkX, int originChunkZ, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        int i = (this.method_12710() * 2 - 1) * 16;
        double startX = chunkX * 16 + rand.nextInt(16);
        double startY = rand.nextInt(rand.nextInt(40) + 8) + 20;
        double startZ = chunkZ * 16 + rand.nextInt(16);
        float yaw = rand.nextFloat() * ((float)Math.PI * 2);
        float pitch = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float width = (rand.nextFloat() * 2.0f + rand.nextFloat()) * 2.0f;
        double heightModifier = 3.0;
        int startCounter = 0;
        int endCounter = i - rand.nextInt(i / 4);
        this.carveRavine(chunkIn, rand.nextLong(), seaLevel, originChunkX, originChunkZ, startX, startY, startZ, width, yaw, pitch, startCounter, endCounter, heightModifier, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
    }

    private void carveRavine(class_2791 chunkIn, long seed, int seaLevel, int originChunkX, int originChunkZ, double ravineStartX, double ravineStartY, double ravineStartZ, float width, float yaw, float pitch, int startCounter, int endCounter, double heightModifier, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        Random random = new Random(seed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.heightToHorizontalStretchFactor[i] = f * f;
        }
        float yawModifier = 0.0f;
        float pitchModifier = 0.0f;
        while (startCounter < endCounter) {
            double xzOffset = 1.5 + (double)(class_3532.method_15374((float)((float)startCounter * (float)Math.PI / (float)endCounter)) * width);
            double yOffset = xzOffset * heightModifier;
            xzOffset *= (double)random.nextFloat() * 0.25 + 0.75;
            yOffset *= (double)random.nextFloat() * 0.25 + 0.75;
            float pitchXZ = class_3532.method_15362((float)pitch);
            float pitchY = class_3532.method_15374((float)pitch);
            ravineStartX += (double)(class_3532.method_15362((float)yaw) * pitchXZ);
            ravineStartY += (double)pitchY;
            ravineStartZ += (double)(class_3532.method_15374((float)yaw) * pitchXZ);
            pitch *= 0.7f;
            pitch += pitchModifier * 0.05f;
            yaw += yawModifier * 0.05f;
            pitchModifier *= 0.8f;
            yawModifier *= 0.5f;
            pitchModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) != 0) {
                if (!this.method_12707(originChunkX, originChunkZ, ravineStartX, ravineStartZ, startCounter, endCounter, width)) {
                    return;
                }
                this.carveRegion(chunkIn, seed, seaLevel, originChunkX, originChunkZ, ravineStartX, ravineStartY, ravineStartZ, xzOffset, yOffset, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
            }
            ++startCounter;
        }
    }

    protected boolean method_12707(int originChunkX, int originChunkZ, double ravineStartX, double ravineStartZ, int startCounter, int endCounter, float width) {
        double originBlockX = originChunkX * 16 + 8;
        double ravineStartXOffsetFromCenter = ravineStartX - originBlockX;
        double originBlockZ = originChunkZ * 16 + 8;
        double ravineStartZOffsetFromCenter = ravineStartZ - originBlockZ;
        double distanceToEnd = endCounter - startCounter;
        double d5 = width + 2.0f + 16.0f;
        return ravineStartXOffsetFromCenter * ravineStartXOffsetFromCenter + ravineStartZOffsetFromCenter * ravineStartZOffsetFromCenter - distanceToEnd * distanceToEnd <= d5 * d5;
    }

    protected void carveRegion(class_2791 chunkIn, long seed, int seaLevel, int originChunkX, int originChunkZ, double ravineStartX, double ravineStartY, double ravineStartZ, double xzOffset, double yOffset, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        Random rand = new Random(seed + (long)originChunkX + (long)originChunkZ);
        double originBlockX = originChunkX * 16 + 8;
        double originBlockZ = originChunkZ * 16 + 8;
        if (!(ravineStartX < originBlockX - 16.0 - xzOffset * 2.0 || ravineStartZ < originBlockZ - 16.0 - xzOffset * 2.0 || ravineStartX > originBlockX + 16.0 + xzOffset * 2.0 || ravineStartZ > originBlockZ + 16.0 + xzOffset * 2.0)) {
            int minLocalX = Math.max(class_3532.method_15357((double)(ravineStartX - xzOffset)) - originChunkX * 16 - 1, 0);
            int maxLocalX = Math.min(class_3532.method_15357((double)(ravineStartX + xzOffset)) - originChunkX * 16 + 1, 16);
            int minY = Math.max(class_3532.method_15357((double)(ravineStartY - yOffset)) - 1, 1);
            int maxY = Math.min(class_3532.method_15357((double)(ravineStartY + yOffset)) + 1, this.field_16653 - 8);
            int minLocalZ = Math.max(class_3532.method_15357((double)(ravineStartZ - xzOffset)) - originChunkZ * 16 - 1, 0);
            int maxLocalZ = Math.min(class_3532.method_15357((double)(ravineStartZ + xzOffset)) - originChunkZ * 16 + 1, 16);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int currLocalX = minLocalX; currLocalX < maxLocalX; ++currLocalX) {
                int realX = currLocalX + originChunkX * 16;
                double xAxisDist = ((double)realX + 0.5 - ravineStartX) / xzOffset;
                for (int currLocalZ = minLocalZ; currLocalZ < maxLocalZ; ++currLocalZ) {
                    int realZ = currLocalZ + originChunkZ * 16;
                    double zAxisDist = ((double)realZ + 0.5 - ravineStartZ) / xzOffset;
                    if (xAxisDist * xAxisDist + zAxisDist * zAxisDist >= 1.0) continue;
                    for (int currY = maxY; currY > minY; --currY) {
                        double yAxisDist = ((double)currY - 0.5 - ravineStartY) / yOffset;
                        if (this.method_16582(xAxisDist, yAxisDist, zAxisDist, currY)) continue;
                        mutableBlockPos.method_10103(realX, currY, realZ);
                        class_2680 liquidBlock = liquidBlocks[currLocalX][currLocalZ];
                        if (currY <= this.liquidAltitude && liquidBlock == null) {
                            return;
                        }
                        this.carveBlock(chunkIn, rand, seaLevel, mutableBlockPos, liquidBlock, biomePos, airCarvingMask, liquidCarvingMask);
                    }
                }
            }
        }
    }

    public boolean method_16582(double xAxisDist, double yAxisDist, double zAxisDist, int currY) {
        return (xAxisDist * xAxisDist + zAxisDist * zAxisDist) * (double)this.heightToHorizontalStretchFactor[currY - 1] + yAxisDist * yAxisDist / 6.0 >= 1.0;
    }

    private void carveBlock(class_2791 chunkIn, Random rand, int seaLevel, class_2338.class_2339 blockPos, class_2680 liquidBlockState, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        boolean flooded;
        int bitIndex = blockPos.method_10263() & 0xF | (blockPos.method_10260() & 0xF) << 4 | blockPos.method_10264() << 8;
        if (airCarvingMask.get(bitIndex) || liquidCarvingMask.get(bitIndex)) {
            return;
        }
        boolean bl = flooded = this.isFloodedRavinesEnabled && biomePos.apply((class_2338)blockPos).method_8688() == class_1959.class_1961.field_9367;
        if (flooded && blockPos.method_10264() >= seaLevel) {
            return;
        }
        float smoothAmpFloodFactor = BetterCavesUtils.getDistFactor(this.world, biomePos, (class_2338)blockPos, 2, flooded ? BetterCavesUtils.isNotOcean : BetterCavesUtils.isOcean);
        if (smoothAmpFloodFactor <= 0.25f) {
            return;
        }
        if (flooded) {
            CarverUtils.carveFloodedBlock(chunkIn, rand, blockPos, liquidBlockState, this.liquidAltitude, liquidCarvingMask);
        } else {
            CarverUtils.carveBlock(chunkIn, (class_2338)blockPos, liquidBlockState, this.liquidAltitude, this.isReplaceGravelEnabled, airCarvingMask);
        }
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
    }
}

