/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.config;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ContainingMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.overlays.SpyglassZoomOverlay;
import io.github.ennuil.libzoomer.api.transitions.InstantTransitionMode;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.okzoomer.config.ConfigEnums;
import io.github.ennuil.okzoomer.config.codec.FeaturesConfig;
import io.github.ennuil.okzoomer.config.codec.OkZoomerConfig;
import io.github.ennuil.okzoomer.config.codec.TweaksConfig;
import io.github.ennuil.okzoomer.config.codec.ValuesConfig;
import io.github.ennuil.okzoomer.config.json5.Json5Helper;
import io.github.ennuil.okzoomer.packets.ZoomPackets;
import io.github.ennuil.okzoomer.utils.ZoomUtils;
import io.github.ennuil.okzoomer.zoom.LinearTransitionMode;
import io.github.ennuil.okzoomer.zoom.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.okzoomer.zoom.ZoomerZoomOverlay;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.quiltmc.json5.JsonReader;
import org.quiltmc.json5.JsonWriter;
import org.quiltmc.json5.exception.MalformedSyntaxException;

public class OkZoomerConfigManager {
    public static Optional<Boolean> isConfigLoaded = Optional.empty();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("okzoomer.json5");
    public static OkZoomerConfig configInstance = OkZoomerConfig.getDefaultSettings();

    public static void loadModConfig() {
        block5: {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try {
                    JsonReader reader = JsonReader.json5((Path)CONFIG_PATH);
                    Optional result = OkZoomerConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)Json5Helper.parseJson5Reader(reader)).result();
                    reader.close();
                    if (result.isPresent()) {
                        configInstance = (OkZoomerConfig)result.get();
                        OkZoomerConfigManager.configureZoomInstance();
                        isConfigLoaded = Optional.of(true);
                        break block5;
                    }
                    ZoomUtils.LOGGER.error("Failed to load the settings!");
                    isConfigLoaded = Optional.of(false);
                }
                catch (IOException | MalformedSyntaxException e) {
                    ZoomUtils.LOGGER.error("Failed to load the settings!\n" + e.toString());
                }
            } else {
                OkZoomerConfigManager.saveModConfig();
                isConfigLoaded = Optional.of(true);
            }
        }
    }

    public static void saveModConfig() {
        Optional result = OkZoomerConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)configInstance).result();
        if (result.isPresent()) {
            try {
                JsonWriter writer = JsonWriter.json5((Path)CONFIG_PATH);
                writer.beginObject().name("features").beginObject().comment("Defines the cinematic camera while zooming.\n\"OFF\" disables the cinematic camera.\n\"VANILLA\" uses Vanilla's cinematic camera.\n\"MULTIPLIED\" is a multiplied variant of \"VANILLA\".\n").name("cinematic_camera").value(configInstance.features().getCinematicCamera().method_15434()).comment("Reduces the mouse sensitivity when zooming.").name("reduce_sensitivity").value(configInstance.features().getReduceSensitivity()).comment("Adds transitions between zooms.\n\"OFF\" disables transitions.\n\"SMOOTH\" replicates Vanilla's dynamic FOV.\n\"LINEAR\" removes the smoothiness.\n").name("zoom_transition").value(configInstance.features().getZoomTransition().method_15434()).comment("The behavior of the zoom key.\n\"HOLD\" needs the zoom key to be hold.\n\"TOGGLE\" has the zoom key toggle the zoom.\n\"PERSISTENT\" makes the zoom permanent.\n").name("zoom_mode").value(configInstance.features().getZoomMode().method_15434()).comment("Allows to increase or decrease zoom by scrolling.").name("zoom_scrolling").value(configInstance.features().getZoomScrolling()).comment("Adds zoom manipulation keys along with the zoom key.").name("extra_key_binds").value(configInstance.features().getExtraKeyBinds()).comment("Adds an overlay in the screen during zoom.\n\"VIGNETTE\" uses a vignette as the overlay.\n\"SPYGLASS\" uses the spyglass overlay with the vignette texture.\nThe vignette texture can be found at: assets/okzoomer/textures/misc/zoom_overlay.png\n").name("zoom_overlay").value(configInstance.features().getZoomOverlay().method_15434()).comment("Determines how the zoom will depend on the spyglass.\n\"REQUIRE_ITEM\" will make zooming require a spyglass.\n\"REPLACE_ZOOM\" will replace spyglass's zoom with Ok Zoomer's zoom.\n\"BOTH\" will apply both options at the same time.\nThe \"REQUIRE_ITEM\" option is configurable through the okzoomer:zoom_dependencies item tag.\n").name("spyglass_dependency").value(configInstance.features().getSpyglassDependency().method_15434()).endObject().name("values").beginObject().comment("The divisor applied to the FOV when zooming.").name("zoom_divisor").value(configInstance.values().getZoomDivisor()).comment("The minimum value that you can scroll down.").name("minimum_zoom_divisor").value(configInstance.values().getMinimumZoomDivisor()).comment("The maximum value that you can scroll down.").name("maximum_zoom_divisor").value(configInstance.values().getMaximumZoomDivisor()).comment("The number of steps between the zoom divisor and the maximum zoom divisor.\nUsed by zoom scrolling.\n").name("upper_scroll_steps").value((long)configInstance.values().getUpperScrollSteps()).comment("The number of steps between the zoom divisor and the minimum zoom divisor.\nUsed by zoom scrolling.\n").name("lower_scroll_steps").value((long)configInstance.values().getLowerScrollSteps()).comment("The multiplier used for smooth transitions.").name("smooth_multiplier").value(configInstance.values().getSmoothMultiplier()).comment("The multiplier used for the multiplied cinematic camera.").name("cinematic_multiplier").value(configInstance.values().getCinematicMultiplier()).comment("The minimum value which the linear transition step can reach.").name("minimum_linear_step").value(configInstance.values().getMinimumLinearStep()).comment("The maximum value which the linear transition step can reach.").name("maximum_linear_step").value(configInstance.values().getMaximumLinearStep()).endObject().name("tweaks").beginObject().comment("Allows for resetting the zoom with the middle mouse button.").name("reset_zoom_with_mouse").value(configInstance.tweaks().getResetZoomWithMouse()).comment("If pressed, the \"Save Toolbar Activator\" keybind will be unbound if there's a conflict with the zoom key.").name("unbind_conflicting_key").value(configInstance.tweaks().getUnbindConflictingKey()).comment("If enabled, the spyglass overlay texture is used instead of Ok Zoomer's overlay texture.").name("use_spyglass_texture").value(configInstance.tweaks().getUseSpyglassTexture()).comment("If enabled, the zoom will use spyglass sounds on zooming in and out.").name("use_spyglass_sounds").value(configInstance.tweaks().getUseSpyglassSounds()).comment("Shows toasts when the server imposes a restriction.").name("show_restriction_toasts").value(configInstance.tweaks().getShowRestrictionToasts()).comment("Prints a random owo in the console when the game starts. Enabled by default until full release.").name("print_owo_on_start").value(configInstance.tweaks().getPrintOwoOnStart()).endObject().endObject();
                writer.close();
                OkZoomerConfigManager.configureZoomInstance();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void configureZoomInstance() {
        ZoomUtils.ZOOMER_ZOOM.setTransitionMode((TransitionMode)(switch (configInstance.features().getZoomTransition()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode((float)configInstance.values().getSmoothMultiplier());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode(configInstance.values().getMinimumLinearStep(), configInstance.values().getMaximumLinearStep());
            default -> new InstantTransitionMode();
        }));
        if (ZoomPackets.getForceClassicMode()) {
            ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor(4.0);
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)new CinematicCameraMouseModifier());
            ZoomUtils.ZOOMER_ZOOM.setZoomOverlay(null);
            return;
        }
        ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor(configInstance.values().getZoomDivisor());
        OkZoomerConfigManager.configureZoomModifier();
        class_2960 overlayTextureId = new class_2960(configInstance.tweaks().getUseSpyglassTexture() ? "textures/misc/spyglass_scope.png" : "okzoomer:textures/misc/zoom_overlay.png");
        ConfigEnums.ZoomOverlays overlay = ZoomPackets.getSpyglassOverlay() ? ConfigEnums.ZoomOverlays.SPYGLASS : configInstance.features().getZoomOverlay();
        ZoomUtils.ZOOMER_ZOOM.setZoomOverlay((ZoomOverlay)(switch (overlay) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        }));
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = configInstance.features().getCinematicCamera();
        boolean reduceSensitivity = configInstance.features().getReduceSensitivity();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            Object cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier(configInstance.values().getCinematicMultiplier());
                default -> null;
            };
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ContainingMouseModifier(new MouseModifier[]{cinematicModifier, new ZoomDivisorMouseModifier()}) : cinematicModifier));
        } else {
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ZoomDivisorMouseModifier() : null));
        }
    }

    public static void resetToPreset(ZoomPresets preset) {
        ConfigEnums.CinematicCameraOptions cinematicCameraOptions = preset == ZoomPresets.CLASSIC ? ConfigEnums.CinematicCameraOptions.VANILLA : ConfigEnums.CinematicCameraOptions.OFF;
        boolean bl = preset != ZoomPresets.CLASSIC;
        ConfigEnums.ZoomTransitionOptions zoomTransitionOptions = preset == ZoomPresets.CLASSIC ? ConfigEnums.ZoomTransitionOptions.OFF : ConfigEnums.ZoomTransitionOptions.SMOOTH;
        ConfigEnums.ZoomModes zoomModes = preset == ZoomPresets.PERSISTENT ? ConfigEnums.ZoomModes.PERSISTENT : ConfigEnums.ZoomModes.HOLD;
        FeaturesConfig featuresConfig = new FeaturesConfig(cinematicCameraOptions, bl, zoomTransitionOptions, zoomModes, switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            case ZoomPresets.SPYGLASS -> false;
            default -> true;
        }, preset != ZoomPresets.CLASSIC, preset == ZoomPresets.SPYGLASS ? ConfigEnums.ZoomOverlays.SPYGLASS : ConfigEnums.ZoomOverlays.OFF, preset == ZoomPresets.SPYGLASS ? ConfigEnums.SpyglassDependency.BOTH : ConfigEnums.SpyglassDependency.OFF);
        configInstance = new OkZoomerConfig(featuresConfig, new ValuesConfig(switch (preset) {
            case ZoomPresets.PERSISTENT -> 1.0;
            case ZoomPresets.SPYGLASS -> 10.0;
            default -> 4.0;
        }, 1.0, 50.0, preset == ZoomPresets.SPYGLASS ? 16 : 20, preset == ZoomPresets.SPYGLASS ? 8 : 4, preset == ZoomPresets.SPYGLASS ? 0.5 : 0.75, 4.0, 0.125, 0.25), new TweaksConfig(preset != ZoomPresets.CLASSIC, false, preset == ZoomPresets.SPYGLASS, preset == ZoomPresets.SPYGLASS, true, preset != ZoomPresets.CLASSIC));
    }

    public static enum ZoomPresets {
        DEFAULT,
        CLASSIC,
        PERSISTENT,
        SPYGLASS;

    }
}

