/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.config.json5;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.io.IOException;
import org.quiltmc.json5.JsonReader;
import org.quiltmc.json5.JsonToken;

public class Json5Helper {
    public static final JsonElement parseJson5Reader(JsonReader reader) throws IOException {
        return switch (reader.peek()) {
            case JsonToken.STRING -> new JsonPrimitive(reader.nextString());
            case JsonToken.NUMBER -> new JsonPrimitive((Number)new LazilyParsedNumber(reader.nextString()));
            case JsonToken.BOOLEAN -> new JsonPrimitive(Boolean.valueOf(reader.nextBoolean()));
            case JsonToken.NULL -> {
                reader.nextNull();
                yield JsonNull.INSTANCE;
            }
            case JsonToken.BEGIN_ARRAY -> {
                JsonArray array = new JsonArray();
                reader.beginArray();
                while (reader.hasNext()) {
                    array.add(Json5Helper.parseJson5Reader(reader));
                }
                reader.endArray();
                yield array;
            }
            case JsonToken.BEGIN_OBJECT -> {
                JsonObject object = new JsonObject();
                reader.beginObject();
                while (reader.hasNext()) {
                    object.add(reader.nextName(), Json5Helper.parseJson5Reader(reader));
                }
                reader.endObject();
                yield object;
            }
            default -> throw new IllegalArgumentException();
        };
    }
}

