/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.config.screen;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class SpruceBoundedDoubleInputOption
extends SpruceOption {
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;
    private final class_2561 tooltip;
    private final double defaultValue;
    private final Optional<Double> minimum;
    private final Optional<Double> maximum;

    public SpruceBoundedDoubleInputOption(String key, double defaultValue, Optional<Double> minimum, Optional<Double> maximum, Supplier<Double> getter, Consumer<Double> setter, @Nullable class_2561 tooltip) {
        super(key);
        this.defaultValue = defaultValue;
        this.minimum = minimum;
        this.maximum = maximum;
        this.getter = getter;
        this.setter = setter;
        this.tooltip = tooltip;
    }

    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.DOUBLE_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                class_5250 tooltipText = class_2585.field_24366.method_27661().method_10852(this.tooltip);
                class_2583 tooltipStyle = class_2583.field_24360;
                double value = Double.parseDouble(textField.getText());
                Optional<Boolean> bound = this.boundCheck(value);
                if (bound.isPresent()) {
                    tooltipStyle = tooltipStyle.method_10977(class_124.field_1061);
                    if (this.minimum.isPresent()) {
                        if (!bound.get().booleanValue()) {
                            boolean aboveZero = this.minimum.get() == Double.MIN_NORMAL;
                            tooltipText = tooltipText.method_27693("\n");
                            tooltipText = tooltipText.method_10852((class_2561)new class_2588("config.okzoomer.widget.bounded_double.below_range", new Object[]{aboveZero ? new class_2588("config.okzoomer.widget.bounded_double.above_zero") : this.minimum.get().toString()}).method_10862(tooltipStyle));
                        } else {
                            tooltipText = tooltipText.method_10852((class_2561)new class_2588("config.okzoomer.widget.bounded_double.above_range", new Object[]{this.maximum.get().toString()}).method_10862(tooltipStyle));
                        }
                    }
                }
                textField.setTooltip((class_2561)tooltipText);
                return class_5481.method_30747((String)displayedText, (class_2583)tooltipStyle);
            }
            catch (NumberFormatException e) {
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
        });
        textField.setChangedListener(input -> {
            double value;
            try {
                value = Double.parseDouble(textField.getText());
                if (this.boundCheck(value).isPresent()) {
                    value = this.defaultValue;
                }
            }
            catch (NumberFormatException e) {
                value = this.defaultValue;
            }
            this.set(value);
        });
        this.setTooltip(this.tooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter.get();
    }

    private Optional<Boolean> boundCheck(double value) {
        if (this.minimum.isPresent() && value < this.minimum.get()) {
            return Optional.of(false);
        }
        if (this.maximum.isPresent() && value > this.maximum.get()) {
            return Optional.of(true);
        }
        return Optional.empty();
    }
}

