/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsBuiltinRegistries;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class OriginArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType ORIGIN_NOT_FOUND = new DynamicCommandExceptionType(p_208663_0_ -> Component.m_237110_((String)"commands.origin.origin_not_found", (Object[])new Object[]{p_208663_0_}));

    public static OriginArgumentType origin() {
        return new OriginArgumentType();
    }

    public ResourceLocation parse(StringReader p_parse_1_) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)p_parse_1_);
    }

    public static ResourceKey<Origin> getOrigin(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
        ResourceLocation id = (ResourceLocation)context.getArgument(argumentName, ResourceLocation.class);
        if (!OriginsAPI.getOriginsRegistry(((CommandSourceStack)context.getSource()).m_81377_()).m_7804_(id)) {
            throw ORIGIN_NOT_FOUND.create((Object)id);
        }
        return ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)id);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<ResourceLocation> availableOrigins = new ArrayList<ResourceLocation>();
        availableOrigins.add(OriginsBuiltinRegistries.ORIGINS.get().getKey((Object)Origin.EMPTY));
        ResourceLocation originLayerId = (ResourceLocation)context.getArgument("layer", ResourceLocation.class);
        OriginLayer originLayer = (OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(originLayerId);
        availableOrigins.addAll(originLayer.origins().stream().map(Holder::m_203543_).flatMap(Optional::stream).map(ResourceKey::m_135782_).collect(Collectors.toCollection(LinkedList::new)));
        return SharedSuggestionProvider.m_82957_(availableOrigins.stream(), (SuggestionsBuilder)builder);
    }
}

