/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.origin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.github.edwinmindcraft.calio.api.network.CodecSet;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.origin.OriginUpgrade;
import io.github.edwinmindcraft.origins.api.registry.OriginsBuiltinRegistries;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ObjectHolder;

public class Origin {
    @ObjectHolder(value="origins:empty", registryName="origins:origins")
    public static final Origin EMPTY = new Origin((Collection<HolderSet<ConfiguredPower<?, ?>>>)ImmutableSet.of(), ItemStack.f_41583_, true, -1, Impact.NONE, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""), (Set<OriginUpgrade>)ImmutableSet.of(), true);
    private final List<HolderSet<ConfiguredPower<?, ?>>> powers;
    private final ItemStack icon;
    private final boolean unchoosable;
    private final int order;
    private final Impact impact;
    private final Component name;
    private final Component description;
    private final Set<OriginUpgrade> upgrades;
    private final boolean special;
    public static final Codec<Holder<Origin>> HOLDER_REFERENCE = CalioCodecHelper.holderRef(OriginsDynamicRegistries.ORIGINS_REGISTRY, (Codec)SerializableDataTypes.IDENTIFIER);
    public static final Codec<Origin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredPower.CODEC_SET.set().fieldOf("powers").forGetter(Origin::getPowers), (App)CalioCodecHelper.optionalField((Codec)ItemStack.f_41582_, (String)"icon", (Object)ItemStack.f_41583_).forGetter(Origin::getIcon), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"unchoosable", (Object)false).forGetter(Origin::isUnchoosable), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.INT, (String)"order", (Object)Integer.MAX_VALUE).forGetter(Origin::getOrder), (App)CalioCodecHelper.optionalField(OriginsDataTypes.IMPACT, (String)"impact", (Object)((Object)Impact.NONE)).forGetter(Origin::getImpact), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("name").forGetter(Origin::getName), (App)CalioCodecHelper.COMPONENT_CODEC.fieldOf("description").forGetter(Origin::getDescription), (App)CalioCodecHelper.setOf(OriginUpgrade.CODEC).fieldOf("upgrades").forGetter(Origin::getUpgrades), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"special", (Object)false).forGetter(Origin::isSpecial)).apply((Applicative)instance, Origin::new));
    public static final CodecSet<Origin> CODEC_SET = CalioCodecHelper.forDynamicRegistry(OriginsDynamicRegistries.ORIGINS_REGISTRY, (Codec)SerializableDataTypes.IDENTIFIER, CODEC);

    public static MapCodec<Holder<Origin>> optional(String name) {
        return CalioCodecHelper.registryDefaultedField(HOLDER_REFERENCE, (String)name, OriginsDynamicRegistries.ORIGINS_REGISTRY, OriginsBuiltinRegistries.ORIGINS);
    }

    public Origin(Collection<HolderSet<ConfiguredPower<?, ?>>> powers, ItemStack icon, boolean unchoosable, int order, Impact impact, Component name, Component description, Set<OriginUpgrade> upgrades, boolean special) {
        this.powers = ImmutableList.copyOf(powers);
        this.icon = icon;
        this.unchoosable = unchoosable;
        this.order = order;
        this.impact = impact;
        this.name = name;
        this.description = description;
        this.upgrades = ImmutableSet.copyOf(upgrades);
        this.special = special;
    }

    public Origin(Collection<HolderSet<ConfiguredPower<?, ?>>> powers, ItemStack icon, boolean unchoosable, int order, Impact impact, Component name, Component description, Set<OriginUpgrade> upgrades) {
        this(powers, icon, unchoosable, order, impact, name, description, upgrades, false);
    }

    public Origin cleanup(ICalioDynamicRegistryManager manager) {
        WritableRegistry powers = manager.get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
        ImmutableList.Builder direct = ImmutableList.builder();
        ImmutableList.Builder sets = ImmutableList.builder();
        for (HolderSet<ConfiguredPower<?, ?>> holderSet : this.getPowers()) {
            Either unwrap = holderSet.m_203440_();
            unwrap.ifLeft(arg_0 -> Origin.lambda$cleanup$2((Registry)powers, sets, holderSet, arg_0));
            unwrap.ifRight(holders -> {
                for (Holder holder : holders) {
                    if (!holder.m_203633_()) continue;
                    direct.add((Object)holder);
                }
            });
        }
        ImmutableList build = direct.build();
        if (build.size() > 0) {
            sets.add((Object)HolderSet.m_205800_((List)build));
        }
        return new Origin((Collection<HolderSet<ConfiguredPower<?, ?>>>)sets.build(), this.getIcon(), this.isUnchoosable(), this.getOrder(), this.getImpact(), this.getName(), this.getDescription(), this.getUpgrades(), this.isSpecial());
    }

    public List<HolderSet<ConfiguredPower<?, ?>>> getPowers() {
        return this.powers;
    }

    public Stream<Holder<ConfiguredPower<?, ?>>> getValidPowers() {
        return this.powers.stream().flatMap(HolderSet::m_203614_).filter(Holder::m_203633_);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean isUnchoosable() {
        return this.unchoosable;
    }

    public int getOrder() {
        return this.order;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    public Set<OriginUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public boolean isChoosable() {
        return !this.isUnchoosable();
    }

    public boolean isSpecial() {
        return this.special;
    }

    public Optional<OriginUpgrade> findUpgrade(ResourceLocation advancement) {
        return this.getUpgrades().stream().filter(x -> Objects.equals(x.advancement(), advancement)).findFirst();
    }

    public String toString() {
        ResourceLocation name = CalioAPI.getDynamicRegistries().getOrEmpty(OriginsDynamicRegistries.ORIGINS_REGISTRY).flatMap(x -> x.m_7854_((Object)this)).map(ResourceKey::m_135782_).orElse(null);
        StringBuilder builder = new StringBuilder("Origin(").append(name).append(")[");
        boolean first = true;
        for (Holder<ConfiguredPower<?, ?>> power : this.getValidPowers().toList()) {
            if (!power.m_203633_()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(power);
        }
        return builder.append(']').toString();
    }

    private static /* synthetic */ void lambda$cleanup$2(Registry powers, ImmutableList.Builder sets, HolderSet holderSet, TagKey tagKey) {
        powers.m_203431_(tagKey).ifPresent(x -> sets.add((Object)holderSet));
    }
}

