/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.renderlayers.BodyLayerFeatureRenderer;
import dev.tr7zw.skinlayers.renderlayers.HeadLayerFeatureRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    public void onCreate(CallbackInfo info) {
        this.m_115326_(new HeadLayerFeatureRenderer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
        this.m_115326_(new BodyLayerFeatureRenderer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
    }

    @Inject(method={"setModelProperties"}, at={@At(value="RETURN")})
    public void setModelProperties(AbstractClientPlayer abstractClientPlayer, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_20280_((Entity)abstractClientPlayer) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerModel playerModel = (PlayerModel)this.m_7200_();
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        if (settings.getHeadMesh() == null) {
            return;
        }
        playerModel.f_102809_.f_104207_ = playerModel.f_102809_.f_104207_ && !SkinLayersModBase.config.enableHat;
        playerModel.f_103378_.f_104207_ = playerModel.f_103378_.f_104207_ && !SkinLayersModBase.config.enableJacket;
        playerModel.f_103374_.f_104207_ = playerModel.f_103374_.f_104207_ && !SkinLayersModBase.config.enableLeftSleeve;
        playerModel.f_103375_.f_104207_ = playerModel.f_103375_.f_104207_ && !SkinLayersModBase.config.enableRightSleeve;
        playerModel.f_103376_.f_104207_ = playerModel.f_103376_.f_104207_ && !SkinLayersModBase.config.enableLeftPants;
        playerModel.f_103377_.f_104207_ = playerModel.f_103377_.f_104207_ && !SkinLayersModBase.config.enableRightPants;
    }

    @Inject(method={"renderHand"}, at={@At(value="RETURN")})
    private void renderHand(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, ModelPart arm, ModelPart sleeve, CallbackInfo info) {
        boolean rightSleeve;
        boolean bl = rightSleeve = ((PlayerModel)this.m_7200_()).f_103374_ != sleeve;
        if (rightSleeve ? !SkinLayersModBase.config.enableRightSleeve : !SkinLayersModBase.config.enableLeftSleeve) {
            return;
        }
        sleeve.f_104207_ = false;
        if (!abstractClientPlayer.m_36170_(rightSleeve ? PlayerModelPart.RIGHT_SLEEVE : PlayerModelPart.LEFT_SLEEVE)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        float pixelScaling = 1.1f;
        float armHeightScaling = 1.1f;
        boolean thinArms = ((PlayerEntityModelAccessor)this.m_7200_()).hasThinArms();
        if (!SkinUtil.setup3dLayers(abstractClientPlayer, settings, thinArms, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_7200_()))) {
            return;
        }
        Mesh part = sleeve == ((PlayerModel)this.f_115290_).f_103374_ ? settings.getLeftArmMesh() : settings.getRightArmMesh();
        part.copyFrom(arm);
        poseStack.m_85836_();
        poseStack.m_85841_(pixelScaling, armHeightScaling, pixelScaling);
        boolean left = sleeve == ((PlayerModel)this.f_115290_).f_103374_;
        float x = left ? 5.0f : -5.0f;
        float y = 1.4f;
        if (!thinArms) {
            x = left ? (float)((double)x + 0.4) : (float)((double)x - 0.4);
        }
        part.setPosition(x, y, 0.0f);
        part.render(poseStack, multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)abstractClientPlayer.m_108560_())), i, OverlayTexture.f_118083_);
        part.setPosition(0.0f, 0.0f, 0.0f);
        part.setRotation(0.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
    }
}

