/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.google.common.collect.Lists;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.core.Direction;

class CustomizableCubeListBuilder {
    private final List<CustomizableCube> cubes = Lists.newArrayList();
    private final List<ModelPart.Cube> vanillaCubes = Lists.newArrayList();
    private int u;
    private int v;
    private boolean mirror;

    CustomizableCubeListBuilder() {
    }

    public static CustomizableCubeListBuilder create() {
        return new CustomizableCubeListBuilder();
    }

    public CustomizableCubeListBuilder uv(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public CustomizableCubeListBuilder mirror(boolean bl) {
        this.mirror = bl;
        return this;
    }

    public List<CustomizableCube> getCubes() {
        return this.cubes;
    }

    public List<ModelPart.Cube> getVanillaCubes() {
        return this.vanillaCubes;
    }

    public CustomizableCubeListBuilder addBox(float x, float y, float z, float pixelSize, Direction[] hide, Direction[][] corners) {
        int textureSize = 64;
        this.cubes.add(new CustomizableCube(this.u, this.v, x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, textureSize, textureSize, hide, corners));
        return this;
    }

    public CustomizableCubeListBuilder addVanillaBox(float x, float y, float z, float width, float height, float depth, float pixelSize) {
        int textureSize = 64;
        CubeListBuilder cubeList = CubeListBuilder.m_171558_();
        cubeList.m_171514_(this.u, this.v).m_171481_(x, y, z, width, height, depth);
        this.vanillaCubes.add(((CubeDefinition)cubeList.m_171557_().get(0)).m_171455_(textureSize, textureSize));
        return this;
    }
}

