/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.client.DecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationClientHandler {
    private static final Map<MapDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends CustomMapDecoration> void registerCustomRenderer(MapDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        RENDERERS.put(type, renderer);
    }

    private static <T extends CustomMapDecoration> DecorationRenderer<T> simpleRenderer(MapDecorationType<T, ?> type) {
        ResourceLocation id = Utils.getID(type);
        ResourceLocation texture = new ResourceLocation(id.m_135827_(), "textures/map_markers/" + id.m_135815_() + ".png");
        return new DecorationRenderer(texture);
    }

    @ApiStatus.Internal
    public static <E extends CustomMapDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return RENDERERS.computeIfAbsent(decoration.getType(), t -> MapDecorationClientHandler.simpleRenderer(decoration.getType()));
    }

    @ApiStatus.Internal
    public static <T extends CustomMapDecoration> boolean render(T decoration, PoseStack matrixStack, MultiBufferSource buffer, MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = MapDecorationClientHandler.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }
}

