/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.locks.StampedLock;

public class DoubleBufferedLong2IntHashMap {
    private final Long2IntMap mapPending;
    private Long2IntMap mapLocal;
    private Long2IntMap mapShared;
    private final StampedLock lock = new StampedLock();

    public DoubleBufferedLong2IntHashMap() {
        this(16, 0.5f);
    }

    public DoubleBufferedLong2IntHashMap(int capacity, float loadFactor) {
        this.mapLocal = new Long2IntOpenHashMap(capacity, loadFactor);
        this.mapShared = new Long2IntOpenHashMap(capacity, loadFactor);
        this.mapPending = new Long2IntOpenHashMap(capacity, loadFactor);
    }

    public void defaultReturnValueSync(int v) {
        this.mapLocal.defaultReturnValue(v);
    }

    public int putSync(long k, int v) {
        if (v == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value Integer.MIN_VALUE cannot be used");
        }
        this.mapPending.put(k, v);
        return this.mapLocal.put(k, v);
    }

    public int removeSync(long k) {
        this.mapPending.put(k, Integer.MIN_VALUE);
        return this.mapLocal.remove(k);
    }

    public int getSync(long k) {
        return this.mapLocal.get(k);
    }

    public int getAsync(long k) {
        long stamp;
        int ret = Integer.MIN_VALUE;
        do {
            stamp = this.lock.tryOptimisticRead();
            try {
                ret = this.mapShared.get(k);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        } while (!this.lock.validate(stamp));
        return ret;
    }

    public void flushChangesSync() {
        if (this.mapPending.isEmpty()) {
            return;
        }
        this.swapTables();
        for (Long2IntMap.Entry entry : Long2IntMaps.fastIterable((Long2IntMap)this.mapPending)) {
            long key = entry.getLongKey();
            int val = entry.getIntValue();
            if (val == Integer.MIN_VALUE) {
                this.mapLocal.remove(key);
                continue;
            }
            this.mapLocal.put(key, val);
        }
        this.mapLocal.defaultReturnValue(this.mapShared.defaultReturnValue());
        this.mapPending.clear();
    }

    private void swapTables() {
        long writeLock = this.lock.writeLock();
        Long2IntMap mapShared = this.mapLocal;
        Long2IntMap mapLocal = this.mapShared;
        this.mapShared = mapShared;
        this.mapLocal = mapLocal;
        this.lock.unlockWrite(writeLock);
    }

    public Long2IntOpenHashMap createSyncView() {
        return new Long2IntOpenHashMap(){

            public int size() {
                return DoubleBufferedLong2IntHashMap.this.mapLocal.size();
            }

            public void defaultReturnValue(int rv) {
                DoubleBufferedLong2IntHashMap.this.defaultReturnValueSync(rv);
            }

            public int defaultReturnValue() {
                return DoubleBufferedLong2IntHashMap.this.mapLocal.defaultReturnValue();
            }

            public boolean containsKey(long key) {
                return DoubleBufferedLong2IntHashMap.this.mapLocal.containsKey(key);
            }

            public boolean containsValue(int value) {
                return DoubleBufferedLong2IntHashMap.this.mapLocal.containsValue(value);
            }

            public int get(long key) {
                return DoubleBufferedLong2IntHashMap.this.getSync(key);
            }

            public int put(long key, int value) {
                return DoubleBufferedLong2IntHashMap.this.putSync(key, value);
            }

            public int remove(long key) {
                return DoubleBufferedLong2IntHashMap.this.removeSync(key);
            }

            public boolean isEmpty() {
                return DoubleBufferedLong2IntHashMap.this.mapLocal.isEmpty();
            }
        };
    }
}

