/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import fuzs.puzzleslib.util.CreativeModeTabBuilder;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface CommonAbstractions {
    public static final CommonAbstractions INSTANCE = PuzzlesUtil.loadServiceProvider(CommonAbstractions.class);

    default public void openMenu(ServerPlayer player, MenuProvider menuProvider) {
        this.openMenu(player, menuProvider, (serverPlayer, buf) -> {});
    }

    public void openMenu(ServerPlayer var1, MenuProvider var2, BiConsumer<ServerPlayer, FriendlyByteBuf> var3);

    @Deprecated(forRemoval=true)
    default public StairBlock stairBlock(Supplier<BlockState> blockState, BlockBehaviour.Properties properties) {
        return new StairBlock(blockState.get(), properties);
    }

    @Deprecated(forRemoval=true)
    default public DamageSource damageSource(String messageId) {
        return new DamageSource(messageId);
    }

    @Deprecated(forRemoval=true)
    default public CreativeModeTab creativeTab(String modId, Supplier<ItemStack> stackSupplier) {
        return this.creativeModeTab(modId, stackSupplier);
    }

    @Deprecated(forRemoval=true)
    default public CreativeModeTab creativeTab(String modId, String tabId, Supplier<ItemStack> stackSupplier) {
        return this.creativeModeTabBuilder(modId, tabId).setIcon(stackSupplier).build();
    }

    @Deprecated(forRemoval=true)
    default public CreativeModeTab creativeTab(String modId, String tabId, Supplier<ItemStack> stackSupplier, boolean cacheIcon, @Nullable BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay) {
        CreativeModeTabBuilder tabBuilder = this.creativeModeTabBuilder(modId, tabId).setIcon(stackSupplier);
        if (!cacheIcon) {
            tabBuilder.disableIconCache();
        }
        if (stacksForDisplay != null) {
            tabBuilder.appendItemsV2(stacksForDisplay::accept);
        }
        return tabBuilder.build();
    }

    default public CreativeModeTab creativeModeTab(String modId, Supplier<ItemStack> stackSupplier) {
        return this.creativeModeTabBuilder(modId).setIcon(stackSupplier).build();
    }

    default public CreativeModeTabBuilder creativeModeTabBuilder(String modId) {
        return this.creativeModeTabBuilder(modId, "main");
    }

    public CreativeModeTabBuilder creativeModeTabBuilder(String var1, String var2);
}

