/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.Reference;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.IPConfigGUI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;

@OnlyIn(value=Dist.CLIENT)
public class ClientDebugCommand {
    @SubscribeEvent
    public static void register(RegisterClientCommandsEvent event) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return;
        }
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"imm_ptl_client_debug").requires(commandSource -> true)).then(Commands.m_82127_((String)"set_max_portal_layer").then(Commands.m_82129_((String)"argMaxPortalLayer", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ClientDebugCommand.setMaxPortalLayer(IntegerArgumentType.getInteger((CommandContext)context, (String)"argMaxPortalLayer")))));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"list_portals").executes(context -> {
            RemoteCallables.doListPortals();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"is_client_chunk_loaded").then(Commands.m_82129_((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(ClientDebugCommand::isClientChunkLoaded))));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"report_player_status").executes(context -> {
            RemoteCallables.reportClientPlayerStatus();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"client_remote_ticking_enable").executes(context -> {
            IPCGlobal.isClientRemoteTickingEnabled = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"client_remote_ticking_disable").executes(context -> {
            IPCGlobal.isClientRemoteTickingEnabled = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"advanced_frustum_culling_enable").executes(context -> {
            IPCGlobal.doUseAdvancedFrustumCulling = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"advanced_frustum_culling_disable").executes(context -> {
            IPCGlobal.doUseAdvancedFrustumCulling = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"report_resource_consumption").executes(context1 -> {
            RemoteCallables.reportResourceConsumption();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"report_render_info_num").executes(context -> {
            String str = Helper.myToString(IPCGlobal.renderInfoNumMap.entrySet().stream());
            ((CommandSourceStack)context.getSource()).m_230896_().m_5661_((Component)Component.m_237113_((String)str), false);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"get_player_colliding_portal_client").executes(context -> {
            Portal collidingPortal = ((IEEntity)Minecraft.m_91087_().f_91074_).getCollidingPortal();
            CHelper.printChat(collidingPortal != null ? collidingPortal.toString() : "null");
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"report_rendering").executes(context -> {
            String str = RenderStates.lastPortalRenderInfos.stream().map(list -> list.stream().map(Reference::get).collect(Collectors.toList())).collect(Collectors.toList()).toString();
            CHelper.printChat(str);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"vanilla_chunk_culling_enable").executes(context -> {
            Minecraft.m_91087_().f_90980_ = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"vanilla_chunk_culling_disable").executes(context -> {
            Minecraft.m_91087_().f_90980_ = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"render_mode_normal").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.normal;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"render_mode_compatibility").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.compatibility;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"render_mode_debug").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.debug;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"render_mode_none").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.none;
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"check_client_light").executes(context -> {
            Minecraft client = Minecraft.m_91087_();
            client.execute(() -> client.f_91073_.m_7726_().m_7827_().m_6191_(SectionPos.m_123199_((BlockPos)new BlockPos(client.f_91074_.m_20182_())), false));
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"report_client_entities").executes(context -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            CHelper.printChat("client entity manager:");
            for (Entity entity : world.m_104735_()) {
                CHelper.printChat(entity.toString());
            }
            CHelper.printChat("client entity list:");
            EntityTickList entityList = ((IEClientWorld)world).ip_getEntityList();
            entityList.m_156910_(e -> CHelper.printChat(e.toString()));
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"check_server_light").executes(context -> {
            MiscHelper.getServer().execute(() -> {
                ServerPlayer player = McHelper.getRawPlayerList().get(0);
                BlockPos.m_121990_((BlockPos)player.m_20183_().m_7918_(-2, -2, -2), (BlockPos)player.m_20183_().m_7918_(2, 2, 2)).forEach(blockPos -> player.f_19853_.m_5518_().m_7174_(blockPos));
            });
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"update_server_light").executes(context -> {
            MiscHelper.getServer().execute(() -> {
                ServerPlayer player = McHelper.getRawPlayerList().get(0);
                ThreadedLevelLightEngine lightingProvider = (ThreadedLevelLightEngine)player.f_19853_.m_5518_();
                lightingProvider.m_9353_(player.f_19853_.m_46865_(player.m_20183_()), false);
            });
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"report_rebuild_status").executes(context -> {
            Minecraft.m_91087_().execute(() -> ClientWorldLoader.getClientWorlds().forEach(world -> {
                MyBuiltChunkStorage builtChunkStorage = (MyBuiltChunkStorage)((IEWorldRenderer)ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)world.m_46472_())).ip_getBuiltChunkStorage();
                CHelper.printChat(world.m_46472_().m_135782_().toString() + builtChunkStorage.getDebugString());
            }));
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"report_portal_groups").executes(context -> {
            for (ClientLevel clientWorld : ClientWorldLoader.getClientWorlds()) {
                Map<Optional, List<Portal>> result = Streams.stream((Iterable)clientWorld.m_104735_()).flatMap(entity -> entity instanceof Portal ? Stream.of((Portal)entity) : Stream.empty()).collect(Collectors.groupingBy(p -> Optional.ofNullable(PortalRenderInfo.getGroupOf(p))));
                CHelper.printChat("\n" + clientWorld.m_46472_().m_135782_().toString());
                result.forEach((g, l) -> {
                    CHelper.printChat("\n" + g.toString());
                    CHelper.printChat(l.stream().map(Portal::toString).collect(Collectors.joining("\n")));
                });
            }
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"report_client_light_status").executes(context -> {
            Minecraft.m_91087_().execute(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                DataLayer lightSection = player.f_19853_.m_5518_().m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123199_((BlockPos)player.m_20183_()));
                if (lightSection != null) {
                    boolean uninitialized = lightSection.m_62575_();
                    byte[] byteArray = lightSection.m_7877_();
                    boolean allZero = true;
                    for (byte b : byteArray) {
                        if (b == 0) continue;
                        allZero = false;
                        break;
                    }
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("has light section " + (allZero ? "all zero" : "not all zero") + (uninitialized ? " uninitialized" : " fine"))), true);
                } else {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"does not have light section"));
                }
            });
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"reload_world_renderer").executes(context -> {
            Minecraft.m_91087_().execute(() -> {
                ClientWorldLoader.disposeRenderHelpers();
                Minecraft.m_91087_().f_91060_.m_109818_();
            });
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"config").executes(context -> {
            Minecraft client = Minecraft.m_91087_();
            IPGlobal.clientTaskList.addTask(MyTaskList.oneShotTask(() -> client.m_91152_(IPConfigGUI.createClothConfigScreen(null))));
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"disable_warning").executes(context -> {
            ClientDebugCommand.disableWarning();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"imm_ptl.warning_disabled"), true);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"view_portal_data").executes(context -> {
            Minecraft client = Minecraft.m_91087_();
            Pair pair = PortalCommand.getPlayerPointingPortalRaw((Player)client.f_91074_, 0.0f, 50.0, true).orElse(null);
            if (pair != null) {
                Portal portal = (Portal)pair.getFirst();
                PortalCommand.sendPortalInfo(c -> {
                    ((CommandSourceStack)context.getSource()).m_81354_(c, true);
                    Helper.log(c.getString());
                }, portal);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No pointing to a portal."));
            }
            return 0;
        }));
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "front_clipping", cond -> {
            IPCGlobal.useFrontClipping = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "gl_check_error", cond -> {
            IPGlobal.doCheckGlError = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "early_light_update", cond -> {
            IPCGlobal.lateClientLightUpdate = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "early_remote_upload", cond -> {
            IPCGlobal.earlyRemoteUpload = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "super_advanced_frustum_culling", cond -> {
            IPCGlobal.useSuperAdvancedFrustumCulling = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "cross_portal_entity_rendering", cond -> {
            IPGlobal.correctCrossPortalEntityRendering = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "early_cull_portal", cond -> {
            IPCGlobal.earlyFrustumCullingPortal = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "cache_gl_buffer", cond -> {
            IPGlobal.cacheGlBuffer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "secondary_vertex_consumer", cond -> {
            IPGlobal.useSecondaryEntityVertexConsumer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "cull_sections_behind", cond -> {
            IPGlobal.cullSectionsBehind = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "offset_occlusion_query", cond -> {
            IPGlobal.offsetOcclusionQuery = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "cloud_optimization", cond -> {
            IPGlobal.cloudOptimization = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "cross_portal_collision", cond -> {
            IPGlobal.crossPortalCollision = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "nofog", cond -> {
            IPGlobal.debugDisableFog = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "depth_clamp_for_portal_rendering", cond -> {
            IPGlobal.enableDepthClampForPortalRendering = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "shared_block_mesh_builder", cond -> {
            IPGlobal.enableSharedBlockMeshBuffers = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "entity_pos_interpolation", cond -> {
            IPGlobal.allowClientEntityPosInterpolation = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "always_override_terrain_setup", cond -> {
            IPGlobal.alwaysOverrideTerrainSetup = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "view_bob_reduce", cond -> {
            IPGlobal.viewBobbingReduce = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "iris_stencil", cond -> {
            IPCGlobal.debugEnableStencilWithIris = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "another_stencil", cond -> {
            IPCGlobal.useAnotherStencilFormat = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "experimental_iris_portal_renderer", cond -> {
            IPCGlobal.experimentalIrisPortalRenderer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, "portal_rendering_cave_culling", cond -> {
            MyGameRenderer.enablePortalCaveCulling = cond;
        });
        builder.then(Commands.m_82127_((String)"print_class_path").executes(context -> {
            ClientDebugCommand.printClassPath();
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"test_invalid_rpc").executes(context -> {
            McRemoteProcedureCall.tellServerToInvoke("aaa.bbb.WrongClassRemoteCallable.method", new Object[0]);
            return 0;
        }));
        dispatcher.register(builder);
    }

    private static void printClassPath() {
        System.out.println(Arrays.stream(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()).map(url -> "\"" + url.getFile().substring(1).replace("%20", " ") + "\"").collect(Collectors.joining(",\n")));
    }

    private static void registerSwitchCommand(LiteralArgumentBuilder<CommandSourceStack> builder, String name, Consumer<Boolean> setFunction) {
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)(name + "_enable")).executes(context -> {
            setFunction.accept(true);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)(name + "_disable")).executes(context -> {
            setFunction.accept(false);
            return 0;
        }));
    }

    private static int isClientChunkLoaded(CommandContext<CommandSourceStack> context) {
        int chunkX = IntegerArgumentType.getInteger(context, (String)"chunkX");
        int chunkZ = IntegerArgumentType.getInteger(context, (String)"chunkZ");
        RemoteCallables.reportClientChunkLoadStatus(chunkX, chunkZ);
        return 0;
    }

    private static int setMaxPortalLayer(int m) {
        IPGlobal.maxPortalLayer = m;
        return 0;
    }

    private static void testRemoteProcedureCall(ServerPlayer player) {
        Minecraft.m_91087_().execute(() -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("test", (Tag)IntTag.m_128679_((int)7));
            McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.core.commands.ClientDebugCommand.TestRemoteCallable.clientToServer", new UUID(3L, 3L), Blocks.f_50744_, Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)Direction.Axis.Z), Items.f_42522_, new ItemStack((ItemLike)Items.f_41841_, 2), compoundTag, Component.m_237113_((String)"test"), new int[]{777, 765});
        });
        MiscHelper.getServer().execute(() -> McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.TestRemoteCallable.serverToClient", "string", 2, 3.5, new ResourceLocation("imm_ptl:oops"), Level.f_46429_, Biomes.f_48222_, new BlockPos(3, 5, 4), new Vec3(7.0, 4.0, 1.0)));
    }

    public static void disableWarning() {
        IPConfig ipConfig = IPConfig.readConfig();
        ipConfig.enableWarning = false;
        ipConfig.saveConfigFile();
    }

    public static class RemoteCallables {
        public static void reportClientChunkLoadStatus(int chunkX, int chunkZ) {
            LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_6325_(chunkX, chunkZ);
            CHelper.printChat(chunk != null && !(chunk instanceof EmptyLevelChunk) ? "client loaded" : "client not loaded");
        }

        public static void reportClientPlayerStatus() {
            LocalPlayer playerSP = Minecraft.m_91087_().f_91074_;
            CHelper.printChat(String.format("On Client %s %s removal:%s added:%s age:%s", playerSP.f_19853_.m_46472_().m_135782_(), playerSP.m_20183_(), playerSP.m_146911_(), playerSP.f_19853_.m_6815_(playerSP.m_19879_()) != null, playerSP.f_19797_));
        }

        public static void doListPortals() {
            StringBuilder result = new StringBuilder();
            result.append("Client Portals\n");
            ClientWorldLoader.getClientWorlds().forEach(world -> {
                result.append(world.m_46472_().m_135782_().toString() + "\n");
                for (Entity e : world.m_104735_()) {
                    if (!(e instanceof Portal)) continue;
                    result.append(e.toString());
                    result.append("\n");
                }
            });
            CHelper.printChat(result.toString());
        }

        public static void reportResourceConsumption() {
            StringBuilder str = new StringBuilder();
            str.append("Client Chunk:\n");
            ClientWorldLoader.getClientWorlds().forEach(world -> str.append(String.format("%s %s\n", world.m_46472_().m_135782_(), world.m_7726_().m_8482_())));
            str.append("Chunk Mesh Sections:\n");
            ClientWorldLoader.worldRendererMap.forEach((dimension, worldRenderer) -> str.append(String.format("%s %s\n", dimension.m_135782_(), ((MyBuiltChunkStorage)((IEWorldRenderer)worldRenderer).ip_getBuiltChunkStorage()).getManagedSectionNum())));
            String result = str.toString();
            CHelper.printChat(result);
        }

        public static void setNoFog(boolean cond) {
            IPGlobal.debugDisableFog = cond;
        }
    }

    public static class TestRemoteCallable {
        public static void serverToClient(String str, int integer, double doubleNum, ResourceLocation identifier, ResourceKey<Level> dimension, ResourceKey<Biome> biomeKey, BlockPos blockPos, Vec3 vec3d) {
            Helper.log(str + integer + doubleNum + identifier + dimension + biomeKey + blockPos + vec3d);
        }

        public static void clientToServer(ServerPlayer player, UUID uuid, Block block, BlockState blockState, Item item, ItemStack itemStack, CompoundTag compoundTag, Component text, int[] intArray) {
            Helper.log(player.m_7755_().getString() + uuid + block + blockState + item + itemStack + compoundTag + text.getString() + Arrays.toString(intArray));
        }
    }
}

