/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGameRule;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackScreen;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DimId;

public class DimStackManagement {
    public static DimStackInfo dimStackToApply = null;
    public static Map<ResourceKey<Level>, BlockState> bedrockReplacementMap = new HashMap<ResourceKey<Level>, BlockState>();

    public static void init() {
    }

    public static void onServerEarlyInit(MinecraftServer server) {
        HashMap<ResourceKey<Level>, BlockState> newMap = new HashMap<ResourceKey<Level>, BlockState>();
        if (dimStackToApply != null) {
            for (DimStackEntry entry : DimStackManagement.dimStackToApply.entries) {
                newMap.put(entry.getDimension(), DimStackInfo.parseBlockString(entry.bedrockReplacementStr));
            }
        }
        bedrockReplacementMap = newMap;
    }

    public static void onServerCreatedWorlds(MinecraftServer server) {
        if (dimStackToApply != null) {
            dimStackToApply.apply();
            dimStackToApply = null;
        } else {
            DimStackManagement.updateBedrockReplacementFromStorage(server);
            GameRules gameRules = server.m_129900_();
            GameRules.BooleanValue o = (GameRules.BooleanValue)gameRules.m_46170_(DimStackGameRule.dimensionStackKey);
            if (o.m_46223_()) {
                o.m_46246_(false, server);
                DimStackManagement.upgradeLegacyDimensionStack(server);
            }
        }
    }

    private static void updateBedrockReplacementFromStorage(MinecraftServer server) {
        HashMap<ResourceKey<Level>, BlockState> newMap = new HashMap<ResourceKey<Level>, BlockState>();
        for (ServerLevel world : server.m_129785_()) {
            BlockState replacement = GlobalPortalStorage.get((ServerLevel)world).bedrockReplacement;
            newMap.put((ResourceKey<Level>)world.m_46472_(), replacement);
            Helper.log(String.format("Bedrock Replacement %s %s", world.m_46472_().m_135782_(), replacement != null ? Registry.f_122824_.m_7981_((Object)replacement.m_60734_()) : "null"));
        }
        bedrockReplacementMap = newMap;
    }

    public static void upgradeLegacyDimensionStack(MinecraftServer server) {
        for (ServerLevel world : server.m_129785_()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world);
            gps.bedrockReplacement = Blocks.f_50080_.m_49966_();
            gps.onDataChanged();
        }
        DimStackManagement.updateBedrockReplacementFromStorage(server);
        Helper.log("Legacy Dimension Stack Upgraded");
    }

    public static void replaceBedrock(ServerLevel world, ChunkAccess chunk) {
        if (bedrockReplacementMap == null) {
            Helper.err("Dimension Stack Bedrock Replacement Abnormal");
            return;
        }
        BlockState replacement = bedrockReplacementMap.get(world.m_46472_());
        if (replacement != null) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.m_141937_(); y < chunk.m_151558_(); ++y) {
                        mutable.m_122178_(x, y, z);
                        BlockState blockState = chunk.m_8055_((BlockPos)mutable);
                        if (blockState.m_60734_() != Blocks.f_50752_) continue;
                        chunk.m_6978_((BlockPos)mutable, replacement, false);
                    }
                }
            }
        }
    }

    private static void clearDimStackPortals() {
        MinecraftServer server = MiscHelper.getServer();
        for (ServerLevel world : server.m_129785_()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world);
            gps.data.removeIf(p -> p instanceof VerticalConnectingPortal);
            gps.bedrockReplacement = null;
            gps.onDataChanged();
        }
        DimStackManagement.updateBedrockReplacementFromStorage(server);
    }

    public static class RemoteCallables {
        @OnlyIn(value=Dist.CLIENT)
        public static void clientOpenScreen(List<String> dimensions) {
            List dimensionList = dimensions.stream().map(DimId::idToKey).collect(Collectors.toList());
            Minecraft.m_91087_().m_91152_((Screen)new DimStackScreen(null, screen -> dimensionList, dimStackInfo -> {
                if (dimStackInfo != null) {
                    McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverSetupDimStack", dimStackInfo);
                } else {
                    McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverRemoveDimStack", new Object[0]);
                }
            }));
        }

        public static void serverSetupDimStack(ServerPlayer player, DimStackInfo dimStackInfo) {
            if (!player.m_20310_(2)) {
                Helper.err("one player without permission tries to change dimension stack");
                return;
            }
            DimStackManagement.clearDimStackPortals();
            dimStackInfo.apply();
            player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.dim_stack_established"), false);
        }

        public static void serverRemoveDimStack(ServerPlayer player) {
            if (!player.m_20310_(2)) {
                Helper.err("one player without permission tries to change dimension stack");
                return;
            }
            DimStackManagement.clearDimStackPortals();
            player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.dim_stack_removed"), false);
        }
    }
}

